/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.genetic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.ml.genetic.Chromosome;
import org.apache.ignite.ml.genetic.TruncateSelectionJob;
import org.apache.ignite.resources.IgniteInstanceResource;

public class TruncateSelectionTask
extends ComputeTaskAdapter<List<Long>, Boolean> {
    @IgniteInstanceResource
    private Ignite ignite = null;
    private List<Long> fittestKeys;
    private int numOfCopies;

    public TruncateSelectionTask(List<Long> fittestKeys, int numOfCopies) {
        this.fittestKeys = fittestKeys;
        this.numOfCopies = numOfCopies;
    }

    private Chromosome getChromosome(Long key) {
        IgniteCache cache = this.ignite.cache("populationCache");
        StringBuffer sbSqlClause = new StringBuffer();
        sbSqlClause.append("_key IN (");
        sbSqlClause.append(key);
        sbSqlClause.append(")");
        Chromosome chromosome = null;
        SqlQuery sql = new SqlQuery(Chromosome.class, sbSqlClause.toString());
        try (QueryCursor cursor = cache.query((Query)sql);){
            for (Cache.Entry e : cursor) {
                chromosome = (Chromosome)e.getValue();
            }
        }
        return chromosome;
    }

    private List<List<Long>> getEnhancedPopulation() {
        ArrayList<List<Long>> list = new ArrayList<List<Long>>();
        for (Long key : this.fittestKeys) {
            Chromosome cp = this.getChromosome(key);
            for (int i = 0; i < this.numOfCopies; ++i) {
                long[] thegenes = cp.getGenes();
                ArrayList<Long> geneList = new ArrayList<Long>();
                for (int k = 0; k < cp.getGenes().length; ++k) {
                    geneList.add(thegenes[k]);
                }
                list.add(geneList);
            }
        }
        return list;
    }

    public Map map(List<ClusterNode> nodes, List<Long> chromosomeKeys) throws IgniteException {
        HashMap<TruncateSelectionJob, ClusterNode> map = new HashMap<TruncateSelectionJob, ClusterNode>();
        Affinity affinity = this.ignite.affinity("populationCache");
        List<List<Long>> enhancedPopulation = this.getEnhancedPopulation();
        int k = 0;
        for (Long key : chromosomeKeys) {
            TruncateSelectionJob ajob = new TruncateSelectionJob(key, enhancedPopulation.get(k));
            ClusterNode primary = affinity.mapKeyToNode((Object)key);
            map.put(ajob, primary);
            ++k;
        }
        return map;
    }

    public Boolean reduce(List<ComputeJobResult> list) throws IgniteException {
        return Boolean.TRUE;
    }

    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
        IgniteException err = res.getException();
        if (err != null) {
            return ComputeJobResultPolicy.FAILOVER;
        }
        return ComputeJobResultPolicy.WAIT;
    }
}

