/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.genetic;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.ml.genetic.Chromosome;
import org.apache.ignite.ml.genetic.CrossOverTask;
import org.apache.ignite.ml.genetic.FitnessTask;
import org.apache.ignite.ml.genetic.Gene;
import org.apache.ignite.ml.genetic.MutateTask;
import org.apache.ignite.ml.genetic.TruncateSelectionTask;
import org.apache.ignite.ml.genetic.cache.GeneCacheConfig;
import org.apache.ignite.ml.genetic.cache.PopulationCacheConfig;
import org.apache.ignite.ml.genetic.parameter.GAConfiguration;
import org.apache.ignite.ml.genetic.parameter.GAGridConstants;

public class GAGrid {
    private IgniteLogger igniteLog;
    private GAConfiguration cfg;
    private Ignite ignite;
    private IgniteCache<Long, Chromosome> populationCache;
    private IgniteCache<Long, Gene> geneCache;
    private List<Long> populationKeys = new ArrayList<Long>();

    public GAGrid(GAConfiguration cfg, Ignite ignite) {
        this.ignite = ignite;
        this.cfg = cfg;
        this.ignite = ignite;
        this.igniteLog = ignite.log();
        this.populationCache = this.ignite.getOrCreateCache(PopulationCacheConfig.populationCache());
        this.populationCache.clear();
        this.geneCache = this.ignite.getOrCreateCache(GeneCacheConfig.geneCache());
        this.geneCache.clear();
    }

    private Double calculateAverageFitness() {
        double avgFitnessScore = 0.0;
        IgniteCache cache = this.ignite.cache("populationCache");
        SqlFieldsQuery sql = new SqlFieldsQuery("select AVG(FITNESSSCORE) from Chromosome");
        try (FieldsQueryCursor cursor = cache.query(sql);){
            for (List row : cursor) {
                avgFitnessScore = (Double)row.get(0);
            }
        }
        return avgFitnessScore;
    }

    private void calculateFitness(List<Long> chromosomeKeys) {
        this.ignite.compute().execute((ComputeTask)new FitnessTask(this.cfg), chromosomeKeys);
    }

    private Boolean copyFitterChromosomesToPopulation(List<Long> fittestKeys, List<Long> selectedKeys) {
        double truncatePercentage = this.cfg.getTruncateRate();
        int totalSize = this.populationKeys.size();
        int truncateCnt = (int)(truncatePercentage * (double)totalSize);
        int numOfCopies = selectedKeys.size() / truncateCnt;
        return (Boolean)this.ignite.compute().execute((ComputeTask)new TruncateSelectionTask(fittestKeys, numOfCopies), selectedKeys);
    }

    private Chromosome createChromosome(int numOfGenes) {
        long[] genes = new long[numOfGenes];
        ArrayList<Long> keys = new ArrayList<Long>();
        int k = 0;
        while (k < numOfGenes) {
            long key = this.selectGene(k);
            if (keys.contains(key)) continue;
            genes[k] = key;
            keys.add(key);
            ++k;
        }
        return new Chromosome(genes);
    }

    private void crossover(List<Long> leastFitKeys) {
        this.ignite.compute().execute((ComputeTask)new CrossOverTask(this.cfg), leastFitKeys);
    }

    public Chromosome evolve() {
        int generationCnt = 1;
        this.initializeGenePopulation();
        this.intializePopulation();
        this.calculateFitness(this.populationKeys);
        List<Long> keys = this.getChromosomesByFittest();
        double averageFitnessScore = this.calculateAverageFitness();
        Chromosome fittestChomosome = (Chromosome)this.populationCache.get((Object)keys.get(0));
        while (!this.cfg.getTerminateCriteria().isTerminationConditionMet(fittestChomosome, averageFitnessScore, generationCnt)) {
            ++generationCnt;
            List<Long> selectedKeysforCrossMutaton = this.selection(keys);
            this.crossover(selectedKeysforCrossMutaton);
            this.mutation(selectedKeysforCrossMutaton);
            this.calculateFitness(selectedKeysforCrossMutaton);
            keys = this.getChromosomesByFittest();
            fittestChomosome = (Chromosome)this.populationCache.get((Object)keys.get(0));
            averageFitnessScore = this.calculateAverageFitness();
        }
        return fittestChomosome;
    }

    private List<Long> getChromosomesByFittest() {
        ArrayList<Long> orderChromKeysByFittest = new ArrayList<Long>();
        String orderDirection = "desc";
        if (!this.cfg.isHigherFitnessValFitter()) {
            orderDirection = "asc";
        }
        String fittestSQL = "select _key from Chromosome order by fitnessScore " + orderDirection;
        FieldsQueryCursor cursor = this.populationCache.query(new SqlFieldsQuery(fittestSQL));
        List res = cursor.getAll();
        for (List row : res) {
            Long key = (Long)row.get(0);
            orderChromKeysByFittest.add(key);
        }
        return orderChromKeysByFittest;
    }

    private List<Long> getFittestKeysForTruncation(List<Long> keys) {
        double truncatePercentage = this.cfg.getTruncateRate();
        int truncateCnt = (int)(truncatePercentage * (double)keys.size());
        return keys.subList(0, truncateCnt);
    }

    void initializeGenePopulation() {
        this.geneCache.clear();
        List<Gene> genePool = this.cfg.getGenePool();
        for (Gene gene : genePool) {
            this.geneCache.put((Object)gene.id(), (Object)gene);
        }
    }

    void initializePopulation() {
        int populationSize = this.cfg.getPopulationSize();
        this.populationCache.clear();
        for (int j = 0; j < populationSize; ++j) {
            Chromosome chromosome = this.createChromosome(this.cfg.getChromosomeLen());
            this.populationCache.put((Object)chromosome.id(), (Object)chromosome);
            this.populationKeys.add(chromosome.id());
        }
    }

    void intializePopulation() {
        int populationSize = this.cfg.getPopulationSize();
        this.populationCache.clear();
        for (int j = 0; j < populationSize; ++j) {
            Chromosome chromosome = this.createChromosome(this.cfg.getChromosomeLen());
            this.populationCache.put((Object)chromosome.id(), (Object)chromosome);
            this.populationKeys.add(chromosome.id());
        }
    }

    private void mutation(List<Long> leastFitKeys) {
        this.ignite.compute().execute((ComputeTask)new MutateTask(this.cfg), leastFitKeys);
    }

    private long selectAnyGene() {
        int idx = this.selectRandomIndex(this.cfg.getGenePool().size());
        Gene gene = this.cfg.getGenePool().get(idx);
        return gene.id();
    }

    private List<Long> selectByElitism(List<Long> keys) {
        int elitismCnt = this.cfg.getElitismCnt();
        return keys.subList(elitismCnt, keys.size());
    }

    private List<Long> selectByTruncation(List<Long> keys) {
        double truncatePercentage = this.cfg.getTruncateRate();
        int truncateCnt = (int)(truncatePercentage * (double)keys.size());
        return keys.subList(truncateCnt, keys.size());
    }

    private long selectGene(int k) {
        if (this.cfg.getChromosomeCriteria() == null) {
            return this.selectAnyGene();
        }
        return this.selectGeneByChromsomeCriteria(k);
    }

    private long selectGeneByChromsomeCriteria(int k) {
        ArrayList<Object> genes = new ArrayList<Object>();
        StringBuffer sbSqlClause = new StringBuffer("_val like '");
        sbSqlClause.append("%");
        sbSqlClause.append(this.cfg.getChromosomeCriteria().getCriteria().get(k));
        sbSqlClause.append("%'");
        IgniteCache cache = this.ignite.cache("geneCache");
        SqlQuery sql = new SqlQuery(Gene.class, sbSqlClause.toString());
        try (QueryCursor cursor = cache.query((Query)sql);){
            for (Cache.Entry e : cursor) {
                genes.add(e.getValue());
            }
        }
        int idx = this.selectRandomIndex(genes.size());
        Gene gene = (Gene)genes.get(idx);
        return gene.id();
    }

    private int selectRandomIndex(int sizeOfGenePool) {
        Random randomGenerator = new Random();
        return randomGenerator.nextInt(sizeOfGenePool);
    }

    private List<Long> selection(List<Long> chromosomeKeys) {
        List<Long> selectedKeys = new ArrayList<Long>();
        GAGridConstants.SELECTION_METHOD selectionMtd = this.cfg.getSelectionMtd();
        switch (selectionMtd) {
            case SELECTON_METHOD_ELETISM: {
                selectedKeys = this.selectByElitism(chromosomeKeys);
                break;
            }
            case SELECTION_METHOD_TRUNCATION: {
                selectedKeys = this.selectByTruncation(chromosomeKeys);
                List<Long> fittestKeys = this.getFittestKeysForTruncation(chromosomeKeys);
                this.copyFitterChromosomesToPopulation(fittestKeys, selectedKeys);
                break;
            }
        }
        return selectedKeys;
    }

    List<Long> getPopulationKeys() {
        return this.populationKeys;
    }
}

