/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset.impl.cache;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.ml.dataset.Dataset;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.impl.cache.util.ComputeUtils;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.functions.IgniteBinaryOperator;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.functions.IgniteTriFunction;

public class CacheBasedDataset<K, V, C extends Serializable, D extends AutoCloseable>
implements Dataset<C, D> {
    private static final int RETRIES = 900;
    private static final int RETRY_INTERVAL = 1000;
    private final Ignite ignite;
    private final IgniteCache<K, V> upstreamCache;
    private final IgniteBiPredicate<K, V> filter;
    private final IgniteCache<Integer, C> datasetCache;
    private final PartitionDataBuilder<K, V, C, D> partDataBuilder;
    private final UUID datasetId;

    public CacheBasedDataset(Ignite ignite, IgniteCache<K, V> upstreamCache, IgniteBiPredicate<K, V> filter, IgniteCache<Integer, C> datasetCache, PartitionDataBuilder<K, V, C, D> partDataBuilder, UUID datasetId) {
        this.ignite = ignite;
        this.upstreamCache = upstreamCache;
        this.filter = filter;
        this.datasetCache = datasetCache;
        this.partDataBuilder = partDataBuilder;
        this.datasetId = datasetId;
    }

    @Override
    public <R> R computeWithCtx(IgniteTriFunction<C, D, Integer, R> map, IgniteBinaryOperator<R> reduce, R identity) {
        String upstreamCacheName = this.upstreamCache.getName();
        String datasetCacheName = this.datasetCache.getName();
        return this.computeForAllPartitions(part -> {
            Object ctx = ComputeUtils.getContext(Ignition.localIgnite(), datasetCacheName, part);
            D data = ComputeUtils.getData(Ignition.localIgnite(), upstreamCacheName, this.filter, datasetCacheName, this.datasetId, part, this.partDataBuilder);
            if (data != null) {
                Object res = map.apply(ctx, data, (Integer)part);
                ComputeUtils.saveContext(Ignition.localIgnite(), datasetCacheName, part, ctx);
                return res;
            }
            return null;
        }, reduce, identity);
    }

    @Override
    public <R> R compute(IgniteBiFunction<D, Integer, R> map, IgniteBinaryOperator<R> reduce, R identity) {
        String upstreamCacheName = this.upstreamCache.getName();
        String datasetCacheName = this.datasetCache.getName();
        return this.computeForAllPartitions(part -> {
            D data = ComputeUtils.getData(Ignition.localIgnite(), upstreamCacheName, this.filter, datasetCacheName, this.datasetId, part, this.partDataBuilder);
            return data != null ? map.apply(data, (Integer)part) : null;
        }, reduce, identity);
    }

    @Override
    public void close() {
        this.datasetCache.destroy();
        ComputeUtils.removeData(this.ignite, this.datasetId);
    }

    private <R> R computeForAllPartitions(IgniteFunction<Integer, R> fun, IgniteBinaryOperator<R> reduce, R identity) {
        List<String> cacheNames = Arrays.asList(this.datasetCache.getName(), this.upstreamCache.getName());
        Collection<R> results = ComputeUtils.affinityCallWithRetries(this.ignite, cacheNames, fun, 900, 1000);
        R res = identity;
        for (R partRes : results) {
            if (partRes == null) continue;
            res = reduce.apply(res, partRes);
        }
        return res;
    }

    public IgniteCache<K, V> getUpstreamCache() {
        return this.upstreamCache;
    }

    public IgniteCache<Integer, C> getDatasetCache() {
        return this.datasetCache;
    }
}

