/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.core.util;

import java.lang.management.ManagementFactory;
import java.util.Map;
import org.apache.ignite.tensorflow.util.SerializableSupplier;

public class PythonProcessBuilderSupplier
implements SerializableSupplier<ProcessBuilder> {
    private static final long serialVersionUID = 7181937306294456125L;
    private static final String PYTHON_ENV_NAME = "PYTHON";
    private final boolean interactive;
    private final String[] meta;

    public PythonProcessBuilderSupplier(boolean interactive, String ... meta) {
        this.interactive = interactive;
        this.meta = meta;
    }

    @Override
    public ProcessBuilder get() {
        ProcessBuilder procBldr;
        String python = System.getenv(PYTHON_ENV_NAME);
        if (python == null) {
            python = "python3";
        }
        if (this.interactive) {
            String[] cmd = new String[this.meta.length + 3];
            cmd[0] = python;
            cmd[1] = "-i";
            cmd[2] = "-";
            System.arraycopy(this.meta, 0, cmd, 3, this.meta.length);
            procBldr = new ProcessBuilder(cmd);
        } else {
            procBldr = new ProcessBuilder(python);
        }
        Map<String, String> env = procBldr.environment();
        env.put("PPID", String.valueOf(this.getProcessId()));
        return procBldr;
    }

    private long getProcessId() {
        String pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        return Long.parseLong(pid);
    }
}

