/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.core.nativerunning.task;

import java.util.function.Supplier;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.tensorflow.core.nativerunning.NativeProcess;
import org.apache.ignite.tensorflow.core.util.NativeProcessRunner;

public class NativeProcessStartTask
implements IgniteRunnable {
    private static final long serialVersionUID = 8421398298283116405L;
    private final NativeProcess procSpec;

    public NativeProcessStartTask(NativeProcess procSpec) {
        assert (procSpec != null) : "Process specification should not be null";
        this.procSpec = procSpec;
    }

    public void run() {
        Supplier<ProcessBuilder> procBuilderSupplier = this.procSpec.getProcBuilderSupplier();
        ProcessBuilder procBuilder = procBuilderSupplier.get();
        NativeProcessRunner procRunner = new NativeProcessRunner(procBuilder, this.procSpec.getStdin(), System.out::println, System.err::println);
        IgniteLogger log = Ignition.ignite().log().getLogger(NativeProcessStartTask.class);
        try {
            log.debug("Starting native process");
            procRunner.startAndWait();
            log.debug("Native process completed");
        }
        catch (InterruptedException e) {
            log.debug("Native process interrupted");
        }
        catch (Exception e) {
            log.error("Native process failed", (Throwable)e);
            throw e;
        }
    }
}

