/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.cluster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.tensorflow.cluster.TensorFlowCluster;
import org.apache.ignite.tensorflow.cluster.TensorFlowJobArchive;
import org.apache.ignite.tensorflow.cluster.spec.TensorFlowClusterSpec;
import org.apache.ignite.tensorflow.cluster.spec.TensorFlowServerAddressSpec;
import org.apache.ignite.tensorflow.cluster.tfrunning.TensorFlowServer;
import org.apache.ignite.tensorflow.cluster.tfrunning.TensorFlowServerManager;
import org.apache.ignite.tensorflow.cluster.util.TensorFlowChiefRunner;
import org.apache.ignite.tensorflow.cluster.util.TensorFlowClusterResolver;
import org.apache.ignite.tensorflow.cluster.util.TensorFlowUserScriptRunner;
import org.apache.ignite.tensorflow.core.util.CustomizableThreadFactory;

public class TensorFlowClusterManager {
    private static final String TF_CLUSTER_METADATA_CACHE_NAME = "TF_CLUSTER_METADATA_CACHE";
    private final Ignite ignite;
    private final TensorFlowServerManager srvProcMgr;
    private final TensorFlowClusterResolver clusterRslvr;
    private IgniteCache<UUID, TensorFlowCluster> cache;
    private ConcurrentMap<UUID, TensorFlowChiefRunner> chiefRunners;
    private ConcurrentMap<UUID, TensorFlowUserScriptRunner> userScriptRunners;

    public TensorFlowClusterManager(Ignite ignite) {
        assert (ignite != null) : "Ignite instance should not be null";
        this.ignite = ignite;
        this.srvProcMgr = new TensorFlowServerManager(ignite);
        this.clusterRslvr = new TensorFlowClusterResolver(ignite, "TF", 10000, 1000);
        this.cache = this.getOrCreateCache();
        this.chiefRunners = new ConcurrentHashMap<UUID, TensorFlowChiefRunner>();
        this.userScriptRunners = new ConcurrentHashMap<UUID, TensorFlowUserScriptRunner>();
    }

    public TensorFlowCluster getCluster(UUID clusterId) {
        return (TensorFlowCluster)this.cache.get((Object)clusterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TensorFlowCluster createCluster(UUID clusterId, TensorFlowJobArchive jobArchive, Consumer<String> userScriptOut, Consumer<String> userScriptErr) {
        Lock clusterMgrCacheLock = this.cache.lock((Object)clusterId);
        clusterMgrCacheLock.lock();
        try {
            TensorFlowCluster cluster = (TensorFlowCluster)this.cache.get((Object)clusterId);
            if (cluster != null) {
                throw new IllegalStateException("Cluster is already created [clusterId=" + clusterId + "]");
            }
            TensorFlowClusterSpec clusterSpec = this.clusterRslvr.resolveAndAcquirePorts(jobArchive.getUpstreamCacheName());
            cluster = this.startCluster(clusterId, clusterSpec, jobArchive, userScriptOut, userScriptErr);
            this.cache.put((Object)clusterId, (Object)cluster);
            TensorFlowCluster tensorFlowCluster = cluster;
            return tensorFlowCluster;
        }
        finally {
            clusterMgrCacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopClusterIfExists(UUID clusterId) {
        Lock clusterMgrCacheLock = this.cache.lock((Object)clusterId);
        clusterMgrCacheLock.lock();
        try {
            TensorFlowCluster cluster = (TensorFlowCluster)this.cache.get((Object)clusterId);
            if (cluster != null) {
                this.stopChief(clusterId);
                this.stopUserScript(clusterId);
                this.srvProcMgr.stop(cluster.getProcesses(), true);
                this.clusterRslvr.releasePorts(cluster.getSpec());
                this.cache.remove((Object)clusterId);
            }
        }
        finally {
            clusterMgrCacheLock.unlock();
        }
    }

    public void destroy() {
        this.clusterRslvr.destroy();
        this.ignite.destroyCache(TF_CLUSTER_METADATA_CACHE_NAME);
    }

    private TensorFlowCluster startCluster(UUID clusterId, TensorFlowClusterSpec spec, TensorFlowJobArchive jobArchive, Consumer<String> userScriptOut, Consumer<String> userScriptErr) {
        Map<String, List<TensorFlowServerAddressSpec>> jobs = spec.getJobs();
        Map<UUID, List<UUID>> workerProcesses = this.startWorkers(spec, jobs.get("worker"));
        this.startChief(clusterId, spec);
        this.startUserScript(clusterId, jobArchive, spec, userScriptOut, userScriptErr);
        return new TensorFlowCluster(spec, workerProcesses);
    }

    private Map<UUID, List<UUID>> startWorkers(TensorFlowClusterSpec spec, List<TensorFlowServerAddressSpec> tasks) {
        ArrayList<TensorFlowServer> srvs = new ArrayList<TensorFlowServer>();
        if (tasks != null) {
            for (int i = 0; i < tasks.size(); ++i) {
                TensorFlowServer srvSpec = new TensorFlowServer(spec, "worker", i);
                srvs.add(srvSpec);
            }
        }
        return this.srvProcMgr.start(srvs);
    }

    private void startChief(UUID clusterId, TensorFlowClusterSpec spec) {
        TensorFlowChiefRunner chiefRunner = new TensorFlowChiefRunner(this.ignite, Executors.newSingleThreadExecutor(new CustomizableThreadFactory("tf-ch", true)), spec, System.out::println, System.err::println);
        chiefRunner.start();
        this.chiefRunners.put(clusterId, chiefRunner);
    }

    private void stopChief(UUID clusterId) {
        TensorFlowChiefRunner runner = (TensorFlowChiefRunner)this.chiefRunners.remove(clusterId);
        if (runner != null) {
            runner.stop();
        }
    }

    public boolean isChiefCompleted(UUID clusterId) {
        TensorFlowChiefRunner runner = (TensorFlowChiefRunner)this.chiefRunners.get(clusterId);
        return runner != null && runner.isCompleted();
    }

    public Exception getChiefException(UUID clusterId) {
        TensorFlowChiefRunner runner = (TensorFlowChiefRunner)this.chiefRunners.get(clusterId);
        return runner != null ? runner.getException() : null;
    }

    private void startUserScript(UUID clusterId, TensorFlowJobArchive jobArchive, TensorFlowClusterSpec clusterSpec, Consumer<String> out, Consumer<String> err) {
        TensorFlowUserScriptRunner userScriptRunner = new TensorFlowUserScriptRunner(this.ignite, Executors.newSingleThreadExecutor(new CustomizableThreadFactory("tf-us", true)), jobArchive, clusterSpec, out, err);
        userScriptRunner.start();
        this.userScriptRunners.put(clusterId, userScriptRunner);
    }

    private void stopUserScript(UUID clusterId) {
        TensorFlowUserScriptRunner runner = (TensorFlowUserScriptRunner)this.userScriptRunners.remove(clusterId);
        if (runner != null) {
            runner.stop();
        }
    }

    public boolean isUserScriptCompleted(UUID clusterId) {
        TensorFlowUserScriptRunner runner = (TensorFlowUserScriptRunner)this.userScriptRunners.get(clusterId);
        return runner != null && runner.isCompleted();
    }

    public Exception getUserScriptException(UUID clusterId) {
        TensorFlowUserScriptRunner runner = (TensorFlowUserScriptRunner)this.userScriptRunners.get(clusterId);
        return runner != null ? runner.getException() : null;
    }

    public Map<UUID, TensorFlowCluster> getAllClusters() {
        HashMap<UUID, TensorFlowCluster> res = new HashMap<UUID, TensorFlowCluster>();
        ScanQuery qry = new ScanQuery();
        QueryCursor cursor = this.cache.query((Query)qry);
        for (Cache.Entry e : cursor) {
            res.put((UUID)e.getKey(), (TensorFlowCluster)e.getValue());
        }
        return res;
    }

    public TensorFlowServerManager getSrvProcMgr() {
        return this.srvProcMgr;
    }

    private IgniteCache<UUID, TensorFlowCluster> getOrCreateCache() {
        CacheConfiguration cacheConfiguration = new CacheConfiguration();
        cacheConfiguration.setName(TF_CLUSTER_METADATA_CACHE_NAME);
        cacheConfiguration.setCacheMode(CacheMode.REPLICATED);
        cacheConfiguration.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        return this.ignite.getOrCreateCache(cacheConfiguration);
    }
}

