/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.cluster;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.locks.LockSupport;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceContext;
import org.apache.ignite.tensorflow.cluster.TensorFlowCluster;
import org.apache.ignite.tensorflow.cluster.TensorFlowClusterManager;
import org.apache.ignite.tensorflow.cluster.TensorFlowJobArchive;
import org.apache.ignite.tensorflow.core.longrunning.task.util.LongRunningProcessState;
import org.apache.ignite.tensorflow.core.longrunning.task.util.LongRunningProcessStatus;

public class TensorFlowClusterMaintainer
implements Service {
    private static final long serialVersionUID = -3220563310643566419L;
    @IgniteInstanceResource
    private transient Ignite ignite;
    @LoggerResource
    private transient IgniteLogger log;
    private final UUID clusterId;
    private final TensorFlowJobArchive jobArchive;
    private final String topicName;
    private transient TensorFlowClusterManager clusterMgr;
    private transient UUID[] prev;

    public TensorFlowClusterMaintainer(UUID clusterId, TensorFlowJobArchive jobArchive, String topicName) {
        assert (clusterId != null) : "Cluster identifier should not be null";
        assert (jobArchive != null) : "Job archive should not be null";
        assert (topicName != null) : "Topic name should not be null";
        this.clusterId = clusterId;
        this.jobArchive = jobArchive;
        this.topicName = topicName;
    }

    public void cancel(ServiceContext ctx) {
        this.clusterMgr.stopClusterIfExists(this.clusterId);
        this.log.debug("Cluster maintainer canceled [clusterId=" + this.clusterId + "]");
    }

    public void init(ServiceContext ctx) {
        this.clusterMgr = new TensorFlowClusterManager(this.ignite);
        this.log.debug("Cluster maintainer initialized [clusterId=" + this.clusterId + "]");
    }

    public void execute(ServiceContext ctx) {
        while (!ctx.isCancelled() && !this.hasUserScriptCompletedSuccessfully()) {
            LockSupport.parkNanos(1000000L);
            boolean restartRequired = this.hasAffinityChanged() || this.hasAnyWorkerFailed() || this.hasChiefFailed() || this.hasUserScriptFailed();
            if (!restartRequired) continue;
            this.log.debug("Cluster will be restarted [clusterId=" + this.clusterId + "]");
            this.restartCluster();
        }
        this.stopCluster(true);
        this.log.debug("Cluster maintainer completed [clusterId=" + this.clusterId + "]");
    }

    private void restartCluster() {
        this.stopCluster(false);
        this.startCluster();
    }

    private void stopCluster(boolean terminate) {
        this.clusterMgr.stopClusterIfExists(this.clusterId);
        if (terminate) {
            this.ignite.message().send((Object)this.topicName, Optional.empty());
        }
    }

    private void startCluster() {
        TensorFlowCluster cluster = this.clusterMgr.createCluster(this.clusterId, this.jobArchive, str -> this.ignite.message().sendOrdered((Object)("us_out_" + this.clusterId), str, 60000L), str -> this.ignite.message().sendOrdered((Object)("us_err_" + this.clusterId), str, 60000L));
        this.ignite.message().send((Object)this.topicName, Optional.of(cluster));
    }

    private boolean hasAffinityChanged() {
        Affinity affinity = this.ignite.affinity(this.jobArchive.getUpstreamCacheName());
        int parts = affinity.partitions();
        Object[] ids = new UUID[parts];
        for (int part = 0; part < parts; ++part) {
            ClusterNode node = affinity.mapPartitionToNode(part);
            UUID nodeId = node.id();
            ids[part] = nodeId;
        }
        if (this.prev == null || !Arrays.equals(ids, this.prev)) {
            this.prev = ids;
            return true;
        }
        return false;
    }

    private boolean hasAnyWorkerFailed() {
        Map<UUID, List<LongRunningProcessStatus>> statuses;
        TensorFlowCluster cluster = this.clusterMgr.getCluster(this.clusterId);
        try {
            statuses = this.clusterMgr.getSrvProcMgr().ping(cluster.getProcesses());
        }
        catch (Exception e) {
            this.log.error("Failed to check process statuses", (Throwable)e);
            return true;
        }
        for (UUID nodeId : statuses.keySet()) {
            for (LongRunningProcessStatus status : statuses.get(nodeId)) {
                if (!status.getState().equals((Object)LongRunningProcessState.DONE)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasChiefFailed() {
        return this.clusterMgr.getChiefException(this.clusterId) != null;
    }

    private boolean hasUserScriptFailed() {
        return this.clusterMgr.getUserScriptException(this.clusterId) != null;
    }

    private boolean hasUserScriptCompletedSuccessfully() {
        return this.clusterMgr.isUserScriptCompleted(this.clusterId) && this.clusterMgr.getUserScriptException(this.clusterId) == null;
    }
}

