/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.cluster;

import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.services.Service;
import org.apache.ignite.tensorflow.cluster.TensorFlowCluster;
import org.apache.ignite.tensorflow.cluster.TensorFlowClusterGateway;
import org.apache.ignite.tensorflow.cluster.TensorFlowClusterMaintainer;
import org.apache.ignite.tensorflow.cluster.TensorFlowJobArchive;

public class TensorFlowClusterGatewayManager {
    private static final String SERVICE_NAME_TEMPLATE = "TF_SERVICE_%s";
    private static final String SERVICE_TOPIC_NAME_TEMPLATE = "TF_SERVICE_TOPIC_%s";
    private final Ignite ignite;
    private final IgniteLogger log;

    public TensorFlowClusterGatewayManager(Ignite ignite) {
        assert (ignite != null) : "Ignite should not be null";
        this.ignite = ignite;
        this.log = ignite.log().getLogger(TensorFlowClusterGatewayManager.class);
    }

    public TensorFlowClusterGateway getCluster(UUID clusterId) {
        String topicName = String.format(SERVICE_TOPIC_NAME_TEMPLATE, clusterId);
        return this.createTensorFlowClusterGateway(topicName);
    }

    public TensorFlowClusterGateway createCluster(UUID clusterId, TensorFlowJobArchive jobArchive) {
        String svcName = String.format(SERVICE_NAME_TEMPLATE, clusterId);
        String topicName = String.format(SERVICE_TOPIC_NAME_TEMPLATE, clusterId);
        TensorFlowClusterGateway gateway = this.createTensorFlowClusterGateway(topicName);
        this.ignite.services().deployClusterSingleton(svcName, (Service)new TensorFlowClusterMaintainer(clusterId, jobArchive, topicName));
        this.log.info("Cluster maintainer deployed as a service [clusterId=" + clusterId + "]");
        return gateway;
    }

    public void listenToClusterUserScript(UUID clusterId, Consumer<String> out, Consumer<String> err) {
        TensorFlowClusterGateway gateway = this.getCluster(clusterId);
        this.ignite.message().localListen((Object)("us_out_" + clusterId), (IgniteBiPredicate & Serializable)(node, msg) -> {
            out.accept(msg.toString());
            return true;
        });
        this.ignite.message().localListen((Object)("us_err_" + clusterId), (IgniteBiPredicate & Serializable)(node, msg) -> {
            err.accept(msg.toString());
            return true;
        });
        CountDownLatch latch = new CountDownLatch(1);
        Consumer<Optional<TensorFlowCluster>> subscriber = cluster -> {
            if (!cluster.isPresent()) {
                latch.countDown();
            }
        };
        gateway.subscribe(subscriber);
        try {
            latch.await();
            gateway.unsubscribe(subscriber);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void stopClusterIfExists(UUID clusterId) {
        this.ignite.services().cancel(String.format(SERVICE_NAME_TEMPLATE, clusterId));
        this.log.info("Cluster maintained cancelled as a service [clusterId=" + clusterId + "]");
    }

    private TensorFlowClusterGateway createTensorFlowClusterGateway(String topicName) {
        TensorFlowClusterGateway gateway = new TensorFlowClusterGateway(subscriber -> {
            this.ignite.message().stopLocalListen((Object)topicName, (IgniteBiPredicate)subscriber);
            this.log.info("Stop listen to cluster gateway [topicName=" + topicName + "]");
        });
        this.ignite.message().localListen((Object)topicName, (IgniteBiPredicate)gateway);
        this.log.info("Start listen to cluster gateway [topicName=" + topicName + "]");
        return gateway;
    }
}

