/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.discovery.zk.internal.ZkIgnitePaths;
import org.apache.zookeeper.ZooKeeper;

public class ZkPinger
extends TimerTask {
    private static final int PING_INTERVAL_MS = 2000;
    private final IgniteLogger log;
    private final ZooKeeper zkClient;
    private final ZkIgnitePaths paths;
    private final Timer scheduler = new Timer("ignite-zk-pinger");

    public ZkPinger(IgniteLogger log, ZooKeeper zkClient, ZkIgnitePaths paths) {
        this.log = log;
        this.zkClient = zkClient;
        this.paths = paths;
    }

    @Override
    public void run() {
        try {
            this.zkClient.exists(this.paths.clusterDir, false);
        }
        catch (Throwable t) {
            if (this.zkClient.getState().isAlive()) {
                U.warn((IgniteLogger)this.log, (Object)"Failed to ping Zookeeper.", (Throwable)t);
            }
            this.scheduler.cancel();
        }
    }

    public void start() {
        this.scheduler.scheduleAtFixedRate((TimerTask)this, 0L, 2000L);
    }

    public void stop() {
        try {
            this.scheduler.cancel();
        }
        catch (Exception e) {
            this.log.warning("Failed to cancel Zookeeper Pinger scheduler.", (Throwable)e);
        }
    }
}

