/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.stream.kafka.connect.serialization;

import java.util.Map;
import org.apache.ignite.events.CacheEvent;
import org.apache.ignite.stream.kafka.connect.serialization.CacheEventDeserializer;
import org.apache.ignite.stream.kafka.connect.serialization.CacheEventSerializer;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.storage.Converter;

public class CacheEventConverter
implements Converter {
    private final CacheEventDeserializer deserializer = new CacheEventDeserializer();
    private final CacheEventSerializer serializer = new CacheEventSerializer();

    public void configure(Map<String, ?> map, boolean b) {
    }

    public byte[] fromConnectData(String topic, Schema schema, Object o) {
        try {
            return this.serializer.serialize(topic, (CacheEvent)o);
        }
        catch (SerializationException e) {
            throw new DataException("Failed to convert to byte[] due to a serialization error", (Throwable)e);
        }
    }

    public SchemaAndValue toConnectData(String topic, byte[] bytes) {
        CacheEvent evt;
        try {
            evt = this.deserializer.deserialize(topic, bytes);
        }
        catch (SerializationException e) {
            throw new DataException("Failed to convert to Kafka Connect data due to a serialization error", (Throwable)e);
        }
        if (evt == null) {
            return SchemaAndValue.NULL;
        }
        return new SchemaAndValue(null, (Object)evt);
    }
}

