/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Msg {
    public static final int MORE = 1;
    public static final int COMMAND = 2;
    public static final int IDENTITY = 64;
    public static final int SHARED = 128;
    private int flags;
    private Type type;
    private int size;
    private byte[] data;
    private final ByteBuffer buf;
    private int writeIndex = 0;
    private int readIndex = 0;

    public Msg() {
        this.type = Type.DATA;
        this.flags = 0;
        this.size = 0;
        this.buf = ByteBuffer.wrap(new byte[0]).order(ByteOrder.BIG_ENDIAN);
        this.data = this.buf.array();
    }

    public Msg(int capacity) {
        this.type = Type.DATA;
        this.flags = 0;
        this.size = capacity;
        this.buf = ByteBuffer.wrap(new byte[capacity]).order(ByteOrder.BIG_ENDIAN);
        this.data = this.buf.array();
    }

    public Msg(byte[] src) {
        if (src == null) {
            src = new byte[]{};
        }
        this.type = Type.DATA;
        this.flags = 0;
        this.size = src.length;
        this.data = src;
        this.buf = ByteBuffer.wrap(src).order(ByteOrder.BIG_ENDIAN);
    }

    public Msg(ByteBuffer src) {
        if (src == null) {
            throw new IllegalArgumentException("ByteBuffer cannot be null");
        }
        this.type = Type.DATA;
        this.flags = 0;
        this.buf = src.duplicate();
        this.data = (byte[])(this.buf.hasArray() && this.buf.position() == 0 && this.buf.limit() == this.buf.capacity() ? this.buf.array() : null);
        this.size = this.buf.remaining();
    }

    public Msg(Msg m) {
        if (m == null) {
            throw new IllegalArgumentException("Msg cannot be null");
        }
        this.type = m.type;
        this.flags = m.flags;
        this.size = m.size;
        ByteBuffer byteBuffer = this.buf = m.buf != null ? m.buf.duplicate() : null;
        if (m.data != null) {
            this.data = new byte[this.size];
            System.arraycopy(m.data, 0, this.data, 0, m.size);
        }
    }

    public boolean isIdentity() {
        return (this.flags & 0x40) == 64;
    }

    public boolean isDelimiter() {
        return this.type == Type.DELIMITER;
    }

    public boolean check() {
        return true;
    }

    public int flags() {
        return this.flags;
    }

    public boolean hasMore() {
        return (this.flags & 1) > 0;
    }

    public void setFlags(int flags) {
        this.flags |= flags;
    }

    public void initDelimiter() {
        this.type = Type.DELIMITER;
        this.flags = 0;
    }

    public byte[] data() {
        if (this.data == null) {
            this.data = new byte[this.buf.remaining()];
            this.buf.duplicate().get(this.data);
        }
        return this.data;
    }

    public ByteBuffer buf() {
        return this.buf.duplicate();
    }

    public int size() {
        return this.size;
    }

    public void resetFlags(int f) {
        this.flags &= ~f;
    }

    public byte get() {
        return this.get(this.readIndex++);
    }

    public byte get(int index) {
        return this.buf.get(index);
    }

    public Msg put(byte b) {
        return this.put(this.writeIndex++, b);
    }

    public Msg put(int index, byte b) {
        this.buf.put(index, b);
        return this;
    }

    public Msg put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    public Msg put(byte[] src, int off, int len) {
        if (src == null) {
            return this;
        }
        ByteBuffer dup = this.buf.duplicate();
        dup.position(this.writeIndex);
        this.writeIndex += len;
        dup.put(src, off, len);
        return this;
    }

    public Msg put(ByteBuffer src) {
        ByteBuffer dup = this.buf.duplicate();
        dup.position(this.writeIndex);
        this.writeIndex += Math.min(dup.remaining(), src.remaining());
        dup.put(src);
        return this;
    }

    public int getBytes(int index, byte[] dst, int off, int len) {
        int count = Math.min(len, this.size - index);
        if (this.data == null) {
            ByteBuffer dup = this.buf.duplicate();
            dup.position(index);
            dup.put(dst, off, count);
        } else {
            System.arraycopy(this.data, index, dst, off, count);
        }
        return count;
    }

    public int getBytes(int index, ByteBuffer bb, int len) {
        ByteBuffer dup = this.buf.duplicate();
        dup.position(index);
        int count = Math.min(bb.remaining(), dup.remaining());
        count = Math.min(count, len);
        bb.put(dup);
        return count;
    }

    public String toString() {
        return String.format("#zmq.Msg{type=%s, size=%s, flags=%s}", new Object[]{this.type, this.size, this.flags});
    }

    static enum Type {
        DATA,
        DELIMITER;

    }
}

