/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import zmq.Command;
import zmq.IOThread;
import zmq.Mailbox;
import zmq.Options;
import zmq.Reaper;
import zmq.SocketBase;
import zmq.ZError;
import zmq.ZObject;

public class Ctx {
    private int tag = -1414673666;
    private final List<SocketBase> sockets;
    private final Deque<Integer> emptySlots;
    private AtomicBoolean starting = new AtomicBoolean(true);
    private boolean terminating = false;
    private final Lock slotSync = new ReentrantLock();
    private Reaper reaper = null;
    private final List<IOThread> ioThreads;
    private int slotCount = 0;
    private Mailbox[] slots = null;
    private final Mailbox termMailbox;
    private final Map<String, Endpoint> endpoints;
    private final Lock endpointsSync = new ReentrantLock();
    private static AtomicInteger maxSocketId = new AtomicInteger(0);
    private int maxSockets = 1024;
    private int ioThreadCount = 1;
    private boolean blocky = true;
    private final Lock optSync = new ReentrantLock();
    public static final int TERM_TID = 0;
    public static final int REAPER_TID = 1;

    public Ctx() {
        this.termMailbox = new Mailbox("terminater");
        this.emptySlots = new ArrayDeque<Integer>();
        this.ioThreads = new ArrayList<IOThread>();
        this.sockets = new ArrayList<SocketBase>();
        this.endpoints = new HashMap<String, Endpoint>();
    }

    private void destroy() throws IOException {
        for (IOThread it : this.ioThreads) {
            it.stop();
        }
        for (IOThread it : this.ioThreads) {
            it.close();
        }
        if (this.reaper != null) {
            this.reaper.close();
        }
        this.termMailbox.close();
        this.tag = -559038737;
    }

    public boolean checkTag() {
        return this.tag == -1414673666;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.tag = -559038737;
        if (!this.starting.get()) {
            this.slotSync.lock();
            try {
                boolean restarted = this.terminating;
                this.terminating = true;
                if (!restarted) {
                    for (SocketBase socket : this.sockets) {
                        socket.stop();
                    }
                    if (this.sockets.isEmpty()) {
                        this.reaper.stop();
                    }
                }
            }
            finally {
                this.slotSync.unlock();
            }
            Command cmd = this.termMailbox.recv(-1L);
            if (cmd == null) {
                throw new IllegalStateException();
            }
            assert (cmd.type() == Command.Type.DONE);
            this.slotSync.lock();
            try {
                assert (this.sockets.isEmpty());
            }
            finally {
                this.slotSync.unlock();
            }
        }
        try {
            this.destroy();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(int option, int optval) {
        if (option == 2 && optval >= 1) {
            this.optSync.lock();
            try {
                this.maxSockets = optval;
            }
            finally {
                this.optSync.unlock();
            }
        } else if (option == 1 && optval >= 0) {
            this.optSync.lock();
            try {
                this.ioThreadCount = optval;
            }
            finally {
                this.optSync.unlock();
            }
        } else if (option == 70 && optval >= 0) {
            this.optSync.lock();
            try {
                this.blocky = optval != 0;
            }
            finally {
                this.optSync.unlock();
            }
        } else {
            return false;
        }
        return true;
    }

    public int get(int option) {
        int rc = 0;
        if (option == 2) {
            rc = this.maxSockets;
        } else if (option == 1) {
            rc = this.ioThreadCount;
        } else if (option == 70) {
            rc = this.blocky ? 1 : 0;
        } else {
            throw new IllegalArgumentException("option = " + option);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketBase createSocket(int type) {
        SocketBase s = null;
        this.slotSync.lock();
        try {
            int sid;
            if (this.starting.compareAndSet(true, false)) {
                int i;
                int ios;
                int mazmq;
                this.optSync.lock();
                try {
                    mazmq = this.maxSockets;
                    ios = this.ioThreadCount;
                }
                finally {
                    this.optSync.unlock();
                }
                this.slotCount = mazmq + ios + 2;
                this.slots = new Mailbox[this.slotCount];
                this.slots[0] = this.termMailbox;
                this.reaper = new Reaper(this, 1);
                this.slots[1] = this.reaper.getMailbox();
                this.reaper.start();
                for (i = 2; i != ios + 2; ++i) {
                    IOThread ioThread = new IOThread(this, i);
                    this.ioThreads.add(ioThread);
                    this.slots[i] = ioThread.getMailbox();
                    ioThread.start();
                }
                for (i = this.slotCount - 1; i >= ios + 2; --i) {
                    this.emptySlots.add(i);
                    this.slots[i] = null;
                }
            }
            if (this.terminating) {
                throw new ZError.CtxTerminatedException();
            }
            if (this.emptySlots.isEmpty()) {
                throw new IllegalStateException("EMFILE");
            }
            int slot = this.emptySlots.pollLast();
            s = SocketBase.create(type, this, slot, sid = maxSocketId.incrementAndGet());
            if (s == null) {
                this.emptySlots.addLast(slot);
                SocketBase socketBase = null;
                return socketBase;
            }
            this.sockets.add(s);
            this.slots[slot] = s.getMailbox();
        }
        finally {
            this.slotSync.unlock();
        }
        return s;
    }

    public void destroySocket(SocketBase socket) {
        this.slotSync.lock();
        try {
            int tid = socket.getTid();
            this.emptySlots.add(tid);
            this.slots[tid] = null;
            this.sockets.remove(socket);
            if (this.terminating && this.sockets.isEmpty()) {
                this.reaper.stop();
            }
        }
        finally {
            this.slotSync.unlock();
        }
    }

    ZObject getReaper() {
        return this.reaper;
    }

    void sendCommand(int tid, Command command) {
        this.slots[tid].send(command);
    }

    IOThread chooseIoThread(long affinity) {
        if (this.ioThreads.isEmpty()) {
            return null;
        }
        int minLoad = -1;
        IOThread selectedIoThread = null;
        for (int i = 0; i != this.ioThreads.size(); ++i) {
            if (affinity != 0L && (affinity & 1L << i) <= 0L) continue;
            int load = this.ioThreads.get(i).getLoad();
            if (selectedIoThread != null && load >= minLoad) continue;
            minLoad = load;
            selectedIoThread = this.ioThreads.get(i);
        }
        return selectedIoThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean registerEndpoint(String addr, Endpoint endpoint) {
        this.endpointsSync.lock();
        Endpoint inserted = null;
        try {
            inserted = this.endpoints.put(addr, endpoint);
        }
        finally {
            this.endpointsSync.unlock();
        }
        return inserted == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterEndpoints(SocketBase socket) {
        this.endpointsSync.lock();
        try {
            Iterator<Map.Entry<String, Endpoint>> it = this.endpoints.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Endpoint> e = it.next();
                if (e.getValue().socket != socket) continue;
                it.remove();
            }
        }
        finally {
            this.endpointsSync.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Endpoint findEndpoint(String addr) {
        Endpoint endpoint = null;
        this.endpointsSync.lock();
        try {
            endpoint = this.endpoints.get(addr);
            if (endpoint == null) {
                Endpoint endpoint2 = new Endpoint(null, new Options());
                return endpoint2;
            }
            endpoint.socket.incSeqnum();
        }
        finally {
            this.endpointsSync.unlock();
        }
        return endpoint;
    }

    static class Endpoint {
        public final SocketBase socket;
        public final Options options;

        public Endpoint(SocketBase socket, Options options) {
            this.socket = socket;
            this.options = options;
        }
    }
}

