/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.IOException;
import java.nio.channels.Selector;
import java.util.Arrays;
import org.zeromq.ZFrame;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;
import org.zeromq.ZMsg;

public interface ZAgent {
    public ZMsg recv();

    public ZMsg recv(boolean var1);

    public boolean send(ZMsg var1);

    public boolean send(ZMsg var1, boolean var2);

    public boolean send(String var1);

    public boolean send(String var1, boolean var2);

    public boolean sign();

    @Deprecated
    public void nova();

    public ZMQ.Socket pipe();

    public static class VerySimpleSelectorCreator
    implements SelectorCreator {
        @Override
        public Selector create() throws IOException {
            return Selector.open();
        }

        @Override
        public void destroy(Selector selector) throws IOException {
            if (selector != null) {
                selector.close();
            }
        }
    }

    public static interface SelectorCreator {
        public Selector create() throws IOException;

        public void destroy(Selector var1) throws IOException;
    }

    public static final class SimpleAgent
    implements ZAgent {
        private final ZMQ.Socket pipe;
        private final byte[] lock;
        private boolean locked;

        public SimpleAgent(ZMQ.Socket pipe, String lock) {
            this.pipe = pipe;
            this.lock = lock == null ? null : lock.getBytes(ZMQ.CHARSET);
        }

        @Override
        public boolean sign() {
            return !this.locked;
        }

        @Override
        public ZMsg recv() {
            return this.recv(true);
        }

        @Override
        public ZMsg recv(boolean wait) {
            if (this.locked) {
                return null;
            }
            try {
                ZMsg msg = ZMsg.recvMsg(this.pipe, wait ? 0 : 1);
                if (msg == null) {
                    return null;
                }
                ZFrame frame = msg.peek();
                byte[] key = frame.getData();
                if (this.lock != null && Arrays.equals(this.lock, key)) {
                    this.locked = true;
                    msg = null;
                    this.pipe.close();
                }
                return msg;
            }
            catch (ZMQException e) {
                this.locked = true;
                return null;
            }
        }

        @Override
        public boolean send(ZMsg message) {
            if (this.locked) {
                return false;
            }
            return message.send(this.pipe);
        }

        @Override
        public boolean send(String word) {
            if (this.locked) {
                return false;
            }
            return this.pipe.send(word);
        }

        @Override
        public boolean send(String word, boolean more) {
            if (this.locked) {
                return false;
            }
            return this.pipe.send(word, more ? 2 : 0);
        }

        @Override
        public boolean send(ZMsg msg, boolean destroy) {
            if (this.locked) {
                return false;
            }
            return msg.send(this.pipe, destroy);
        }

        @Override
        public ZMQ.Socket pipe() {
            return this.pipe;
        }

        @Override
        public void nova() {
            this.pipe.close();
        }
    }

    public static class Creator {
        public static ZAgent create(ZMQ.Socket pipe, String lock) {
            return new SimpleAgent(pipe, lock);
        }
    }
}

