/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.ArrayList;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.FoldingState;
import org.apache.flink.api.common.state.FoldingStateDescriptor;
import org.apache.flink.api.common.state.KeyedStateStore;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.AbstractKeyedTimePanes;
import org.apache.flink.streaming.runtime.operators.windowing.KeyMap;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalWindowFunction;
import org.apache.flink.util.Collector;
import org.apache.flink.util.UnionIterator;

@Internal
public class AccumulatingKeyedTimePanes<Type, Key, Result>
extends AbstractKeyedTimePanes<Type, Key, ArrayList<Type>, Result> {
    private final KeySelector<Type, Key> keySelector;
    private final KeyMap.LazyFactory<ArrayList<Type>> listFactory = AccumulatingKeyedTimePanes.getListFactory();
    private final InternalWindowFunction<Iterable<Type>, Result, Key, Window> function;
    private final AccumulatingKeyedTimePanesContext context;
    private long evaluationPass = 1L;
    private static final KeyMap.LazyFactory<?> LIST_FACTORY = new KeyMap.LazyFactory<ArrayList<?>>(){

        @Override
        public ArrayList<?> create() {
            return new ArrayList(4);
        }
    };

    public AccumulatingKeyedTimePanes(KeySelector<Type, Key> keySelector, InternalWindowFunction<Iterable<Type>, Result, Key, Window> function) {
        this.keySelector = keySelector;
        this.function = function;
        this.context = new AccumulatingKeyedTimePanesContext();
    }

    @Override
    public void addElementToLatestPane(Type element) throws Exception {
        Object k = this.keySelector.getKey(element);
        ArrayList<Type> elements = this.latestPane.putIfAbsent(k, this.listFactory);
        elements.add(element);
    }

    @Override
    public void evaluateWindow(Collector<Result> out, TimeWindow window, AbstractStreamOperator<Result> operator) throws Exception {
        if (this.previousPanes.isEmpty()) {
            for (KeyMap.Entry entry : this.latestPane) {
                Object key = entry.getKey();
                operator.setCurrentKey(key);
                this.context.globalState = operator.getKeyedStateStore();
                this.function.process((Key)entry.getKey(), window, this.context, (Iterable<Type>)entry.getValue(), out);
            }
        } else {
            WindowFunctionTraversal<Key, Type, Result> evaluator = new WindowFunctionTraversal<Key, Type, Result>(this.function, window, out, operator, this.context);
            this.traverseAllPanes(evaluator, this.evaluationPass);
        }
        ++this.evaluationPass;
    }

    private static <V> KeyMap.LazyFactory<ArrayList<V>> getListFactory() {
        return LIST_FACTORY;
    }

    private static class AccumulatingKeyedTimePanesContext
    implements InternalWindowFunction.InternalWindowContext {
        KeyedStateStore globalState;
        KeyedStateStore throwingStore = new ThrowingKeyedStateStore();

        @Override
        public long currentProcessingTime() {
            throw new UnsupportedOperationException("current processing time is not supported in this context");
        }

        @Override
        public long currentWatermark() {
            throw new UnsupportedOperationException("current watermark is not supported in this context");
        }

        @Override
        public KeyedStateStore windowState() {
            return this.throwingStore;
        }

        @Override
        public KeyedStateStore globalState() {
            return this.globalState;
        }
    }

    private static class ThrowingKeyedStateStore
    implements KeyedStateStore {
        private ThrowingKeyedStateStore() {
        }

        public <T> ValueState<T> getState(ValueStateDescriptor<T> stateProperties) {
            throw new UnsupportedOperationException("Per-window state is not supported when using aligned processing-time windows.");
        }

        public <T> ListState<T> getListState(ListStateDescriptor<T> stateProperties) {
            throw new UnsupportedOperationException("Per-window state is not supported when using aligned processing-time windows.");
        }

        public <T> ReducingState<T> getReducingState(ReducingStateDescriptor<T> stateProperties) {
            throw new UnsupportedOperationException("Per-window state is not supported when using aligned processing-time windows.");
        }

        public <T, A> FoldingState<T, A> getFoldingState(FoldingStateDescriptor<T, A> stateProperties) {
            throw new UnsupportedOperationException("Per-window state is not supported when using aligned processing-time windows.");
        }

        public <UK, UV> MapState<UK, UV> getMapState(MapStateDescriptor<UK, UV> stateProperties) {
            throw new UnsupportedOperationException("Per-window state is not supported when using aligned processing-time windows.");
        }
    }

    static final class WindowFunctionTraversal<Key, Type, Result>
    implements KeyMap.TraversalEvaluator<Key, ArrayList<Type>> {
        private final InternalWindowFunction<Iterable<Type>, Result, Key, Window> function;
        private final UnionIterator<Type> unionIterator;
        private final Collector<Result> out;
        private final TimeWindow window;
        private final AbstractStreamOperator<Result> contextOperator;
        private Key currentKey;
        private AccumulatingKeyedTimePanesContext context;

        WindowFunctionTraversal(InternalWindowFunction<Iterable<Type>, Result, Key, Window> function, TimeWindow window, Collector<Result> out, AbstractStreamOperator<Result> contextOperator, AccumulatingKeyedTimePanesContext context) {
            this.function = function;
            this.out = out;
            this.unionIterator = new UnionIterator();
            this.window = window;
            this.contextOperator = contextOperator;
            this.context = context;
        }

        @Override
        public void startNewKey(Key key) {
            this.unionIterator.clear();
            this.currentKey = key;
        }

        @Override
        public void nextValue(ArrayList<Type> value) {
            this.unionIterator.addList(value);
        }

        @Override
        public void keyDone() throws Exception {
            this.contextOperator.setCurrentKey(this.currentKey);
            this.context.globalState = this.contextOperator.getKeyedStateStore();
            this.function.process(this.currentKey, this.window, this.context, (Iterable<Type>)this.unionIterator, this.out);
        }
    }
}

