/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.UnionInputGate;

@Internal
public class InputGateUtil {
    public static InputGate createInputGate(Collection<InputGate> inputGates1, Collection<InputGate> inputGates2) {
        ArrayList<InputGate> gates = new ArrayList<InputGate>(inputGates1.size() + inputGates2.size());
        gates.addAll(inputGates1);
        gates.addAll(inputGates2);
        return InputGateUtil.createInputGate(gates.toArray(new InputGate[gates.size()]));
    }

    public static InputGate createInputGate(InputGate[] inputGates) {
        if (inputGates.length <= 0) {
            throw new RuntimeException("No such input gate.");
        }
        if (inputGates.length < 2) {
            return inputGates[0];
        }
        return new UnionInputGate(inputGates);
    }

    private InputGateUtil() {
        throw new RuntimeException();
    }
}

