/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.async.queue;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.concurrent.AcceptFunction;
import org.apache.flink.streaming.api.operators.async.OperatorActions;
import org.apache.flink.streaming.api.operators.async.queue.AsyncResult;
import org.apache.flink.streaming.api.operators.async.queue.StreamElementQueue;
import org.apache.flink.streaming.api.operators.async.queue.StreamElementQueueEntry;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class UnorderedStreamElementQueue
implements StreamElementQueue {
    private static final Logger LOG = LoggerFactory.getLogger(UnorderedStreamElementQueue.class);
    private final int capacity;
    private final Executor executor;
    private final OperatorActions operatorActions;
    private final ArrayDeque<Set<StreamElementQueueEntry<?>>> uncompletedQueue;
    private final ArrayDeque<StreamElementQueueEntry<?>> completedQueue;
    private Set<StreamElementQueueEntry<?>> firstSet;
    private Set<StreamElementQueueEntry<?>> lastSet;
    private volatile int numberEntries;
    private final ReentrantLock lock;
    private final Condition notFull;
    private final Condition hasCompletedEntries;

    public UnorderedStreamElementQueue(int capacity, Executor executor, OperatorActions operatorActions) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"The capacity must be larger than 0.");
        this.capacity = capacity;
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (String)"executor");
        this.operatorActions = (OperatorActions)Preconditions.checkNotNull((Object)operatorActions, (String)"operatorActions");
        this.uncompletedQueue = new ArrayDeque(capacity);
        this.completedQueue = new ArrayDeque(capacity);
        this.firstSet = new HashSet(capacity);
        this.lastSet = this.firstSet;
        this.numberEntries = 0;
        this.lock = new ReentrantLock();
        this.notFull = this.lock.newCondition();
        this.hasCompletedEntries = this.lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void put(StreamElementQueueEntry<T> streamElementQueueEntry) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (this.numberEntries >= this.capacity) {
                this.notFull.await();
            }
            this.addEntry(streamElementQueueEntry);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean tryPut(StreamElementQueueEntry<T> streamElementQueueEntry) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            if (this.numberEntries < this.capacity) {
                this.addEntry(streamElementQueueEntry);
                LOG.debug("Put element into unordered stream element queue. New filling degree ({}/{}).", (Object)this.numberEntries, (Object)this.capacity);
                boolean bl = true;
                return bl;
            }
            LOG.debug("Failed to put element into unordered stream element queue because it was full ({}/{}).", (Object)this.numberEntries, (Object)this.capacity);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncResult peekBlockingly() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (this.completedQueue.isEmpty()) {
                this.hasCompletedEntries.await();
            }
            LOG.debug("Peeked head element from ordered stream element queue with filling degree ({}/{}).", (Object)this.numberEntries, (Object)this.capacity);
            AsyncResult asyncResult = this.completedQueue.peek();
            return asyncResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncResult poll() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (this.completedQueue.isEmpty()) {
                this.hasCompletedEntries.await();
            }
            --this.numberEntries;
            this.notFull.signalAll();
            LOG.debug("Polled element from unordered stream element queue. New filling degree ({}/{}).", (Object)this.numberEntries, (Object)this.capacity);
            AsyncResult asyncResult = this.completedQueue.poll();
            return asyncResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<StreamElementQueueEntry<?>> values() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            StreamElementQueueEntry[] array = new StreamElementQueueEntry[this.numberEntries];
            array = this.completedQueue.toArray(array);
            int counter = this.completedQueue.size();
            Iterator<Object> i$ = this.firstSet.iterator();
            while (i$.hasNext()) {
                StreamElementQueueEntry<?> streamElementQueueEntry;
                array[counter] = streamElementQueueEntry = i$.next();
                ++counter;
            }
            for (Set set : this.uncompletedQueue) {
                Iterator i$2 = set.iterator();
                while (i$2.hasNext()) {
                    StreamElementQueueEntry streamElementQueueEntry;
                    array[counter] = streamElementQueueEntry = (StreamElementQueueEntry)i$2.next();
                    ++counter;
                }
            }
            List<StreamElementQueueEntry<?>> list = Arrays.asList(array);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.numberEntries == 0;
    }

    @Override
    public int size() {
        return this.numberEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompleteHandler(StreamElementQueueEntry<?> streamElementQueueEntry) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            if (this.firstSet.remove(streamElementQueueEntry)) {
                this.completedQueue.offer(streamElementQueueEntry);
                while (this.firstSet.isEmpty() && this.firstSet != this.lastSet) {
                    this.firstSet = this.uncompletedQueue.poll();
                    Iterator<StreamElementQueueEntry<?>> it = this.firstSet.iterator();
                    while (it.hasNext()) {
                        StreamElementQueueEntry<?> bufferEntry = it.next();
                        if (!bufferEntry.isDone()) continue;
                        this.completedQueue.offer(bufferEntry);
                        it.remove();
                    }
                }
                LOG.debug("Signal unordered stream element queue has completed entries.");
                this.hasCompletedEntries.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private <T> void addEntry(StreamElementQueueEntry<T> streamElementQueueEntry) {
        assert (this.lock.isHeldByCurrentThread());
        if (streamElementQueueEntry.isWatermark()) {
            this.lastSet = new HashSet(this.capacity);
            if (this.firstSet.isEmpty()) {
                this.firstSet.add(streamElementQueueEntry);
            } else {
                HashSet<StreamElementQueueEntry<T>> watermarkSet = new HashSet<StreamElementQueueEntry<T>>(1);
                watermarkSet.add(streamElementQueueEntry);
                this.uncompletedQueue.offer(watermarkSet);
            }
            this.uncompletedQueue.offer(this.lastSet);
        } else {
            this.lastSet.add(streamElementQueueEntry);
        }
        streamElementQueueEntry.onComplete(new AcceptFunction<StreamElementQueueEntry<T>>(){

            public void accept(StreamElementQueueEntry<T> value) {
                try {
                    UnorderedStreamElementQueue.this.onCompleteHandler(value);
                }
                catch (InterruptedException e) {
                    LOG.debug("AsyncBufferEntry could not be properly completed because the executor thread has been interrupted.", (Throwable)e);
                }
                catch (Throwable t) {
                    UnorderedStreamElementQueue.this.operatorActions.failOperator(new Exception("Could not complete the stream element queue entry: " + value + '.', t));
                }
            }
        }, this.executor);
        ++this.numberEntries;
    }
}

