/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.windowing.delta;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.api.functions.windowing.delta.ExtractionAwareDeltaFunction;
import org.apache.flink.streaming.api.functions.windowing.delta.extractor.Extractor;

@PublicEvolving
public class CosineDistance<DATA>
extends ExtractionAwareDeltaFunction<DATA, double[]> {
    private static final long serialVersionUID = -1217813582965151599L;

    public CosineDistance() {
        super(null);
    }

    public CosineDistance(Extractor<DATA, double[]> converter) {
        super(converter);
    }

    @Override
    public double getNestedDelta(double[] oldDataPoint, double[] newDataPoint) {
        if (this.isNullvector(oldDataPoint, newDataPoint)) {
            return 0.0;
        }
        if (oldDataPoint.length != newDataPoint.length) {
            throw new IllegalArgumentException("The size of two input arrays are not same, can not compute cosine distance");
        }
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int i = 0; i < oldDataPoint.length; ++i) {
            sum1 += oldDataPoint[i] * oldDataPoint[i];
            sum2 += newDataPoint[i] * newDataPoint[i];
        }
        sum1 = Math.sqrt(sum1);
        sum2 = Math.sqrt(sum2);
        return 1.0 - this.dotProduct(oldDataPoint, newDataPoint) / (sum1 * sum2);
    }

    private double dotProduct(double[] a, double[] b) {
        double result = 0.0;
        for (int i = 0; i < a.length; ++i) {
            result += a[i] * b[i];
        }
        return result;
    }

    private boolean isNullvector(double[] ... vectors) {
        double[][] arr$ = vectors;
        int len$ = arr$.length;
        block0: for (int i$ = 0; i$ < len$; ++i$) {
            double[] v;
            for (double field : v = arr$[i$]) {
                if (field != 0.0) continue block0;
            }
            return true;
        }
        return false;
    }
}

