/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.util.Collection;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.TypeInfoParser;
import org.apache.flink.streaming.api.datastream.ConnectedStreams;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.transformations.CoFeedbackTransformation;
import org.apache.flink.streaming.api.transformations.FeedbackTransformation;
import org.apache.flink.streaming.api.transformations.StreamTransformation;

@PublicEvolving
public class IterativeStream<T>
extends SingleOutputStreamOperator<T> {
    private DataStream<T> originalInput;
    private long maxWaitTime;

    protected IterativeStream(DataStream<T> dataStream, long maxWaitTime) {
        super(dataStream.getExecutionEnvironment(), new FeedbackTransformation<T>(dataStream.getTransformation(), maxWaitTime));
        this.originalInput = dataStream;
        this.maxWaitTime = maxWaitTime;
        this.setBufferTimeout(dataStream.environment.getBufferTimeout());
    }

    public DataStream<T> closeWith(DataStream<T> feedbackStream) {
        Collection<StreamTransformation<?>> predecessors = feedbackStream.getTransformation().getTransitivePredecessors();
        if (!predecessors.contains(this.transformation)) {
            throw new UnsupportedOperationException("Cannot close an iteration with a feedback DataStream that does not originate from said iteration.");
        }
        ((FeedbackTransformation)this.getTransformation()).addFeedbackEdge(feedbackStream.getTransformation());
        return feedbackStream;
    }

    public <F> ConnectedIterativeStreams<T, F> withFeedbackType(String feedbackTypeString) {
        return this.withFeedbackType(TypeInfoParser.parse((String)feedbackTypeString));
    }

    public <F> ConnectedIterativeStreams<T, F> withFeedbackType(Class<F> feedbackTypeClass) {
        return this.withFeedbackType(TypeExtractor.getForClass(feedbackTypeClass));
    }

    public <F> ConnectedIterativeStreams<T, F> withFeedbackType(TypeInformation<F> feedbackType) {
        return new ConnectedIterativeStreams<T, F>(this.originalInput, feedbackType, this.maxWaitTime);
    }

    @Public
    public static class ConnectedIterativeStreams<I, F>
    extends ConnectedStreams<I, F> {
        private CoFeedbackTransformation<F> coFeedbackTransformation;
        private UnsupportedOperationException groupingException = new UnsupportedOperationException("Cannot change the input partitioning of aniteration head directly. Apply the partitioning on the input andfeedback streams instead.");

        public ConnectedIterativeStreams(DataStream<I> input, TypeInformation<F> feedbackType, long waitTime) {
            super(input.getExecutionEnvironment(), input, new DataStream<F>(input.getExecutionEnvironment(), new CoFeedbackTransformation<F>(input.getParallelism(), feedbackType, waitTime)));
            this.coFeedbackTransformation = (CoFeedbackTransformation)this.getSecondInput().getTransformation();
        }

        public DataStream<F> closeWith(DataStream<F> feedbackStream) {
            Collection<StreamTransformation<?>> predecessors = feedbackStream.getTransformation().getTransitivePredecessors();
            if (!predecessors.contains(this.coFeedbackTransformation)) {
                throw new UnsupportedOperationException("Cannot close an iteration with a feedback DataStream that does not originate from said iteration.");
            }
            this.coFeedbackTransformation.addFeedbackEdge(feedbackStream.getTransformation());
            return feedbackStream;
        }

        @Override
        public ConnectedStreams<I, F> keyBy(int[] keyPositions1, int[] keyPositions2) {
            throw this.groupingException;
        }

        @Override
        public ConnectedStreams<I, F> keyBy(String field1, String field2) {
            throw this.groupingException;
        }

        @Override
        public ConnectedStreams<I, F> keyBy(String[] fields1, String[] fields2) {
            throw this.groupingException;
        }

        @Override
        public ConnectedStreams<I, F> keyBy(KeySelector<I, ?> keySelector1, KeySelector<F, ?> keySelector2) {
            throw this.groupingException;
        }
    }
}

