/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.options;

import java.net.URI;
import java.util.Map;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.scriptbuilder.domain.Statement;

public final class GoogleComputeEngineTemplateOptions
extends TemplateOptions {
    private URI network = null;
    private boolean autoCreateKeyPair = true;
    private Boolean autoCreateWindowsPassword = null;
    private String bootDiskType;
    private boolean preemptible = false;

    public GoogleComputeEngineTemplateOptions clone() {
        GoogleComputeEngineTemplateOptions options = new GoogleComputeEngineTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof GoogleComputeEngineTemplateOptions) {
            GoogleComputeEngineTemplateOptions eTo = (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(to));
            eTo.network(this.network());
            eTo.autoCreateKeyPair(this.autoCreateKeyPair());
            eTo.autoCreateWindowsPassword(this.autoCreateWindowsPassword());
            eTo.bootDiskType(this.bootDiskType());
            eTo.preemptible(this.preemptible());
        }
    }

    public GoogleComputeEngineTemplateOptions network(URI network) {
        this.network = network;
        return this;
    }

    @Nullable
    public URI network() {
        return this.network;
    }

    public GoogleComputeEngineTemplateOptions bootDiskType(String diskType) {
        this.bootDiskType = diskType;
        return this;
    }

    public String bootDiskType() {
        return this.bootDiskType;
    }

    public GoogleComputeEngineTemplateOptions preemptible(boolean preemptible) {
        this.preemptible = preemptible;
        return this;
    }

    public boolean preemptible() {
        return this.preemptible;
    }

    public GoogleComputeEngineTemplateOptions autoCreateKeyPair(boolean autoCreateKeyPair) {
        this.autoCreateKeyPair = autoCreateKeyPair;
        return this;
    }

    public boolean autoCreateKeyPair() {
        return this.autoCreateKeyPair;
    }

    public Boolean autoCreateWindowsPassword() {
        return this.autoCreateWindowsPassword;
    }

    public GoogleComputeEngineTemplateOptions autoCreateWindowsPassword(Boolean autoCreateWindowsPassword) {
        this.autoCreateWindowsPassword = autoCreateWindowsPassword;
        return this;
    }

    public GoogleComputeEngineTemplateOptions blockOnPort(int port, int seconds) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.blockOnPort(port, seconds)));
    }

    public GoogleComputeEngineTemplateOptions inboundPorts(int ... ports) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.inboundPorts(ports)));
    }

    public GoogleComputeEngineTemplateOptions authorizePublicKey(String publicKey) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.authorizePublicKey(publicKey)));
    }

    public GoogleComputeEngineTemplateOptions installPrivateKey(String privateKey) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.installPrivateKey(privateKey)));
    }

    public GoogleComputeEngineTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.blockUntilRunning(blockUntilRunning)));
    }

    public GoogleComputeEngineTemplateOptions dontAuthorizePublicKey() {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.dontAuthorizePublicKey()));
    }

    public GoogleComputeEngineTemplateOptions nameTask(String name) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.nameTask(name)));
    }

    public GoogleComputeEngineTemplateOptions runAsRoot(boolean runAsRoot) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.runAsRoot(runAsRoot)));
    }

    public GoogleComputeEngineTemplateOptions runScript(Statement script) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.runScript(script)));
    }

    public GoogleComputeEngineTemplateOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.overrideLoginCredentials(overridingCredentials)));
    }

    public GoogleComputeEngineTemplateOptions overrideLoginPassword(String password) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.overrideLoginPassword(password)));
    }

    public GoogleComputeEngineTemplateOptions overrideLoginPrivateKey(String privateKey) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.overrideLoginPrivateKey(privateKey)));
    }

    public GoogleComputeEngineTemplateOptions overrideLoginUser(String loginUser) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.overrideLoginUser(loginUser)));
    }

    public GoogleComputeEngineTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.overrideAuthenticateSudo(authenticateSudo)));
    }

    public GoogleComputeEngineTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.userMetadata(userMetadata)));
    }

    public GoogleComputeEngineTemplateOptions userMetadata(String key, String value) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.userMetadata(key, value)));
    }

    public GoogleComputeEngineTemplateOptions nodeNames(Iterable<String> nodeNames) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.nodeNames(nodeNames)));
    }

    public GoogleComputeEngineTemplateOptions networks(Iterable<String> networks) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.networks(networks)));
    }

    public GoogleComputeEngineTemplateOptions networks(String ... networks) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.networks(networks)));
    }

    public GoogleComputeEngineTemplateOptions tags(Iterable<String> tags) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.tags(tags)));
    }

    public GoogleComputeEngineTemplateOptions wrapInInitScript(boolean wrapInInitScript) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.wrapInInitScript(wrapInInitScript)));
    }

    public GoogleComputeEngineTemplateOptions runScript(String script) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.runScript(script)));
    }

    public GoogleComputeEngineTemplateOptions blockOnComplete(boolean blockOnComplete) {
        return (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(super.blockOnComplete(blockOnComplete)));
    }
}

