/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import java.io.ByteArrayOutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flume.Event;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.event.EventBuilder;
import org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class SyslogUtils {
    public static final String SYSLOG_TIMESTAMP_FORMAT_RFC5424_2 = "yyyy-MM-dd'T'HH:mm:ss.SZ";
    public static final String SYSLOG_TIMESTAMP_FORMAT_RFC5424_1 = "yyyy-MM-dd'T'HH:mm:ss.S";
    public static final String SYSLOG_TIMESTAMP_FORMAT_RFC5424_3 = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String SYSLOG_TIMESTAMP_FORMAT_RFC5424_4 = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String SYSLOG_TIMESTAMP_FORMAT_RFC3164_1 = "yyyyMMM d HH:mm:ss";
    public static final String SYSLOG_MSG_RFC5424_0 = "(?:\\<(\\d{1,3})\\>)(?:(\\d?)\\s?)(?:(\\d{4}[-]\\d{2}[-]\\d{2}[T]\\d{2}[:]\\d{2}[:]\\d{2}(?:\\.\\d{1,6})?(?:[+-]\\d{2}[:]\\d{2}|Z)?)|-)\\s(?:([\\w][\\w\\d\\.@\\-]*)|-)\\s(.*)$";
    public static final String SYSLOG_MSG_RFC3164_0 = "(?:\\<(\\d{1,3})\\>)(?:(\\d)?\\s?)([A-Z][a-z][a-z]\\s{1,2}\\d{1,2}\\s\\d{2}[:]\\d{2}[:]\\d{2})\\s([\\w][\\w\\d\\.@-]*)\\s(.*)$";
    public static final int SYSLOG_PRIORITY_POS = 1;
    public static final int SYSLOG_VERSION_POS = 2;
    public static final int SYSLOG_TIMESTAMP_POS = 3;
    public static final int SYSLOG_HOSTNAME_POS = 4;
    public static final int SYSLOG_BODY_POS = 5;
    private Mode m = Mode.START;
    private StringBuilder prio = new StringBuilder();
    private ByteArrayOutputStream baos;
    private static final Logger logger = LoggerFactory.getLogger(SyslogUtils.class);
    public static final String SYSLOG_FACILITY = "Facility";
    public static final String SYSLOG_SEVERITY = "Severity";
    public static final String SYSLOG_PRIORITY = "Priority";
    public static final String SYSLOG_VERSION = "Version";
    public static final String EVENT_STATUS = "flume.syslog.status";
    public static final Integer MIN_SIZE = 10;
    public static final Integer DEFAULT_SIZE = 2500;
    private final boolean isUdp;
    private boolean isBadEvent;
    private boolean isIncompleteEvent;
    private Integer maxSize;
    private Set<String> keepFields;
    private ArrayList<SyslogFormatter> formats = new ArrayList();
    private String priority = null;
    private String version = null;
    private String timeStamp = null;
    private String hostName = null;
    private String msgBody = null;
    private static final String[] DEFAULT_FIELDS_TO_KEEP = new String[]{"priority", "version", "timestamp", "hostname"};
    public static final String KEEP_FIELDS_ALL = "--all--";

    public static boolean keepAllFields(Set<String> keepFields) {
        if (keepFields == null) {
            return false;
        }
        return keepFields.contains(KEEP_FIELDS_ALL);
    }

    public static Set<String> chooseFieldsToKeep(String keepFields) {
        if (keepFields == null) {
            return null;
        }
        if ((keepFields = keepFields.trim().toLowerCase(Locale.ENGLISH)).equals("false") || keepFields.equals("none")) {
            return null;
        }
        if (keepFields.equals("true") || keepFields.equals("all")) {
            HashSet<String> fieldsToKeep = new HashSet<String>(1);
            fieldsToKeep.add(KEEP_FIELDS_ALL);
            return fieldsToKeep;
        }
        HashSet<String> fieldsToKeep = new HashSet<String>(DEFAULT_FIELDS_TO_KEEP.length);
        for (String field : DEFAULT_FIELDS_TO_KEEP) {
            if (keepFields.indexOf(field) == -1) continue;
            fieldsToKeep.add(field);
        }
        return fieldsToKeep;
    }

    public static String addFieldsToBody(Set<String> keepFields, String body, String priority, String version, String timestamp, String hostname) {
        if (keepFields != null) {
            if (keepFields.contains("hostname")) {
                body = hostname + " " + body;
            }
            if (keepFields.contains("timestamp")) {
                body = timestamp + " " + body;
            }
            if (keepFields.contains("version") && version != null && !version.isEmpty()) {
                body = version + " " + body;
            }
            if (keepFields.contains("priority")) {
                body = "<" + priority + ">" + body;
            }
        }
        return body;
    }

    public SyslogUtils() {
        this(false);
    }

    public SyslogUtils(boolean isUdp) {
        this(DEFAULT_SIZE, new HashSet<String>(Arrays.asList("none")), isUdp);
    }

    public SyslogUtils(Integer eventSize, Set<String> keepFields, boolean isUdp) {
        this.isUdp = isUdp;
        this.isBadEvent = false;
        this.isIncompleteEvent = false;
        this.maxSize = eventSize < MIN_SIZE ? MIN_SIZE : eventSize;
        this.baos = new ByteArrayOutputStream(eventSize);
        this.keepFields = keepFields;
        this.initHeaderFormats();
    }

    public void addFormats(Map<String, String> formatProp) {
        if (formatProp.isEmpty() || !formatProp.containsKey("regex")) {
            return;
        }
        SyslogFormatter fmt1 = new SyslogFormatter();
        fmt1.regexPattern = Pattern.compile(formatProp.get("regex"));
        if (formatProp.containsKey("search")) {
            fmt1.searchPattern.add(formatProp.get("search"));
        }
        if (formatProp.containsKey("replace")) {
            fmt1.replacePattern.add(formatProp.get("replace"));
        }
        if (formatProp.containsKey("dateFormat")) {
            fmt1.dateFormat.add(new SimpleDateFormat(formatProp.get("dateFormat")));
        }
        this.formats.add(0, fmt1);
    }

    private void initHeaderFormats() {
        SyslogFormatter fmt1 = new SyslogFormatter();
        fmt1.regexPattern = Pattern.compile(SYSLOG_MSG_RFC5424_0);
        fmt1.searchPattern.add("Z");
        fmt1.replacePattern.add("+0000");
        fmt1.searchPattern.add("([+-])(\\d{2})[:](\\d{2})");
        fmt1.replacePattern.add("$1$2$3");
        fmt1.searchPattern.add("(T\\d{2}:\\d{2}:\\d{2}\\.\\d{3})(\\d*)");
        fmt1.replacePattern.add("$1");
        fmt1.dateFormat.add(new SimpleDateFormat(SYSLOG_TIMESTAMP_FORMAT_RFC5424_1, Locale.ENGLISH));
        fmt1.dateFormat.add(new SimpleDateFormat(SYSLOG_TIMESTAMP_FORMAT_RFC5424_2, Locale.ENGLISH));
        fmt1.dateFormat.add(new SimpleDateFormat(SYSLOG_TIMESTAMP_FORMAT_RFC5424_3, Locale.ENGLISH));
        fmt1.dateFormat.add(new SimpleDateFormat(SYSLOG_TIMESTAMP_FORMAT_RFC5424_4, Locale.ENGLISH));
        fmt1.addYear = false;
        SyslogFormatter fmt2 = new SyslogFormatter();
        fmt2.regexPattern = Pattern.compile(SYSLOG_MSG_RFC3164_0);
        fmt2.searchPattern.add("  ");
        fmt2.replacePattern.add(" ");
        fmt2.dateFormat.add(new SimpleDateFormat(SYSLOG_TIMESTAMP_FORMAT_RFC3164_1, Locale.ENGLISH));
        fmt2.addYear = true;
        this.formats.add(fmt1);
        this.formats.add(fmt2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Event buildEvent() {
        try {
            int pri = 0;
            int sev = 0;
            int facility = 0;
            if (!this.isBadEvent) {
                pri = Integer.parseInt(this.prio.toString());
                sev = pri % 8;
                facility = pri / 8;
                this.formatHeaders();
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put(SYSLOG_FACILITY, String.valueOf(facility));
            headers.put(SYSLOG_SEVERITY, String.valueOf(sev));
            if (this.priority != null && this.priority.length() > 0) {
                headers.put("priority", this.priority);
            }
            if (this.version != null && this.version.length() > 0) {
                headers.put("version", this.version);
            }
            if (this.timeStamp != null && this.timeStamp.length() > 0) {
                headers.put("timestamp", this.timeStamp);
            }
            if (this.hostName != null && this.hostName.length() > 0) {
                headers.put("host", this.hostName);
            }
            if (this.isBadEvent) {
                logger.warn("Event created from Invalid Syslog data.");
                headers.put(EVENT_STATUS, SyslogStatus.INVALID.getSyslogStatus());
            } else if (this.isIncompleteEvent) {
                logger.warn("Event size larger than specified event size: {}. You should consider increasing your event size.", (Object)this.maxSize);
                headers.put(EVENT_STATUS, SyslogStatus.INCOMPLETE.getSyslogStatus());
            }
            byte[] body = !SyslogUtils.keepAllFields(this.keepFields) ? (this.msgBody != null && this.msgBody.length() > 0 ? this.msgBody.getBytes() : this.baos.toByteArray()) : this.baos.toByteArray();
            Event event = EventBuilder.withBody((byte[])body, headers);
            return event;
        }
        finally {
            this.reset();
        }
    }

    private void formatHeaders() {
        String eventStr = this.baos.toString();
        String timeStampString = null;
        for (int p = 0; p < this.formats.size(); ++p) {
            SyslogFormatter fmt = this.formats.get(p);
            Pattern pattern = fmt.regexPattern;
            Matcher matcher = pattern.matcher(eventStr);
            if (!matcher.matches()) continue;
            MatchResult res = matcher.toMatchResult();
            block3: for (int grp = 1; grp <= res.groupCount(); ++grp) {
                String value = res.group(grp);
                if (grp == 3) {
                    timeStampString = value;
                    if (value == null) continue;
                    for (int sp = 0; sp < fmt.searchPattern.size(); ++sp) {
                        value = value.replaceAll(fmt.searchPattern.get(sp), fmt.replacePattern.get(sp));
                    }
                    if (fmt.addYear) {
                        value = String.valueOf(Calendar.getInstance().get(1)) + value;
                    }
                    for (int dt = 0; dt < fmt.dateFormat.size(); ++dt) {
                        try {
                            Date parsedDate = fmt.dateFormat.get(dt).parse(value);
                            if (fmt.addYear) {
                                Calendar c1;
                                Calendar cal = Calendar.getInstance();
                                cal.setTime(parsedDate);
                                Calendar calMinusOneMonth = Calendar.getInstance();
                                calMinusOneMonth.setTime(parsedDate);
                                calMinusOneMonth.add(2, -1);
                                Calendar calPlusElevenMonths = Calendar.getInstance();
                                calPlusElevenMonths.setTime(parsedDate);
                                calPlusElevenMonths.add(2, 11);
                                if (cal.getTimeInMillis() > System.currentTimeMillis() && calMinusOneMonth.getTimeInMillis() > System.currentTimeMillis()) {
                                    c1 = Calendar.getInstance();
                                    c1.setTime(parsedDate);
                                    c1.add(1, -1);
                                    parsedDate = c1.getTime();
                                } else if (cal.getTimeInMillis() < System.currentTimeMillis() && calPlusElevenMonths.getTimeInMillis() < System.currentTimeMillis()) {
                                    c1 = Calendar.getInstance();
                                    c1.setTime(parsedDate);
                                    c1.add(1, -1);
                                    parsedDate = c1.getTime();
                                }
                            }
                            this.timeStamp = String.valueOf(parsedDate.getTime());
                            continue block3;
                        }
                        catch (ParseException e) {
                            continue;
                        }
                    }
                    continue;
                }
                if (grp == 4) {
                    this.hostName = value;
                    continue;
                }
                if (grp == 1) {
                    this.priority = value;
                    continue;
                }
                if (grp == 2) {
                    this.version = value;
                    continue;
                }
                if (grp != 5) continue;
                this.msgBody = SyslogUtils.addFieldsToBody(this.keepFields, value, this.priority, this.version, timeStampString, this.hostName);
            }
            break;
        }
    }

    private void reset() {
        this.baos.reset();
        this.m = Mode.START;
        this.prio.delete(0, this.prio.length());
        this.isBadEvent = false;
        this.isIncompleteEvent = false;
        this.hostName = null;
        this.timeStamp = null;
        this.msgBody = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Event extractEvent(ChannelBuffer in) {
        byte b = 0;
        Event e = null;
        boolean doneReading = false;
        block7: while (!doneReading && in.readable()) {
            b = in.readByte();
            switch (this.m) {
                case START: {
                    if (b == 60) {
                        this.baos.write(b);
                        this.m = Mode.PRIO;
                        break;
                    }
                    if (b == 10) {
                        logger.debug("Delimiter found while in START mode, ignoring..");
                        break;
                    }
                    this.isBadEvent = true;
                    this.baos.write(b);
                    this.m = Mode.DATA;
                    break;
                }
                case PRIO: {
                    this.baos.write(b);
                    if (b == 62) {
                        if (this.prio.length() == 0) {
                            this.isBadEvent = true;
                        }
                        this.m = Mode.DATA;
                        break;
                    }
                    char ch = (char)b;
                    this.prio.append(ch);
                    if (Character.isDigit(ch) && this.prio.length() <= 3) continue block7;
                    this.isBadEvent = true;
                    this.m = Mode.DATA;
                    break;
                }
                case DATA: {
                    if (b == 10) {
                        e = this.buildEvent();
                        doneReading = true;
                    } else {
                        this.baos.write(b);
                    }
                    if (this.baos.size() != this.maxSize.intValue() || doneReading) break;
                    this.isIncompleteEvent = true;
                    e = this.buildEvent();
                    doneReading = true;
                    continue block7;
                }
            }
        }
        if (e != null) return e;
        if (!this.isUdp) return e;
        doneReading = true;
        return this.buildEvent();
    }

    public Integer getEventSize() {
        return this.maxSize;
    }

    public void setEventSize(Integer eventSize) {
        this.maxSize = eventSize;
    }

    public void setKeepFields(Set<String> keepFields) {
        this.keepFields = keepFields;
    }

    public static enum SyslogStatus {
        OTHER("Unknown"),
        INVALID("Invalid"),
        INCOMPLETE("Incomplete");

        private final String syslogStatus;

        private SyslogStatus(String status) {
            this.syslogStatus = status;
        }

        public String getSyslogStatus() {
            return this.syslogStatus;
        }
    }

    static enum Mode {
        START,
        PRIO,
        DATA;

    }

    private class SyslogFormatter {
        public Pattern regexPattern;
        public ArrayList<String> searchPattern = new ArrayList();
        public ArrayList<String> replacePattern = new ArrayList();
        public ArrayList<SimpleDateFormat> dateFormat = new ArrayList();
        public boolean addYear;

        private SyslogFormatter() {
        }
    }
}

