/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink;

import com.google.common.base.Preconditions;
import java.util.Locale;
import org.apache.flume.FlumeException;
import org.apache.flume.Sink;
import org.apache.flume.SinkFactory;
import org.apache.flume.conf.sink.SinkType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSinkFactory
implements SinkFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSinkFactory.class);

    @Override
    public Sink create(String name, String type) throws FlumeException {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull((Object)type, (Object)"type");
        logger.info("Creating instance of sink: {}, type: {}", (Object)name, (Object)type);
        Class<? extends Sink> sinkClass = this.getClass(type);
        try {
            Sink sink = sinkClass.newInstance();
            sink.setName(name);
            return sink;
        }
        catch (Exception ex) {
            throw new FlumeException("Unable to create sink: " + name + ", type: " + type + ", class: " + sinkClass.getName(), (Throwable)ex);
        }
    }

    @Override
    public Class<? extends Sink> getClass(String type) throws FlumeException {
        String sinkClassName = type;
        SinkType sinkType = SinkType.OTHER;
        try {
            sinkType = SinkType.valueOf((String)type.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException ex) {
            logger.debug("Sink type {} is a custom type", (Object)type);
        }
        if (!sinkType.equals((Object)SinkType.OTHER)) {
            sinkClassName = sinkType.getSinkClassName();
        }
        try {
            return Class.forName(sinkClassName);
        }
        catch (Exception ex) {
            throw new FlumeException("Unable to load sink type: " + type + ", class: " + sinkClassName, (Throwable)ex);
        }
    }
}

