/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.instrumentation;

import org.apache.commons.lang.ArrayUtils;
import org.apache.flume.instrumentation.MonitoredCounterGroup;
import org.apache.flume.instrumentation.SinkCounterMBean;

public class SinkCounter
extends MonitoredCounterGroup
implements SinkCounterMBean {
    private static final String COUNTER_CONNECTION_CREATED = "sink.connection.creation.count";
    private static final String COUNTER_CONNECTION_CLOSED = "sink.connection.closed.count";
    private static final String COUNTER_CONNECTION_FAILED = "sink.connection.failed.count";
    private static final String COUNTER_BATCH_EMPTY = "sink.batch.empty";
    private static final String COUNTER_BATCH_UNDERFLOW = "sink.batch.underflow";
    private static final String COUNTER_BATCH_COMPLETE = "sink.batch.complete";
    private static final String COUNTER_EVENT_DRAIN_ATTEMPT = "sink.event.drain.attempt";
    private static final String COUNTER_EVENT_DRAIN_SUCCESS = "sink.event.drain.sucess";
    private static final String[] ATTRIBUTES = new String[]{"sink.connection.creation.count", "sink.connection.closed.count", "sink.connection.failed.count", "sink.batch.empty", "sink.batch.underflow", "sink.batch.complete", "sink.event.drain.attempt", "sink.event.drain.sucess"};

    public SinkCounter(String name) {
        super(MonitoredCounterGroup.Type.SINK, name, ATTRIBUTES);
    }

    public SinkCounter(String name, String[] attributes) {
        super(MonitoredCounterGroup.Type.SINK, name, (String[])ArrayUtils.addAll((Object[])attributes, (Object[])ATTRIBUTES));
    }

    @Override
    public long getConnectionCreatedCount() {
        return this.get(COUNTER_CONNECTION_CREATED);
    }

    public long incrementConnectionCreatedCount() {
        return this.increment(COUNTER_CONNECTION_CREATED);
    }

    @Override
    public long getConnectionClosedCount() {
        return this.get(COUNTER_CONNECTION_CLOSED);
    }

    public long incrementConnectionClosedCount() {
        return this.increment(COUNTER_CONNECTION_CLOSED);
    }

    @Override
    public long getConnectionFailedCount() {
        return this.get(COUNTER_CONNECTION_FAILED);
    }

    public long incrementConnectionFailedCount() {
        return this.increment(COUNTER_CONNECTION_FAILED);
    }

    @Override
    public long getBatchEmptyCount() {
        return this.get(COUNTER_BATCH_EMPTY);
    }

    public long incrementBatchEmptyCount() {
        return this.increment(COUNTER_BATCH_EMPTY);
    }

    @Override
    public long getBatchUnderflowCount() {
        return this.get(COUNTER_BATCH_UNDERFLOW);
    }

    public long incrementBatchUnderflowCount() {
        return this.increment(COUNTER_BATCH_UNDERFLOW);
    }

    @Override
    public long getBatchCompleteCount() {
        return this.get(COUNTER_BATCH_COMPLETE);
    }

    public long incrementBatchCompleteCount() {
        return this.increment(COUNTER_BATCH_COMPLETE);
    }

    @Override
    public long getEventDrainAttemptCount() {
        return this.get(COUNTER_EVENT_DRAIN_ATTEMPT);
    }

    public long incrementEventDrainAttemptCount() {
        return this.increment(COUNTER_EVENT_DRAIN_ATTEMPT);
    }

    public long addToEventDrainAttemptCount(long delta) {
        return this.addAndGet(COUNTER_EVENT_DRAIN_ATTEMPT, delta);
    }

    @Override
    public long getEventDrainSuccessCount() {
        return this.get(COUNTER_EVENT_DRAIN_SUCCESS);
    }

    public long incrementEventDrainSuccessCount() {
        return this.increment(COUNTER_EVENT_DRAIN_SUCCESS);
    }

    public long addToEventDrainSuccessCount(long delta) {
        return this.addAndGet(COUNTER_EVENT_DRAIN_SUCCESS, delta);
    }
}

