/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.formatter.output;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flume.Context;
import org.apache.flume.formatter.output.PathManager;

public class DefaultPathManager
implements PathManager {
    private long seriesTimestamp;
    private File baseDirectory;
    private AtomicInteger fileIndex;
    private String filePrefix;
    private String extension;
    private static final String DEFAULT_FILE_PREFIX = "";
    private static final String DEFAULT_FILE_EXTENSION = "";
    private static final String FILE_EXTENSION = "extension";
    private static final String FILE_PREFIX = "prefix";
    protected File currentFile;

    public DefaultPathManager(Context context) {
        this.filePrefix = context.getString(FILE_PREFIX, "");
        this.extension = context.getString(FILE_EXTENSION, "");
        this.seriesTimestamp = System.currentTimeMillis();
        this.fileIndex = new AtomicInteger();
    }

    @Override
    public File nextFile() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.filePrefix).append(this.seriesTimestamp).append("-");
        sb.append(this.fileIndex.incrementAndGet());
        if (this.extension.length() > 0) {
            sb.append(".").append(this.extension);
        }
        this.currentFile = new File(this.baseDirectory, sb.toString());
        return this.currentFile;
    }

    @Override
    public File getCurrentFile() {
        if (this.currentFile == null) {
            return this.nextFile();
        }
        return this.currentFile;
    }

    @Override
    public void rotate() {
        this.currentFile = null;
    }

    @Override
    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    @Override
    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public long getSeriesTimestamp() {
        return this.seriesTimestamp;
    }

    public String getPrefix() {
        return this.filePrefix;
    }

    public String getExtension() {
        return this.extension;
    }

    public AtomicInteger getFileIndex() {
        return this.fileIndex;
    }

    public static class Builder
    implements PathManager.Builder {
        @Override
        public PathManager build(Context context) {
            return new DefaultPathManager(context);
        }
    }
}

