/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.channel.AbstractChannelSelector;

public class ReplicatingChannelSelector
extends AbstractChannelSelector {
    public static final String CONFIG_OPTIONAL = "optional";
    List<Channel> requiredChannels = null;
    List<Channel> optionalChannels = new ArrayList<Channel>();

    @Override
    public List<Channel> getRequiredChannels(Event event) {
        if (this.requiredChannels == null) {
            return this.getAllChannels();
        }
        return this.requiredChannels;
    }

    @Override
    public List<Channel> getOptionalChannels(Event event) {
        return this.optionalChannels;
    }

    @Override
    public void configure(Context context) {
        String optionalList = context.getString(CONFIG_OPTIONAL);
        this.requiredChannels = new ArrayList<Channel>(this.getAllChannels());
        Map<String, Channel> channelNameMap = this.getChannelNameMap();
        if (optionalList != null && !optionalList.isEmpty()) {
            for (String optional : optionalList.split("\\s+")) {
                Channel optionalChannel = channelNameMap.get(optional);
                this.requiredChannels.remove(optionalChannel);
                if (this.optionalChannels.contains(optionalChannel)) continue;
                this.optionalChannels.add(optionalChannel);
            }
        }
    }
}

