/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class CounterGroup {
    private String name;
    private HashMap<String, AtomicLong> counters = new HashMap();

    public synchronized Long get(String name) {
        return this.getCounter(name).get();
    }

    public synchronized Long incrementAndGet(String name) {
        return this.getCounter(name).incrementAndGet();
    }

    public synchronized Long addAndGet(String name, Long delta) {
        return this.getCounter(name).addAndGet(delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(CounterGroup counterGroup) {
        CounterGroup counterGroup2 = counterGroup;
        synchronized (counterGroup2) {
            for (Map.Entry<String, AtomicLong> entry : counterGroup.getCounters().entrySet()) {
                this.addAndGet(entry.getKey(), entry.getValue().get());
            }
        }
    }

    public synchronized void set(String name, Long value) {
        this.getCounter(name).set(value);
    }

    public synchronized AtomicLong getCounter(String name) {
        if (!this.counters.containsKey(name)) {
            this.counters.put(name, new AtomicLong());
        }
        return this.counters.get(name);
    }

    public synchronized String toString() {
        return "{ name:" + this.name + " counters:" + this.counters + " }";
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    public synchronized HashMap<String, AtomicLong> getCounters() {
        return this.counters;
    }

    public synchronized void setCounters(HashMap<String, AtomicLong> counters) {
        this.counters = counters;
    }
}

