/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.portscanner;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.nio.channels.FileLock;
import org.apache.ignite.IgniteSystemProperties;

public class GridJmxPortFinder {
    public static final String IGNITE_JMX_PORT = "IGNITE_JMX_PORT";
    private static final int MIN_PORT = 49112;
    private static final int MAX_PORT = 65535;

    private GridJmxPortFinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            InetAddress.getLocalHost();
        }
        catch (UnknownHostException ignored) {
            return;
        }
        int jmxPort = IgniteSystemProperties.getInteger(IGNITE_JMX_PORT, -1);
        if (jmxPort != -1) {
            System.out.println(jmxPort);
            return;
        }
        RandomAccessFile ra = null;
        FileLock lock = null;
        try {
            File file = new File(System.getProperty("java.io.tmpdir"), "ignite.lastport.tmp");
            file.setReadable(true, false);
            file.setWritable(true, false);
            ra = new RandomAccessFile(file, "rw");
            lock = ra.getChannel().lock();
            ra.seek(0L);
            String startPortStr = ra.readLine();
            int startPort = 49112;
            if (startPortStr != null && !startPortStr.isEmpty()) {
                try {
                    startPort = Integer.valueOf(startPortStr) + 1;
                    if (startPort < 49112 || startPort > 65535) {
                        startPort = 49112;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            int port = GridJmxPortFinder.findPort(startPort);
            ra.setLength(0L);
            ra.writeBytes(String.valueOf(port));
            System.out.println(port);
        }
        catch (IOException iOException) {
        }
        finally {
            if (lock != null) {
                try {
                    lock.release();
                }
                catch (IOException iOException) {}
            }
            if (ra != null) {
                try {
                    ra.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static int findPort(int startPort) {
        for (int port = startPort; port <= 65535; ++port) {
            if (!GridJmxPortFinder.isAvailable(port)) continue;
            return port;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isAvailable(int port) {
        ServerSocket sock = null;
        try {
            sock = new ServerSocket(port);
            boolean bl = true;
            return bl;
        }
        catch (IOException ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

