/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.plugin.security.SecurityPermission;

class ClientCacheRequest
extends ClientRequest {
    private static final byte FLAG_KEEP_BINARY = 1;
    private final int cacheId;
    private final byte flags;

    ClientCacheRequest(BinaryRawReader reader) {
        super(reader);
        this.cacheId = reader.readInt();
        this.flags = reader.readByte();
    }

    protected IgniteCache cache(ClientConnectionContext ctx) {
        return this.rawCache(ctx).withKeepBinary();
    }

    protected boolean isKeepBinary() {
        return (this.flags & 1) == 1;
    }

    protected IgniteCache rawCache(ClientConnectionContext ctx) {
        DynamicCacheDescriptor cacheDesc = this.cacheDescriptor(ctx);
        String cacheName = cacheDesc.cacheName();
        return ctx.kernalContext().grid().cache(cacheName);
    }

    protected DynamicCacheDescriptor cacheDescriptor(ClientConnectionContext ctx) {
        return ClientCacheRequest.cacheDescriptor(ctx, this.cacheId);
    }

    public static DynamicCacheDescriptor cacheDescriptor(ClientConnectionContext ctx, int cacheId) {
        DynamicCacheDescriptor desc = ctx.kernalContext().cache().cacheDescriptor(cacheId);
        if (desc == null) {
            throw new IgniteClientException(1000, "Cache does not exist [cacheId= " + cacheId + "]", null);
        }
        return desc;
    }

    protected int cacheId() {
        return this.cacheId;
    }

    @Override
    protected void authorize(ClientConnectionContext ctx, SecurityPermission perm) {
        SecurityContext secCtx = ctx.securityContext();
        if (secCtx != null) {
            DynamicCacheDescriptor cacheDesc = ClientCacheRequest.cacheDescriptor(ctx, this.cacheId);
            ClientCacheRequest.runWithSecurityExceptionHandler(() -> ctx.kernalContext().security().authorize(cacheDesc.cacheName(), perm, secCtx));
        }
    }

    protected void authorize(ClientConnectionContext ctx, SecurityPermission ... perm) throws IgniteClientException {
        SecurityContext secCtx = ctx.securityContext();
        if (secCtx != null) {
            DynamicCacheDescriptor cacheDesc = ClientCacheRequest.cacheDescriptor(ctx, this.cacheId);
            ClientCacheRequest.runWithSecurityExceptionHandler(() -> {
                for (SecurityPermission p : perm) {
                    ctx.kernalContext().security().authorize(cacheDesc.cacheName(), p, secCtx);
                }
            });
        }
    }
}

