/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteFileSystem;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.cache.eviction.igfs.IgfsPerBlockLruEvictionPolicy;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskSplitAdapter;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.FileSystemConfiguration;
import org.apache.ignite.events.IgfsEvent;
import org.apache.ignite.igfs.IgfsBlockLocation;
import org.apache.ignite.igfs.IgfsException;
import org.apache.ignite.igfs.IgfsFile;
import org.apache.ignite.igfs.IgfsInputStream;
import org.apache.ignite.igfs.IgfsInvalidPathException;
import org.apache.ignite.igfs.IgfsMetrics;
import org.apache.ignite.igfs.IgfsMode;
import org.apache.ignite.igfs.IgfsOutputStream;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.igfs.IgfsPathIsDirectoryException;
import org.apache.ignite.igfs.IgfsPathNotFoundException;
import org.apache.ignite.igfs.IgfsPathSummary;
import org.apache.ignite.igfs.IgfsUserContext;
import org.apache.ignite.igfs.mapreduce.IgfsRecordResolver;
import org.apache.ignite.igfs.mapreduce.IgfsTask;
import org.apache.ignite.igfs.secondary.IgfsSecondaryFileSystem;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.processors.igfs.IgfsAsyncImpl;
import org.apache.ignite.internal.processors.igfs.IgfsContext;
import org.apache.ignite.internal.processors.igfs.IgfsCreateResult;
import org.apache.ignite.internal.processors.igfs.IgfsDataManager;
import org.apache.ignite.internal.processors.igfs.IgfsDeleteResult;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.internal.processors.igfs.IgfsEx;
import org.apache.ignite.internal.processors.igfs.IgfsFileImpl;
import org.apache.ignite.internal.processors.igfs.IgfsFileWorkerBatch;
import org.apache.ignite.internal.processors.igfs.IgfsInputStreamImpl;
import org.apache.ignite.internal.processors.igfs.IgfsLazySecondaryFileSystemPositionedReadable;
import org.apache.ignite.internal.processors.igfs.IgfsListingEntry;
import org.apache.ignite.internal.processors.igfs.IgfsLocalMetrics;
import org.apache.ignite.internal.processors.igfs.IgfsMetaManager;
import org.apache.ignite.internal.processors.igfs.IgfsMetricsAdapter;
import org.apache.ignite.internal.processors.igfs.IgfsModeResolver;
import org.apache.ignite.internal.processors.igfs.IgfsOutputStreamImpl;
import org.apache.ignite.internal.processors.igfs.IgfsOutputStreamProxyImpl;
import org.apache.ignite.internal.processors.igfs.IgfsSecondaryFileSystemCreateContext;
import org.apache.ignite.internal.processors.igfs.IgfsSecondaryFileSystemImpl;
import org.apache.ignite.internal.processors.igfs.IgfsSecondaryInputStreamDescriptor;
import org.apache.ignite.internal.processors.igfs.IgfsStatus;
import org.apache.ignite.internal.processors.igfs.IgfsTaskArgsImpl;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientAffinityCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientDeleteCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientExistsCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientInfoCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientListFilesCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientListPathsCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientMkdirsCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientRenameCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientSetTimesCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientSizeCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientSummaryCallable;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientUpdateCallable;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.jetbrains.annotations.Nullable;

public final class IgfsImpl
implements IgfsEx {
    private static final String PERMISSION_DFLT_VAL = "0777";
    private static final AtomicInteger FORMAT_THREAD_IDX_GEN = new AtomicInteger();
    static final Map<String, String> DFLT_DIR_META = F.asMap("permission", "0777");
    private IgfsMetaManager meta;
    private IgfsDataManager data;
    private FileSystemConfiguration cfg;
    private IgfsContext igfsCtx;
    private GridEventStorageManager evts;
    private IgniteLogger log;
    private final IgfsModeResolver modeRslvr;
    private IgfsSecondaryFileSystem secondaryFs;
    private final GridSpinBusyLock busyLock = new GridSpinBusyLock();
    private final ConcurrentHashMap<IgfsPath, IgfsFileWorkerBatch> workerMap = new ConcurrentHashMap();
    private volatile String logDir;
    private IgfsPerBlockLruEvictionPolicy evictPlc;
    private final IgniteThreadPoolExecutor dualPool;

    IgfsImpl(IgfsContext igfsCtx) throws IgniteCheckedException {
        IgfsMode dfltMode;
        assert (igfsCtx != null);
        this.igfsCtx = igfsCtx;
        this.cfg = igfsCtx.configuration();
        this.log = igfsCtx.kernalContext().log(IgfsImpl.class);
        this.evts = igfsCtx.kernalContext().event();
        this.meta = igfsCtx.meta();
        this.data = igfsCtx.data();
        this.secondaryFs = this.cfg.getSecondaryFileSystem();
        if (this.secondaryFs != null) {
            igfsCtx.kernalContext().resource().injectGeneric(this.secondaryFs);
            igfsCtx.kernalContext().resource().injectFileSystem(this.secondaryFs, this);
        }
        if (this.secondaryFs instanceof LifecycleAware) {
            ((LifecycleAware)((Object)this.secondaryFs)).start();
        }
        if (this.secondaryFs == null) {
            if (this.cfg.getDefaultMode() == IgfsMode.PROXY) {
                throw new IgniteCheckedException("Mode cannot be PROXY if secondary file system hasn't been defined.");
            }
            dfltMode = IgfsMode.PRIMARY;
        } else {
            dfltMode = this.cfg.getDefaultMode();
        }
        LinkedHashMap<String, IgfsMode> cfgModes = new LinkedHashMap<String, IgfsMode>();
        if (this.cfg.getPathModes() != null) {
            for (Map.Entry<String, IgfsMode> entry : this.cfg.getPathModes().entrySet()) {
                cfgModes.put(entry.getKey(), entry.getValue());
            }
        }
        ArrayList<T2<IgfsPath, IgfsMode>> modes = null;
        if (!cfgModes.isEmpty()) {
            modes = new ArrayList<T2<IgfsPath, IgfsMode>>(cfgModes.size());
            for (Map.Entry entry : cfgModes.entrySet()) {
                IgfsMode mode0;
                if (entry.getValue() == IgfsMode.PROXY) {
                    if (this.secondaryFs == null) {
                        throw new IgniteCheckedException("Mode cannot be PROXY if secondary file system hasn't been defined: " + (String)entry.getKey());
                    }
                    mode0 = IgfsMode.PROXY;
                } else {
                    mode0 = this.secondaryFs == null ? IgfsMode.PRIMARY : (IgfsMode)((Object)entry.getValue());
                }
                try {
                    modes.add(new T2<IgfsPath, IgfsMode>(new IgfsPath((String)entry.getKey()), mode0));
                }
                catch (IllegalArgumentException e) {
                    throw new IgniteCheckedException("Invalid path found in mode pattern: " + (String)entry.getKey(), e);
                }
            }
        }
        this.modeRslvr = new IgfsModeResolver(dfltMode, modes);
        String string = igfsCtx.configuration().getDataCacheConfiguration().getName();
        for (CacheConfiguration cacheCfg : igfsCtx.kernalContext().config().getCacheConfiguration()) {
            if (!F.eq(string, cacheCfg.getName())) continue;
            EvictionPolicy evictPlc = cacheCfg.getEvictionPolicyFactory() != null ? (EvictionPolicy)cacheCfg.getEvictionPolicyFactory().create() : cacheCfg.getEvictionPolicy();
            if (!(evictPlc != null & evictPlc instanceof IgfsPerBlockLruEvictionPolicy)) break;
            this.evictPlc = (IgfsPerBlockLruEvictionPolicy)evictPlc;
            break;
        }
        this.dualPool = this.secondaryFs != null ? new IgniteThreadPoolExecutor(4, Integer.MAX_VALUE, 5000L, new SynchronousQueue<Runnable>(), new IgfsThreadFactory(this.cfg.getName())) : null;
    }

    @Override
    public void stop(boolean cancel) {
        this.busyLock.block();
        boolean interrupted = Thread.interrupted();
        if (this.secondaryFs != null) {
            for (IgfsFileWorkerBatch batch : this.workerMap.values()) {
                batch.cancel();
            }
            try {
                if (this.secondaryFs instanceof LifecycleAware) {
                    ((LifecycleAware)((Object)this.secondaryFs)).stop();
                }
            }
            catch (Exception e) {
                this.log.error("Failed to close secondary file system.", e);
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (this.dualPool != null) {
            this.dualPool.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgfsFileWorkerBatch newBatch(final IgfsPath path, OutputStream out) throws IgniteCheckedException {
        assert (path != null);
        assert (out != null);
        if (this.enterBusy()) {
            try {
                IgfsFileWorkerBatch prevBatch;
                IgfsFileWorkerBatch batch = new IgfsFileWorkerBatch(path, out){

                    @Override
                    protected void onDone() {
                        IgfsImpl.this.workerMap.remove(path, this);
                    }
                };
                assert (this.dualPool != null);
                this.dualPool.execute(batch);
                while ((prevBatch = this.workerMap.putIfAbsent(path, batch)) != null) {
                    prevBatch.await();
                }
                IgfsFileWorkerBatch igfsFileWorkerBatch = batch;
                return igfsFileWorkerBatch;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Cannot create new output stream to the secondary file system because IGFS is stopping: " + path);
    }

    private boolean enterBusy() {
        this.meta.awaitInit();
        this.data.awaitInit();
        return this.busyLock.enterBusy();
    }

    @Override
    public void await(IgfsPath ... paths) {
        assert (paths != null);
        for (Map.Entry<IgfsPath, IgfsFileWorkerBatch> workerEntry : this.workerMap.entrySet()) {
            IgfsFileWorkerBatch batch;
            IgfsPath workerPath = workerEntry.getKey();
            boolean await = false;
            for (IgfsPath path : paths) {
                if (!workerPath.isSubDirectoryOf(path) && !F.eq(workerPath, path)) continue;
                await = true;
                break;
            }
            if (!await || (batch = workerEntry.getValue()) == null) continue;
            try {
                if (!batch.finishing()) continue;
                batch.await();
            }
            catch (IgniteCheckedException igniteCheckedException) {}
        }
    }

    @Override
    public IgfsContext context() {
        return this.igfsCtx;
    }

    public IgfsModeResolver modeResolver() {
        return this.modeRslvr;
    }

    @Override
    public String name() {
        return this.cfg.getName();
    }

    @Override
    public FileSystemConfiguration configuration() {
        return this.cfg;
    }

    @Override
    public String clientLogDirectory() {
        return this.logDir;
    }

    @Override
    public void clientLogDirectory(String logDir) {
        this.logDir = logDir;
    }

    @Override
    public IgfsStatus globalSpace() {
        return this.safeOp(new Callable<IgfsStatus>(){

            @Override
            public IgfsStatus call() throws Exception {
                IgniteBiTuple<Long, Long> space = IgfsImpl.this.igfsCtx.kernalContext().grid().compute().execute(new IgfsGlobalSpaceTask(IgfsImpl.this.name()), null);
                return new IgfsStatus(space.get1(), space.get2());
            }
        });
    }

    @Override
    public void globalSampling(final @Nullable Boolean val) throws IgniteCheckedException {
        this.safeOp(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (IgfsImpl.this.meta.sampling(val)) {
                    if (val == null) {
                        IgfsImpl.this.log.info("Sampling flag has been cleared. All further file system connections will perform logging depending on their configuration.");
                    } else if (val.booleanValue()) {
                        IgfsImpl.this.log.info("Sampling flag has been set to \"true\". All further file system connections will perform logging.");
                    } else {
                        IgfsImpl.this.log.info("Sampling flag has been set to \"false\". All further file system connections will not perform logging.");
                    }
                }
                return null;
            }
        });
    }

    @Override
    @Nullable
    public Boolean globalSampling() {
        return this.safeOp(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return IgfsImpl.this.meta.sampling();
            }
        });
    }

    @Override
    public long groupBlockSize() {
        return this.data.groupBlockSize();
    }

    @Override
    public boolean exists(final IgfsPath path) {
        A.notNull(path, "path");
        if (this.meta.isClient()) {
            return this.meta.runClientTask(new IgfsClientExistsCallable(this.cfg.getName(), IgfsUserContext.currentUser(), path));
        }
        return this.safeOp(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (IgfsImpl.this.log.isDebugEnabled()) {
                    IgfsImpl.this.log.debug("Check file exists: " + path);
                }
                IgfsMode mode = IgfsImpl.this.resolveMode(path);
                boolean res = false;
                switch (mode) {
                    case PRIMARY: {
                        res = IgfsImpl.this.meta.fileId(path) != null;
                        break;
                    }
                    case DUAL_SYNC: 
                    case DUAL_ASYNC: {
                        boolean bl = res = IgfsImpl.this.meta.fileId(path) != null;
                        if (res) break;
                        try {
                            res = IgfsImpl.this.secondaryFs.exists(path);
                            break;
                        }
                        catch (Exception e) {
                            U.error(IgfsImpl.this.log, "Exists in DUAL mode failed [path=" + path + ']', e);
                            throw e;
                        }
                    }
                    case PROXY: {
                        res = IgfsImpl.this.secondaryFs.exists(path);
                    }
                }
                return res;
            }
        });
    }

    @Override
    @Nullable
    public IgfsFile info(final IgfsPath path) {
        A.notNull(path, "path");
        if (this.meta.isClient()) {
            return this.meta.runClientTask(new IgfsClientInfoCallable(this.cfg.getName(), IgfsUserContext.currentUser(), path));
        }
        return this.safeOp(new Callable<IgfsFile>(){

            @Override
            public IgfsFile call() throws Exception {
                if (IgfsImpl.this.log.isDebugEnabled()) {
                    IgfsImpl.this.log.debug("Get file info: " + path);
                }
                IgfsMode mode = IgfsImpl.this.resolveMode(path);
                return IgfsImpl.this.resolveFileInfo(path, mode);
            }
        });
    }

    @Override
    public IgfsMode mode(IgfsPath path) {
        A.notNull(path, "path");
        return this.modeRslvr.resolveMode(path);
    }

    @Override
    public IgfsPathSummary summary(final IgfsPath path) {
        A.notNull(path, "path");
        if (this.meta.isClient()) {
            return this.meta.runClientTask(new IgfsClientSummaryCallable(this.cfg.getName(), IgfsUserContext.currentUser(), path));
        }
        return this.safeOp(new Callable<IgfsPathSummary>(){

            @Override
            public IgfsPathSummary call() throws Exception {
                if (IgfsImpl.this.log.isDebugEnabled()) {
                    IgfsImpl.this.log.debug("Calculating path summary: " + path);
                }
                return IgfsImpl.this.summary0(path);
            }
        });
    }

    @Override
    public IgfsFile update(final IgfsPath path, final Map<String, String> props) {
        A.notNull(path, "path");
        A.notNull(props, "props");
        A.ensure(!props.isEmpty(), "!props.isEmpty()");
        if (this.meta.isClient()) {
            return this.meta.runClientTask(new IgfsClientUpdateCallable(this.cfg.getName(), IgfsUserContext.currentUser(), path, props));
        }
        return this.safeOp(new Callable<IgfsFile>(){

            @Override
            public IgfsFile call() throws Exception {
                if (IgfsImpl.this.log.isDebugEnabled()) {
                    IgfsImpl.this.log.debug("Set file properties [path=" + path + ", props=" + props + ']');
                }
                IgfsMode mode = IgfsImpl.this.resolveMode(path);
                switch (mode) {
                    case PRIMARY: {
                        IgfsEntryInfo info;
                        List<IgniteUuid> fileIds = IgfsImpl.this.meta.idsForPath(path);
                        IgniteUuid fileId = fileIds.get(fileIds.size() - 1);
                        if (fileId == null || (info = IgfsImpl.this.meta.updateProperties(fileId, props)) == null) break;
                        if (IgfsImpl.this.evts.isRecordable(121)) {
                            IgfsImpl.this.evts.record(new IgfsEvent(path, IgfsImpl.this.igfsCtx.localNode(), 121, props));
                        }
                        return new IgfsFileImpl(path, info, IgfsImpl.this.data.groupBlockSize());
                    }
                    case DUAL_SYNC: 
                    case DUAL_ASYNC: {
                        IgfsImpl.this.await(path);
                        IgfsEntryInfo info = IgfsImpl.this.meta.updateDual(IgfsImpl.this.secondaryFs, path, props);
                        if (info == null) break;
                        return new IgfsFileImpl(path, info, IgfsImpl.this.data.groupBlockSize());
                    }
                    default: {
                        assert (mode == IgfsMode.PROXY) : "Unknown mode: " + (Object)((Object)mode);
                        IgfsFile status = IgfsImpl.this.secondaryFs.update(path, props);
                        return status != null ? new IgfsFileImpl(status, IgfsImpl.this.data.groupBlockSize()) : null;
                    }
                }
                return null;
            }
        });
    }

    @Override
    public void rename(final IgfsPath src, final IgfsPath dest) {
        A.notNull(src, "src");
        A.notNull(dest, "dest");
        if (this.meta.isClient()) {
            this.meta.runClientTask(new IgfsClientRenameCallable(this.cfg.getName(), IgfsUserContext.currentUser(), src, dest));
            return;
        }
        this.safeOp(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (IgfsImpl.this.log.isDebugEnabled()) {
                    IgfsImpl.this.log.debug("Rename file [src=" + src + ", dest=" + dest + ']');
                }
                IgfsMode mode = IgfsImpl.this.resolveMode(src);
                if (src.equals(dest)) {
                    return null;
                }
                if (src.parent() == null) {
                    throw new IgfsInvalidPathException("Root directory cannot be renamed.");
                }
                if (dest.isSubDirectoryOf(src)) {
                    throw new IgfsInvalidPathException("Failed to rename directory (cannot move directory of upper level to self sub-dir) [src=" + src + ", dest=" + dest + ']');
                }
                if (IgfsImpl.this.evictExclude(src, mode == IgfsMode.PRIMARY) != IgfsImpl.this.evictExclude(dest, IgfsImpl.this.modeRslvr.resolveMode(dest) == IgfsMode.PRIMARY)) {
                    throw new IgfsInvalidPathException("Cannot move file to a path with different eviction exclude setting (need to copy and remove)");
                }
                switch (mode) {
                    case PRIMARY: {
                        IgfsImpl.this.meta.move(src, dest);
                        break;
                    }
                    case DUAL_SYNC: 
                    case DUAL_ASYNC: {
                        IgfsImpl.this.await(src, dest);
                        IgfsImpl.this.meta.renameDual(IgfsImpl.this.secondaryFs, src, dest);
                        break;
                    }
                    default: {
                        assert (mode == IgfsMode.PROXY) : "Unknown mode: " + (Object)((Object)mode);
                        IgfsImpl.this.secondaryFs.rename(src, dest);
                    }
                }
                return null;
            }
        });
    }

    @Override
    public boolean delete(final IgfsPath path, final boolean recursive) {
        A.notNull(path, "path");
        if (this.meta.isClient()) {
            return this.meta.runClientTask(new IgfsClientDeleteCallable(this.cfg.getName(), IgfsUserContext.currentUser(), path, recursive));
        }
        return this.safeOp(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                IgfsDeleteResult res;
                if (IgfsImpl.this.log.isDebugEnabled()) {
                    IgfsImpl.this.log.debug("Deleting file [path=" + path + ", recursive=" + recursive + ']');
                }
                if (F.eq(IgfsPath.ROOT, path)) {
                    return false;
                }
                IgfsMode mode = IgfsImpl.this.resolveMode(path);
                if (mode == IgfsMode.PROXY) {
                    return IgfsImpl.this.secondaryFs.delete(path, recursive);
                }
                boolean dual = IgfsUtils.isDualMode(mode);
                if (dual) {
                    IgfsImpl.this.await(path);
                }
                if ((res = IgfsImpl.this.meta.softDelete(path, recursive, dual ? IgfsImpl.this.secondaryFs : null)).success() && res.info() != null) {
                    IgfsUtils.sendEvents(IgfsImpl.this.igfsCtx.kernalContext(), path, res.info().isFile() ? 118 : 126);
                }
                return res.success();
            }
        });
    }

    @Override
    public void mkdirs(IgfsPath path) {
        this.mkdirs(path, null);
    }

    @Override
    public void mkdirs(final IgfsPath path, final @Nullable Map<String, String> props) {
        A.notNull(path, "path");
        if (this.meta.isClient()) {
            this.meta.runClientTask(new IgfsClientMkdirsCallable(this.cfg.getName(), IgfsUserContext.currentUser(), path, props));
            return;
        }
        this.safeOp(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (IgfsImpl.this.log.isDebugEnabled()) {
                    IgfsImpl.this.log.debug("Make directories: " + path);
                }
                IgfsMode mode = IgfsImpl.this.resolveMode(path);
                switch (mode) {
                    case PRIMARY: {
                        IgfsImpl.this.meta.mkdirs(path, props == null ? DFLT_DIR_META : new HashMap(props));
                        break;
                    }
                    case DUAL_SYNC: 
                    case DUAL_ASYNC: {
                        IgfsImpl.this.await(path);
                        IgfsImpl.this.meta.mkdirsDual(IgfsImpl.this.secondaryFs, path, props);
                        break;
                    }
                    case PROXY: {
                        IgfsImpl.this.secondaryFs.mkdirs(path, props);
                    }
                }
                return null;
            }
        });
    }

    @Override
    public Collection<IgfsPath> listPaths(final IgfsPath path) {
        A.notNull(path, "path");
        if (this.meta.isClient()) {
            this.meta.runClientTask(new IgfsClientListPathsCallable(this.cfg.getName(), IgfsUserContext.currentUser(), path));
        }
        return this.safeOp(new Callable<Collection<IgfsPath>>(){

            @Override
            public Collection<IgfsPath> call() throws Exception {
                IgfsEntryInfo info;
                if (IgfsImpl.this.log.isDebugEnabled()) {
                    IgfsImpl.this.log.debug("List directory: " + path);
                }
                IgfsMode mode = IgfsImpl.this.resolveMode(path);
                HashSet<IgfsPath> files = new HashSet<IgfsPath>();
                if (mode != IgfsMode.PRIMARY) {
                    assert (IgfsImpl.this.secondaryFs != null);
                    try {
                        Collection<IgfsPath> children = IgfsImpl.this.secondaryFs.listPaths(path);
                        files.addAll(children);
                        if (mode == IgfsMode.PROXY || !IgfsImpl.this.modeRslvr.hasPrimaryChild(path)) {
                            return files;
                        }
                    }
                    catch (Exception e) {
                        U.error(IgfsImpl.this.log, "List paths in DUAL mode failed [path=" + path + ']', e);
                        throw e;
                    }
                }
                if ((info = IgfsImpl.this.primaryInfoForListing(path)) != null) {
                    for (String child : info.listing().keySet()) {
                        files.add(new IgfsPath(path, child));
                    }
                } else if (mode == IgfsMode.PRIMARY) {
                    throw new IgfsPathNotFoundException("Failed to list paths (path not found): " + path);
                }
                return files;
            }
        });
    }

    @Override
    public Collection<IgfsFile> listFiles(final IgfsPath path) {
        A.notNull(path, "path");
        if (this.meta.isClient()) {
            this.meta.runClientTask(new IgfsClientListFilesCallable(this.cfg.getName(), IgfsUserContext.currentUser(), path));
        }
        return this.safeOp(new Callable<Collection<IgfsFile>>(){

            @Override
            public Collection<IgfsFile> call() throws Exception {
                IgfsEntryInfo info;
                if (IgfsImpl.this.log.isDebugEnabled()) {
                    IgfsImpl.this.log.debug("List directory details: " + path);
                }
                IgfsMode mode = IgfsImpl.this.resolveMode(path);
                HashSet<IgfsFile> files = new HashSet<IgfsFile>();
                if (mode != IgfsMode.PRIMARY) {
                    assert (IgfsImpl.this.secondaryFs != null);
                    try {
                        Collection<IgfsFile> children = IgfsImpl.this.secondaryFs.listFiles(path);
                        for (IgfsFile igfsFile : children) {
                            IgfsFileImpl impl2 = new IgfsFileImpl(igfsFile, IgfsImpl.this.data.groupBlockSize());
                            files.add(impl2);
                        }
                        if (mode == IgfsMode.PROXY || !IgfsImpl.this.modeRslvr.hasPrimaryChild(path)) {
                            return files;
                        }
                    }
                    catch (Exception e) {
                        U.error(IgfsImpl.this.log, "List files in DUAL mode failed [path=" + path + ']', e);
                        throw e;
                    }
                }
                if ((info = IgfsImpl.this.primaryInfoForListing(path)) != null) {
                    if (info.isFile()) {
                        return Collections.singleton(new IgfsFileImpl(path, info, IgfsImpl.this.data.groupBlockSize()));
                    }
                    for (Map.Entry entry : info.listing().entrySet()) {
                        IgfsEntryInfo childInfo = IgfsImpl.this.meta.info(((IgfsListingEntry)entry.getValue()).fileId());
                        if (childInfo == null) continue;
                        IgfsPath childPath = new IgfsPath(path, (String)entry.getKey());
                        files.add(new IgfsFileImpl(childPath, childInfo, IgfsImpl.this.data.groupBlockSize()));
                    }
                } else if (mode == IgfsMode.PRIMARY) {
                    throw new IgfsPathNotFoundException("Failed to list files (path not found): " + path);
                }
                return files;
            }
        });
    }

    private IgfsEntryInfo primaryInfoForListing(IgfsPath path) throws IgniteCheckedException {
        IgniteUuid fileId = this.meta.fileId(path);
        return fileId != null ? this.meta.info(fileId) : null;
    }

    @Override
    public long usedSpaceSize() {
        return this.metrics().localSpaceSize();
    }

    @Override
    public IgfsInputStream open(IgfsPath path) {
        return this.open(path, this.cfg.getBufferSize(), this.cfg.getSequentialReadsBeforePrefetch());
    }

    @Override
    public IgfsInputStream open(IgfsPath path, int bufSize) {
        return this.open(path, bufSize, this.cfg.getSequentialReadsBeforePrefetch());
    }

    @Override
    public IgfsInputStream open(final IgfsPath path, final int bufSize, final int seqReadsBeforePrefetch) {
        A.notNull(path, "path");
        A.ensure(bufSize >= 0, "bufSize >= 0");
        A.ensure(seqReadsBeforePrefetch >= 0, "seqReadsBeforePrefetch >= 0");
        return this.safeOp(new Callable<IgfsInputStream>(){

            @Override
            public IgfsInputStream call() throws Exception {
                if (IgfsImpl.this.log.isDebugEnabled()) {
                    IgfsImpl.this.log.debug("Open file for reading [path=" + path + ", bufSize=" + bufSize + ']');
                }
                int bufSize0 = bufSize == 0 ? IgfsImpl.this.cfg.getBufferSize() : bufSize;
                IgfsMode mode = IgfsImpl.this.resolveMode(path);
                switch (mode) {
                    case PRIMARY: {
                        IgfsEntryInfo info = IgfsImpl.this.meta.infoForPath(path);
                        if (info == null) {
                            throw new IgfsPathNotFoundException("File not found: " + path);
                        }
                        if (!info.isFile()) {
                            throw new IgfsPathIsDirectoryException("Failed to open file (not a file): " + path);
                        }
                        IgfsInputStreamImpl os = new IgfsInputStreamImpl(IgfsImpl.this.igfsCtx, path, info, IgfsImpl.this.cfg.getPrefetchBlocks(), seqReadsBeforePrefetch, null, info.length(), info.blockSize(), info.blocksCount(), false);
                        IgfsUtils.sendEvents(IgfsImpl.this.igfsCtx.kernalContext(), path, 119);
                        return os;
                    }
                    case DUAL_SYNC: 
                    case DUAL_ASYNC: {
                        assert (IgfsUtils.isDualMode(mode));
                        IgfsSecondaryInputStreamDescriptor desc = IgfsImpl.this.meta.openDual(IgfsImpl.this.secondaryFs, path, bufSize0);
                        IgfsEntryInfo info = desc.info();
                        IgfsInputStreamImpl os = new IgfsInputStreamImpl(IgfsImpl.this.igfsCtx, path, info, IgfsImpl.this.cfg.getPrefetchBlocks(), seqReadsBeforePrefetch, desc.reader(), info.length(), info.blockSize(), info.blocksCount(), false);
                        IgfsUtils.sendEvents(IgfsImpl.this.igfsCtx.kernalContext(), path, 119);
                        return os;
                    }
                    case PROXY: {
                        assert (IgfsImpl.this.secondaryFs != null);
                        IgfsFile info = IgfsImpl.this.info(path);
                        if (info == null) {
                            throw new IgfsPathNotFoundException("File not found: " + path);
                        }
                        if (!info.isFile()) {
                            throw new IgfsPathIsDirectoryException("Failed to open file (not a file): " + path);
                        }
                        IgfsLazySecondaryFileSystemPositionedReadable secReader = new IgfsLazySecondaryFileSystemPositionedReadable(IgfsImpl.this.secondaryFs, path, bufSize);
                        long len = info.length();
                        int blockSize = info.blockSize() > 0 ? info.blockSize() : IgfsImpl.this.cfg.getBlockSize();
                        long blockCnt = len / (long)blockSize;
                        if (len % (long)blockSize != 0L) {
                            ++blockCnt;
                        }
                        IgfsInputStreamImpl os = new IgfsInputStreamImpl(IgfsImpl.this.igfsCtx, path, null, IgfsImpl.this.cfg.getPrefetchBlocks(), seqReadsBeforePrefetch, secReader, info.length(), blockSize, blockCnt, true);
                        IgfsUtils.sendEvents(IgfsImpl.this.igfsCtx.kernalContext(), path, 119);
                        return os;
                    }
                }
                assert (false) : "Unexpected mode " + (Object)((Object)mode);
                return null;
            }
        });
    }

    @Override
    public IgfsOutputStream create(IgfsPath path, boolean overwrite) {
        return this.create0(path, this.cfg.getBufferSize(), overwrite, null, 0, null, true);
    }

    @Override
    public IgfsOutputStream create(IgfsPath path, int bufSize, boolean overwrite, int replication, long blockSize, @Nullable Map<String, String> props) {
        return this.create0(path, bufSize, overwrite, null, replication, props, false);
    }

    @Override
    public IgfsOutputStream create(IgfsPath path, int bufSize, boolean overwrite, @Nullable IgniteUuid affKey, int replication, long blockSize, @Nullable Map<String, String> props) {
        return this.create0(path, bufSize, overwrite, affKey, replication, props, false);
    }

    private IgfsOutputStream create0(final IgfsPath path, final int bufSize, final boolean overwrite, final @Nullable IgniteUuid affKey, final int replication, final @Nullable Map<String, String> props, final boolean simpleCreate) {
        A.notNull(path, "path");
        A.ensure(bufSize >= 0, "bufSize >= 0");
        return this.safeOp(new Callable<IgfsOutputStream>(){

            @Override
            public IgfsOutputStream call() throws Exception {
                HashMap<String, String> fileProps;
                Map<String, String> dirProps;
                if (IgfsImpl.this.log.isDebugEnabled()) {
                    IgfsImpl.this.log.debug("Open file for writing [path=" + path + ", bufSize=" + bufSize + ", overwrite=" + overwrite + ", props=" + props + ']');
                }
                IgfsMode mode = IgfsImpl.this.resolveMode(path);
                if (props == null) {
                    dirProps = DFLT_DIR_META;
                    fileProps = null;
                } else {
                    fileProps = new HashMap<String, String>(props);
                    dirProps = fileProps;
                }
                if (mode == IgfsMode.PROXY) {
                    assert (IgfsImpl.this.secondaryFs != null);
                    OutputStream secondaryStream = IgfsImpl.this.secondaryFs.create(path, bufSize, overwrite, replication, IgfsImpl.this.groupBlockSize(), props);
                    IgfsFileWorkerBatch batch = IgfsImpl.this.newBatch(path, secondaryStream);
                    return new IgfsOutputStreamProxyImpl(IgfsImpl.this.igfsCtx, path, IgfsImpl.this.info(path), IgfsImpl.this.bufferSize(bufSize), batch);
                }
                IgfsSecondaryFileSystemCreateContext secondaryCtx = null;
                if (mode != IgfsMode.PRIMARY) {
                    secondaryCtx = new IgfsSecondaryFileSystemCreateContext(IgfsImpl.this.secondaryFs, path, overwrite, simpleCreate, fileProps, (short)replication, IgfsImpl.this.groupBlockSize(), bufSize);
                }
                if (mode != IgfsMode.PRIMARY) {
                    IgfsImpl.this.await(path);
                }
                IgfsCreateResult res = IgfsImpl.this.meta.create(path, dirProps, overwrite, IgfsImpl.this.cfg.getBlockSize(), affKey, IgfsImpl.this.evictExclude(path, mode == IgfsMode.PRIMARY), fileProps, secondaryCtx);
                assert (res != null);
                OutputStream secondaryStream = res.secondaryOutputStream();
                IgfsFileWorkerBatch batch = secondaryStream != null ? IgfsImpl.this.newBatch(path, secondaryStream) : null;
                return new IgfsOutputStreamImpl(IgfsImpl.this.igfsCtx, path, res.info(), IgfsImpl.this.bufferSize(bufSize), mode, batch);
            }
        });
    }

    @Override
    public IgfsOutputStream append(IgfsPath path, boolean create) {
        return this.append(path, this.cfg.getBufferSize(), create, null);
    }

    @Override
    public IgfsOutputStream append(final IgfsPath path, final int bufSize, final boolean create, final @Nullable Map<String, String> props) {
        A.notNull(path, "path");
        A.ensure(bufSize >= 0, "bufSize >= 0");
        return this.safeOp(new Callable<IgfsOutputStream>(){

            @Override
            public IgfsOutputStream call() throws Exception {
                HashMap<String, String> fileProps;
                Map<String, String> dirProps;
                IgfsMode mode;
                if (IgfsImpl.this.log.isDebugEnabled()) {
                    IgfsImpl.this.log.debug("Open file for appending [path=" + path + ", bufSize=" + bufSize + ", create=" + create + ", props=" + props + ']');
                }
                if ((mode = IgfsImpl.this.resolveMode(path)) == IgfsMode.PROXY) {
                    assert (IgfsImpl.this.secondaryFs != null);
                    OutputStream secondaryStream = IgfsImpl.this.secondaryFs.append(path, bufSize, create, props);
                    IgfsFileWorkerBatch batch = IgfsImpl.this.newBatch(path, secondaryStream);
                    return new IgfsOutputStreamProxyImpl(IgfsImpl.this.igfsCtx, path, IgfsImpl.this.info(path), IgfsImpl.this.bufferSize(bufSize), batch);
                }
                if (mode != IgfsMode.PRIMARY) {
                    assert (IgfsUtils.isDualMode(mode));
                    IgfsImpl.this.await(path);
                    IgfsCreateResult desc = IgfsImpl.this.meta.appendDual(IgfsImpl.this.secondaryFs, path, bufSize, create);
                    IgfsFileWorkerBatch batch = IgfsImpl.this.newBatch(path, desc.secondaryOutputStream());
                    return new IgfsOutputStreamImpl(IgfsImpl.this.igfsCtx, path, desc.info(), IgfsImpl.this.bufferSize(bufSize), mode, batch);
                }
                List<IgniteUuid> ids = IgfsImpl.this.meta.idsForPath(path);
                IgniteUuid id = ids.get(ids.size() - 1);
                if (id == null && !create) {
                    throw new IgfsPathNotFoundException("File not found: " + path);
                }
                if (ids.size() == 1) {
                    throw new IgfsPathIsDirectoryException("Failed to open file (not a file): " + path);
                }
                if (props == null) {
                    dirProps = DFLT_DIR_META;
                    fileProps = null;
                } else {
                    fileProps = new HashMap<String, String>(props);
                    dirProps = fileProps;
                }
                IgfsEntryInfo res = IgfsImpl.this.meta.append(path, dirProps, create, IgfsImpl.this.cfg.getBlockSize(), null, IgfsImpl.this.evictExclude(path, true), fileProps);
                assert (res != null);
                return new IgfsOutputStreamImpl(IgfsImpl.this.igfsCtx, path, res, IgfsImpl.this.bufferSize(bufSize), mode, null);
            }
        });
    }

    @Override
    public void setTimes(final IgfsPath path, final long modificationTime, final long accessTime) {
        A.notNull(path, "path");
        if (accessTime == -1L && modificationTime == -1L) {
            return;
        }
        if (this.meta.isClient()) {
            this.meta.runClientTask(new IgfsClientSetTimesCallable(this.cfg.getName(), IgfsUserContext.currentUser(), path, accessTime, modificationTime));
            return;
        }
        this.safeOp(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                IgfsMode mode = IgfsImpl.this.resolveMode(path);
                if (mode == IgfsMode.PROXY) {
                    IgfsImpl.this.secondaryFs.setTimes(path, modificationTime, accessTime);
                } else {
                    IgfsImpl.this.meta.updateTimes(path, modificationTime, accessTime, IgfsUtils.isDualMode(mode) ? IgfsImpl.this.secondaryFs : null);
                }
                return null;
            }
        });
    }

    @Override
    public Collection<IgfsBlockLocation> affinity(IgfsPath path, long start, long len) {
        return this.affinity(path, start, len, 0L);
    }

    @Override
    public Collection<IgfsBlockLocation> affinity(final IgfsPath path, final long start, final long len, final long maxLen) {
        A.notNull(path, "path");
        A.ensure(start >= 0L, "start >= 0");
        A.ensure(len >= 0L, "len >= 0");
        if (this.meta.isClient()) {
            return this.meta.runClientTask(new IgfsClientAffinityCallable(this.cfg.getName(), IgfsUserContext.currentUser(), path, start, len, maxLen));
        }
        return this.safeOp(new Callable<Collection<IgfsBlockLocation>>(){

            @Override
            public Collection<IgfsBlockLocation> call() throws Exception {
                IgfsMode mode;
                if (IgfsImpl.this.log.isDebugEnabled()) {
                    IgfsImpl.this.log.debug("Get affinity for file block [path=" + path + ", start=" + start + ", len=" + len + ']');
                }
                if ((mode = IgfsImpl.this.resolveMode(path)) == IgfsMode.PROXY) {
                    return IgfsImpl.this.secondaryFs.affinity(path, start, len, maxLen);
                }
                IgfsEntryInfo info = IgfsImpl.this.meta.infoForPath(path);
                if (info == null && mode != IgfsMode.PRIMARY) {
                    assert (IgfsUtils.isDualMode(mode));
                    assert (IgfsImpl.this.secondaryFs != null);
                    info = IgfsImpl.this.meta.synchronizeFileDual(IgfsImpl.this.secondaryFs, path);
                }
                if (info == null) {
                    throw new IgfsPathNotFoundException("File not found: " + path);
                }
                if (!info.isFile()) {
                    throw new IgfsPathIsDirectoryException("Failed to get affinity for path because it is not a file: " + path);
                }
                return IgfsImpl.this.data.affinity(info, start, len, maxLen);
            }
        });
    }

    @Override
    public IgfsMetrics metrics() {
        return this.safeOp(new Callable<IgfsMetrics>(){

            @Override
            public IgfsMetrics call() throws Exception {
                IgfsPathSummary sum = IgfsImpl.this.summary0(IgfsPath.ROOT);
                long secondarySpaceSize = 0L;
                if (IgfsImpl.this.secondaryFs != null) {
                    try {
                        secondarySpaceSize = IgfsImpl.this.secondaryFs.usedSpaceSize();
                    }
                    catch (IgniteException e) {
                        LT.error(IgfsImpl.this.log, e, "Failed to get secondary file system consumed space size.");
                        secondarySpaceSize = -1L;
                    }
                }
                IgfsLocalMetrics metrics = IgfsImpl.this.igfsCtx.metrics();
                return new IgfsMetricsAdapter(IgfsImpl.this.igfsCtx.data().spaceSize(), IgfsImpl.this.igfsCtx.data().maxSpaceSize(), secondarySpaceSize, sum.directoriesCount(), sum.filesCount(), metrics.filesOpenedForRead(), metrics.filesOpenedForWrite(), metrics.readBlocks(), metrics.readBlocksSecondary(), metrics.writeBlocks(), metrics.writeBlocksSecondary(), metrics.readBytes(), metrics.readBytesTime(), metrics.writeBytes(), metrics.writeBytesTime());
            }
        });
    }

    @Override
    public void resetMetrics() {
        this.igfsCtx.metrics().reset();
    }

    @Override
    public long size(final IgfsPath path) {
        A.notNull(path, "path");
        if (this.meta.isClient()) {
            return this.meta.runClientTask(new IgfsClientSizeCallable(this.cfg.getName(), IgfsUserContext.currentUser(), path));
        }
        return this.safeOp(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return IgfsImpl.this.summary0(path).totalLength();
            }
        });
    }

    private IgfsPathSummary summary0(IgfsPath path) throws IgniteCheckedException {
        IgfsFile info = this.info(path);
        if (info == null) {
            throw new IgfsPathNotFoundException("Failed to get path summary (path not found): " + path);
        }
        IgfsPathSummary sum = new IgfsPathSummary(path);
        this.summaryRecursive(info, sum);
        return sum;
    }

    private void summaryRecursive(IgfsFile file, IgfsPathSummary sum) throws IgniteCheckedException {
        assert (file != null);
        assert (sum != null);
        if (file.isDirectory()) {
            if (!F.eq(IgfsPath.ROOT, file.path())) {
                sum.directoriesCount(sum.directoriesCount() + 1);
            }
            for (IgfsFile childFile : this.listFiles(file.path())) {
                this.summaryRecursive(childFile, sum);
            }
        } else {
            sum.filesCount(sum.filesCount() + 1);
            sum.totalLength(sum.totalLength() + file.length());
        }
    }

    @Override
    public void clear() {
        try {
            IgniteUuid id = this.meta.format();
            if (id == null) {
                return;
            }
            while (true) {
                if (this.enterBusy()) {
                    try {
                        if (!this.meta.exists(id)) {
                            return;
                        }
                    }
                    finally {
                        this.busyLock.leaveBusy();
                    }
                }
                U.sleep(10L);
            }
        }
        catch (Exception e) {
            throw IgfsUtils.toIgfsException(e);
        }
    }

    @Override
    public IgniteFuture<Void> clearAsync() throws IgniteException {
        return this.createFuture(this.clearAsync0());
    }

    IgniteInternalFuture<?> clearAsync0() {
        GridFutureAdapter fut = new GridFutureAdapter();
        Thread t = new Thread((Runnable)new FormatRunnable(fut), "igfs-format-" + this.cfg.getName() + "-" + FORMAT_THREAD_IDX_GEN.incrementAndGet());
        t.setDaemon(true);
        t.start();
        return fut;
    }

    @Override
    public <T, R> R execute(IgfsTask<T, R> task, @Nullable IgfsRecordResolver rslvr, Collection<IgfsPath> paths, @Nullable T arg) {
        try {
            return this.executeAsync0(task, rslvr, paths, arg).get();
        }
        catch (Exception e) {
            throw IgfsUtils.toIgfsException(e);
        }
    }

    @Override
    public <T, R> IgniteFuture<R> executeAsync(IgfsTask<T, R> task, @Nullable IgfsRecordResolver rslvr, Collection<IgfsPath> paths, @Nullable T arg) throws IgniteException {
        return this.createFuture(this.executeAsync0(task, rslvr, paths, arg));
    }

    @Override
    public <T, R> R execute(IgfsTask<T, R> task, @Nullable IgfsRecordResolver rslvr, Collection<IgfsPath> paths, boolean skipNonExistentFiles, long maxRangeLen, @Nullable T arg) {
        try {
            return this.executeAsync0(task, rslvr, paths, skipNonExistentFiles, maxRangeLen, arg).get();
        }
        catch (Exception e) {
            throw IgfsUtils.toIgfsException(e);
        }
    }

    @Override
    public <T, R> IgniteFuture<R> executeAsync(IgfsTask<T, R> task, @Nullable IgfsRecordResolver rslvr, Collection<IgfsPath> paths, boolean skipNonExistentFiles, long maxRangeLen, @Nullable T arg) throws IgniteException {
        return this.createFuture(this.executeAsync0(task, rslvr, paths, skipNonExistentFiles, maxRangeLen, arg));
    }

    @Override
    public <T, R> R execute(Class<? extends IgfsTask<T, R>> taskCls, @Nullable IgfsRecordResolver rslvr, Collection<IgfsPath> paths, @Nullable T arg) {
        try {
            return this.executeAsync0(taskCls, rslvr, paths, arg).get();
        }
        catch (Exception e) {
            throw IgfsUtils.toIgfsException(e);
        }
    }

    @Override
    public <T, R> IgniteFuture<R> executeAsync(Class<? extends IgfsTask<T, R>> taskCls, @Nullable IgfsRecordResolver rslvr, Collection<IgfsPath> paths, @Nullable T arg) throws IgniteException {
        return this.createFuture(this.executeAsync0(taskCls, rslvr, paths, arg));
    }

    @Override
    public <T, R> R execute(Class<? extends IgfsTask<T, R>> taskCls, @Nullable IgfsRecordResolver rslvr, Collection<IgfsPath> paths, boolean skipNonExistentFiles, long maxRangeSize, @Nullable T arg) {
        try {
            return this.executeAsync0(taskCls, rslvr, paths, skipNonExistentFiles, maxRangeSize, arg).get();
        }
        catch (Exception e) {
            throw IgfsUtils.toIgfsException(e);
        }
    }

    @Override
    public <T, R> IgniteFuture<R> executeAsync(Class<? extends IgfsTask<T, R>> taskCls, @Nullable IgfsRecordResolver rslvr, Collection<IgfsPath> paths, boolean skipNonExistentFiles, long maxRangeLen, @Nullable T arg) throws IgniteException {
        return this.createFuture(this.executeAsync0(taskCls, rslvr, paths, skipNonExistentFiles, maxRangeLen, arg));
    }

    <T, R> IgniteInternalFuture<R> executeAsync0(IgfsTask<T, R> task, @Nullable IgfsRecordResolver rslvr, Collection<IgfsPath> paths, @Nullable T arg) {
        return this.executeAsync0(task, rslvr, paths, true, this.cfg.getMaximumTaskRangeLength(), arg);
    }

    <T, R> IgniteInternalFuture<R> executeAsync0(IgfsTask<T, R> task, @Nullable IgfsRecordResolver rslvr, Collection<IgfsPath> paths, boolean skipNonExistentFiles, long maxRangeLen, @Nullable T arg) {
        return this.igfsCtx.kernalContext().task().execute(task, new IgfsTaskArgsImpl<T>(this.cfg.getName(), paths, rslvr, skipNonExistentFiles, maxRangeLen, arg));
    }

    <T, R> IgniteInternalFuture<R> executeAsync0(Class<? extends IgfsTask<T, R>> taskCls, @Nullable IgfsRecordResolver rslvr, Collection<IgfsPath> paths, @Nullable T arg) {
        return this.executeAsync0(taskCls, rslvr, paths, true, this.cfg.getMaximumTaskRangeLength(), arg);
    }

    <T, R> IgniteInternalFuture<R> executeAsync0(Class<? extends IgfsTask<T, R>> taskCls, @Nullable IgfsRecordResolver rslvr, Collection<IgfsPath> paths, boolean skipNonExistentFiles, long maxRangeLen, @Nullable T arg) {
        return this.igfsCtx.kernalContext().task().execute(taskCls, new IgfsTaskArgsImpl<T>(this.cfg.getName(), paths, rslvr, skipNonExistentFiles, maxRangeLen, arg));
    }

    @Override
    public boolean evictExclude(IgfsPath path, boolean primary) {
        assert (path != null);
        try {
            return primary || this.evictPlc == null || this.evictPlc.exclude(path);
        }
        catch (IgniteCheckedException e) {
            LT.error(this.log, e, "Failed to check whether the path must be excluded from evictions: " + path);
            return false;
        }
    }

    private IgfsFileImpl resolveFileInfo(IgfsPath path, IgfsMode mode) throws Exception {
        assert (path != null);
        assert (mode != null);
        IgfsEntryInfo info = null;
        switch (mode) {
            case PRIMARY: {
                info = this.meta.infoForPath(path);
                break;
            }
            case DUAL_SYNC: 
            case DUAL_ASYNC: {
                try {
                    IgfsFile status = this.secondaryFs.info(path);
                    if (status != null) {
                        return new IgfsFileImpl(status, this.data.groupBlockSize());
                    }
                    break;
                }
                catch (Exception e) {
                    U.error(this.log, "File info operation in DUAL mode failed [path=" + path + ']', e);
                    throw e;
                }
            }
            default: {
                assert (mode == IgfsMode.PROXY) : "Unknown mode: " + (Object)((Object)mode);
                IgfsFile status = this.secondaryFs.info(path);
                if (status != null) {
                    return new IgfsFileImpl(status, this.data.groupBlockSize());
                }
                return null;
            }
        }
        if (info == null) {
            return null;
        }
        return new IgfsFileImpl(path, info, this.data.groupBlockSize());
    }

    @Override
    public IgniteFileSystem withAsync() {
        return new IgfsAsyncImpl(this);
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public <R> IgniteFuture<R> future() {
        throw new IllegalStateException("Asynchronous mode is not enabled.");
    }

    @Override
    public IgniteUuid nextAffinityKey() {
        return this.safeOp(new Callable<IgniteUuid>(){

            @Override
            public IgniteUuid call() throws Exception {
                return IgfsImpl.this.data.nextAffinityKey(null);
            }
        });
    }

    @Override
    public boolean isProxy(URI path) {
        IgfsMode mode = F.isEmpty(this.cfg.getPathModes()) ? this.cfg.getDefaultMode() : this.modeRslvr.resolveMode(new IgfsPath(path));
        return mode == IgfsMode.PROXY;
    }

    @Override
    public IgfsSecondaryFileSystem asSecondary() {
        return new IgfsSecondaryFileSystemImpl(this);
    }

    private IgfsMode resolveMode(IgfsPath path) {
        return this.modeRslvr.resolveMode(path);
    }

    private <T> T safeOp(Callable<T> act) {
        if (this.enterBusy()) {
            try {
                T t = act.call();
                return t;
            }
            catch (Exception e) {
                throw IgfsUtils.toIgfsException(e);
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to perform IGFS action because grid is stopping.");
    }

    private int bufferSize(int bufSize) {
        return bufSize == 0 ? this.cfg.getBufferSize() : bufSize;
    }

    private <R> IgniteFuture<R> createFuture(IgniteInternalFuture<R> fut) {
        return new IgniteFutureImpl<R>(fut);
    }

    private class FormatRunnable
    implements Runnable {
        private final GridFutureAdapter<?> fut;

        public FormatRunnable(GridFutureAdapter<?> fut) {
            this.fut = fut;
        }

        @Override
        public void run() {
            IgfsException err = null;
            try {
                IgfsImpl.this.clear();
            }
            catch (Throwable err0) {
                err = IgfsUtils.toIgfsException(err0);
            }
            finally {
                if (err == null) {
                    this.fut.onDone();
                } else {
                    this.fut.onDone(err);
                }
            }
        }
    }

    private static class IgfsThreadFactory
    implements ThreadFactory {
        private final String name;
        private final AtomicLong ctr = new AtomicLong();

        private IgfsThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("igfs-<" + this.name + ">-batch-worker-thread-" + this.ctr.incrementAndGet());
            t.setDaemon(true);
            return t;
        }
    }

    @GridInternal
    private static class IgfsGlobalSpaceTask
    extends ComputeTaskSplitAdapter<Object, IgniteBiTuple<Long, Long>> {
        private static final long serialVersionUID = 0L;
        private String igfsName;

        private IgfsGlobalSpaceTask(@Nullable String igfsName) {
            this.igfsName = igfsName;
        }

        @Override
        protected Collection<? extends ComputeJob> split(int gridSize, Object arg) {
            ArrayList<1> res = new ArrayList<1>(gridSize);
            for (int i = 0; i < gridSize; ++i) {
                res.add(new ComputeJobAdapter(){
                    @IgniteInstanceResource
                    private Ignite g;

                    @Override
                    @Nullable
                    public IgniteBiTuple<Long, Long> execute() {
                        IgniteFileSystem igfs = ((IgniteKernal)this.g).context().igfs().igfs(igfsName);
                        if (igfs == null) {
                            return F.t(0L, 0L);
                        }
                        IgfsMetrics metrics = igfs.metrics();
                        long loc = metrics.localSpaceSize();
                        return F.t(loc, metrics.maxSpaceSize());
                    }
                });
            }
            return res;
        }

        @Override
        @Nullable
        public IgniteBiTuple<Long, Long> reduce(List<ComputeJobResult> results) {
            long used = 0L;
            long max = 0L;
            for (ComputeJobResult res : results) {
                IgniteBiTuple data = (IgniteBiTuple)res.getData();
                if (data == null) continue;
                used += ((Long)data.get1()).longValue();
                max += ((Long)data.get2()).longValue();
            }
            return F.t(used, max);
        }

        @Override
        public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
            return ComputeJobResultPolicy.WAIT;
        }
    }
}

