/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.processors.cache.verify.PartitionKeyV2;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class PartitionHashRecordV2
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    public static final long MOVING_PARTITION_SIZE = Long.MIN_VALUE;
    @GridToStringExclude
    private PartitionKeyV2 partKey;
    private boolean isPrimary;
    @GridToStringInclude
    private Object consistentId;
    @GridToStringExclude
    private int partHash;
    private long updateCntr;
    @GridToStringExclude
    private long size;

    public PartitionHashRecordV2(PartitionKeyV2 partKey, boolean isPrimary, Object consistentId, int partHash, long updateCntr, long size) {
        this.partKey = partKey;
        this.isPrimary = isPrimary;
        this.consistentId = consistentId;
        this.partHash = partHash;
        this.updateCntr = updateCntr;
        this.size = size;
    }

    public PartitionHashRecordV2() {
    }

    public PartitionKeyV2 partitionKey() {
        return this.partKey;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public Object consistentId() {
        return this.consistentId;
    }

    public int partitionHash() {
        return this.partHash;
    }

    public long updateCounter() {
        return this.updateCntr;
    }

    public long size() {
        return this.size;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeObject(this.partKey);
        out.writeBoolean(this.isPrimary);
        out.writeObject(this.consistentId);
        out.writeInt(this.partHash);
        out.writeLong(this.updateCntr);
        out.writeLong(this.size);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.partKey = (PartitionKeyV2)in.readObject();
        this.isPrimary = in.readBoolean();
        this.consistentId = in.readObject();
        this.partHash = in.readInt();
        this.updateCntr = in.readLong();
        this.size = in.readLong();
    }

    public String toString() {
        return this.size == Long.MIN_VALUE ? S.toString(PartitionHashRecordV2.class, this, "state", "MOVING") : S.toString(PartitionHashRecordV2.class, this, "size", this.size, "partHash", this.partHash);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionHashRecordV2 record = (PartitionHashRecordV2)o;
        return this.consistentId.equals(record.consistentId);
    }

    public int hashCode() {
        return this.consistentId.hashCode();
    }
}

