/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.io;

import java.io.IOException;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.ByteBufferExpander;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentRouter;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentAware;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.FileInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.LockedReadFileInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentFileInputFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentIO;

public class LockedSegmentFileInputFactory
implements SegmentFileInputFactory {
    private final SegmentAware segmentAware;
    private final SegmentRouter segmentRouter;
    private final FileIOFactory fileIOFactory;

    public LockedSegmentFileInputFactory(SegmentAware segmentAware, SegmentRouter segmentRouter, FileIOFactory fileIOFactory) {
        this.segmentAware = segmentAware;
        this.segmentRouter = segmentRouter;
        this.fileIOFactory = fileIOFactory;
    }

    @Override
    public FileInput createFileInput(SegmentIO segmentIO, ByteBufferExpander buf) throws IOException {
        return new LockedReadFileInput(buf, segmentIO, this.segmentAware, id -> {
            FileDescriptor segment = this.segmentRouter.findSegment(id);
            return segment.toIO(this.fileIOFactory);
        });
    }
}

