/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteDiagnosticAware;
import org.apache.ignite.internal.IgniteDiagnosticPrepareContext;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgniteNeedReconnectException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.events.DiscoveryCustomEvent;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.DiscoveryLocalJoinData;
import org.apache.ignite.internal.managers.eventstorage.DiscoveryEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignmentCache;
import org.apache.ignite.internal.processors.cache.CacheAffinityChangeMessage;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.CachePartitionExchangeWorkerTask;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeBatch;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeFailureMessage;
import org.apache.ignite.internal.processors.cache.ExchangeActions;
import org.apache.ignite.internal.processors.cache.ExchangeDiscoveryEvents;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheExplicitLockSpan;
import org.apache.ignite.internal.processors.cache.GridCacheFuture;
import org.apache.ignite.internal.processors.cache.GridCacheGroupIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccManager;
import org.apache.ignite.internal.processors.cache.GridCachePreloader;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.LocalJoinCachesContext;
import org.apache.ignite.internal.processors.cache.PendingDiscoveryEvent;
import org.apache.ignite.internal.processors.cache.WalStateAbstractMessage;
import org.apache.ignite.internal.processors.cache.WalStateNodeLeaveExchangeTask;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionFullCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.ForceRebalanceExchangeTask;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemandLegacyMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemandMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionFullMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionSupplyMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsFullMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsSingleMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsSingleRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPreloaderAssignments;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtPartitionHistorySuppliersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtPartitionsToReloadMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.RebalanceReassignExchangeTask;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.StopCachesOnClientReconnectExchangeTask;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.latch.ExchangeLatchManager;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridClientPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotDiscoveryMessage;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateFinishMessage;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateMessage;
import org.apache.ignite.internal.processors.query.schema.SchemaNodeLeaveExchangeWorkerTask;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.util.GridListSet;
import org.apache.ignite.internal.util.GridPartitionStateMap;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCachePartitionExchangeManager<K, V>
extends GridCacheSharedManagerAdapter<K, V> {
    private final int EXCHANGE_HISTORY_SIZE = IgniteSystemProperties.getInteger("IGNITE_EXCHANGE_HISTORY_SIZE", 1000);
    private final long IGNITE_EXCHANGE_MERGE_DELAY = IgniteSystemProperties.getLong("IGNITE_EXCHANGE_MERGE_DELAY", 0L);
    private static final IgniteProductVersion EXCHANGE_PROTOCOL_2_SINCE = IgniteProductVersion.fromString("2.1.4");
    private AtomicReference<ResendTimeoutObject> pendingResend = new AtomicReference();
    private final long partResendTimeout = IgniteSystemProperties.getLong("IGNITE_PRELOAD_RESEND_TIMEOUT", 1500L);
    private final ReadWriteLock busyLock = new ReentrantReadWriteLock();
    private final AtomicLong lastRefresh = new AtomicLong(-1L);
    @GridToStringInclude
    private ExchangeWorker exchWorker;
    @GridToStringExclude
    private final ConcurrentMap<Integer, GridClientPartitionTopology> clientTops = new ConcurrentHashMap<Integer, GridClientPartitionTopology>();
    @Nullable
    private volatile GridDhtPartitionsExchangeFuture lastInitializedFut;
    private final AtomicReference<GridDhtTopologyFuture> lastFinishedFut = new AtomicReference();
    private final ConcurrentMap<AffinityTopologyVersion, AffinityReadyFuture> readyFuts = new ConcurrentSkipListMap<AffinityTopologyVersion, AffinityReadyFuture>();
    private volatile AffinityTopologyVersion rebTopVer = AffinityTopologyVersion.NONE;
    private GridFutureAdapter<?> reconnectExchangeFut;
    private final Object interruptLock = new Object();
    private ExchangeFutureSet exchFuts = new ExchangeFutureSet(this.EXCHANGE_HISTORY_SIZE);
    private volatile IgniteCheckedException stopErr;
    private long nextLongRunningOpsDumpTime;
    private int longRunningOpsDumpStep;
    private DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private final List<PendingDiscoveryEvent> pendingEvts = new ArrayList<PendingDiscoveryEvent>();
    private final GridFutureAdapter<?> crdInitFut = new GridFutureAdapter();
    private volatile AffinityTopologyVersion exchMergeTestWaitVer;
    private volatile List mergedEvtsForTest;
    private ExchangeLatchManager latchMgr;
    private final DiscoveryEventListener discoLsnr = new DiscoveryEventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(DiscoveryEvent evt, DiscoCache cache) {
            if (!GridCachePartitionExchangeManager.this.enterBusy()) {
                return;
            }
            try {
                if (evt.type() == 18 && ((DiscoveryCustomEvent)evt).customMessage() instanceof ChangeGlobalStateMessage) {
                    ChangeGlobalStateMessage stateChangeMsg = (ChangeGlobalStateMessage)((DiscoveryCustomEvent)evt).customMessage();
                    if (stateChangeMsg.exchangeActions() == null) {
                        return;
                    }
                    GridCachePartitionExchangeManager.this.onDiscoveryEvent(evt, cache);
                    return;
                }
                if (evt.type() == 18 && ((DiscoveryCustomEvent)evt).customMessage() instanceof ChangeGlobalStateFinishMessage) {
                    ChangeGlobalStateFinishMessage stateFinishMsg = (ChangeGlobalStateFinishMessage)((DiscoveryCustomEvent)evt).customMessage();
                    if (stateFinishMsg.clusterActive()) {
                        for (PendingDiscoveryEvent pendingEvt : GridCachePartitionExchangeManager.this.pendingEvts) {
                            if (GridCachePartitionExchangeManager.this.log.isDebugEnabled()) {
                                GridCachePartitionExchangeManager.this.log.debug("Process pending event: " + pendingEvt.event());
                            }
                            GridCachePartitionExchangeManager.this.onDiscoveryEvent(pendingEvt.event(), pendingEvt.discoCache());
                        }
                    } else {
                        for (PendingDiscoveryEvent pendingEvt : GridCachePartitionExchangeManager.this.pendingEvts) {
                            GridCachePartitionExchangeManager.this.processEventInactive(pendingEvt.event(), pendingEvt.discoCache());
                        }
                    }
                    GridCachePartitionExchangeManager.this.pendingEvts.clear();
                    return;
                }
                if (cache.state().transition()) {
                    if (GridCachePartitionExchangeManager.this.log.isDebugEnabled()) {
                        GridCachePartitionExchangeManager.this.log.debug("Adding pending event: " + evt);
                    }
                    GridCachePartitionExchangeManager.this.pendingEvts.add(new PendingDiscoveryEvent(evt, cache));
                } else if (cache.state().active()) {
                    GridCachePartitionExchangeManager.this.onDiscoveryEvent(evt, cache);
                } else {
                    GridCachePartitionExchangeManager.this.processEventInactive(evt, cache);
                }
                GridCachePartitionExchangeManager.this.notifyNodeFail(evt);
            }
            finally {
                GridCachePartitionExchangeManager.this.leaveBusy();
            }
        }
    };

    private void notifyNodeFail(DiscoveryEvent evt) {
        if (evt.type() == 11 || evt.type() == 12) {
            ClusterNode n = evt.eventNode();
            assert (this.cctx.discovery().node(n.id()) == null);
            for (GridDhtPartitionsExchangeFuture f : this.exchFuts.values()) {
                f.onNodeLeft(n);
            }
        }
    }

    private void processEventInactive(DiscoveryEvent evt, DiscoCache cache) {
        this.cctx.cache().localJoinCachesContext();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Ignore event, cluster is inactive: " + evt);
        }
    }

    @Override
    protected void start0() throws IgniteCheckedException {
        super.start0();
        this.exchWorker = new ExchangeWorker();
        this.latchMgr = new ExchangeLatchManager(this.cctx.kernalContext());
        this.cctx.gridEvents().addDiscoveryEventListener(this.discoLsnr, 10, 11, 12, 18);
        this.cctx.io().addCacheHandler(0, GridDhtPartitionsSingleMessage.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new MessageHandler<GridDhtPartitionsSingleMessage>(){

            @Override
            public void onMessage(final ClusterNode node, final GridDhtPartitionsSingleMessage msg) {
                GridDhtPartitionExchangeId exchangeId = msg.exchangeId();
                if (exchangeId != null) {
                    GridDhtPartitionsExchangeFuture fut = GridCachePartitionExchangeManager.this.exchangeFuture(exchangeId);
                    boolean fastReplied = fut.fastReplyOnSingleMessage(node, msg);
                    if (fastReplied) {
                        if (GridCachePartitionExchangeManager.this.log.isInfoEnabled()) {
                            GridCachePartitionExchangeManager.this.log.info("Fast replied to single message [exchId=" + exchangeId + ", nodeId=" + node.id() + "]");
                        }
                        return;
                    }
                } else if (GridCachePartitionExchangeManager.this.exchangeInProgress()) {
                    if (GridCachePartitionExchangeManager.this.log.isInfoEnabled()) {
                        GridCachePartitionExchangeManager.this.log.info("Ignore single message without exchange id (there is exchange in progress) [nodeId=" + node.id() + "]");
                    }
                    return;
                }
                if (!GridCachePartitionExchangeManager.this.crdInitFut.isDone() && !msg.restoreState()) {
                    GridDhtPartitionExchangeId exchId = msg.exchangeId();
                    if (GridCachePartitionExchangeManager.this.log.isInfoEnabled()) {
                        GridCachePartitionExchangeManager.this.log.info("Waiting for coordinator initialization [node=" + node.id() + ", nodeOrder=" + node.order() + ", ver=" + (exchId != null ? exchId.topologyVersion() : null) + ']');
                    }
                    GridCachePartitionExchangeManager.this.crdInitFut.listen(new CI1<IgniteInternalFuture>(){

                        @Override
                        public void apply(IgniteInternalFuture fut) {
                            GridCachePartitionExchangeManager.this.processSinglePartitionUpdate(node, msg);
                        }
                    });
                    return;
                }
                GridCachePartitionExchangeManager.this.processSinglePartitionUpdate(node, msg);
            }
        });
        this.cctx.io().addCacheHandler(0, GridDhtPartitionsFullMessage.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new MessageHandler<GridDhtPartitionsFullMessage>(){

            @Override
            public void onMessage(ClusterNode node, GridDhtPartitionsFullMessage msg) {
                GridDhtPartitionsExchangeFuture currentExchange;
                if (msg.exchangeId() == null && (currentExchange = GridCachePartitionExchangeManager.this.lastTopologyFuture()) != null && currentExchange.addOrMergeDelayedFullMessage(node, msg)) {
                    if (GridCachePartitionExchangeManager.this.log.isInfoEnabled()) {
                        GridCachePartitionExchangeManager.this.log.info("Delay process full message without exchange id (there is exchange in progress) [nodeId=" + node.id() + "]");
                    }
                    return;
                }
                GridCachePartitionExchangeManager.this.processFullPartitionUpdate(node, msg);
            }
        });
        this.cctx.io().addCacheHandler(0, GridDhtPartitionsSingleRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new MessageHandler<GridDhtPartitionsSingleRequest>(){

            @Override
            public void onMessage(ClusterNode node, GridDhtPartitionsSingleRequest msg) {
                GridCachePartitionExchangeManager.this.processSinglePartitionRequest(node, msg);
            }
        });
        if (!this.cctx.kernalContext().clientNode()) {
            for (int cnt = 0; cnt < this.cctx.gridConfig().getRebalanceThreadPoolSize(); ++cnt) {
                final int idx = cnt;
                this.cctx.io().addOrderedCacheGroupHandler(this.cctx, GridCachePartitionExchangeManager.rebalanceTopic(cnt), (IgniteBiInClosure<UUID, ? extends GridCacheGroupIdMessage>)new CI2<UUID, GridCacheGroupIdMessage>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void apply(UUID id, GridCacheGroupIdMessage m) {
                        if (!GridCachePartitionExchangeManager.this.enterBusy()) {
                            return;
                        }
                        try {
                            CacheGroupContext grp = GridCachePartitionExchangeManager.this.cctx.cache().cacheGroup(m.groupId());
                            if (grp != null) {
                                if (m instanceof GridDhtPartitionSupplyMessage) {
                                    grp.preloader().handleSupplyMessage(idx, id, (GridDhtPartitionSupplyMessage)m);
                                    return;
                                }
                                if (m instanceof GridDhtPartitionDemandMessage) {
                                    grp.preloader().handleDemandMessage(idx, id, (GridDhtPartitionDemandMessage)m);
                                    return;
                                }
                                if (m instanceof GridDhtPartitionDemandLegacyMessage) {
                                    grp.preloader().handleDemandMessage(idx, id, new GridDhtPartitionDemandMessage((GridDhtPartitionDemandLegacyMessage)m));
                                    return;
                                }
                            }
                            U.error(GridCachePartitionExchangeManager.this.log, "Unsupported message type: " + m.getClass().getName());
                        }
                        finally {
                            GridCachePartitionExchangeManager.this.leaveBusy();
                        }
                    }
                });
            }
        }
    }

    public void onCoordinatorInitialized() {
        this.crdInitFut.onDone();
    }

    public void onLocalJoin(DiscoveryEvent evt, DiscoCache cache) {
        this.discoLsnr.onEvent(evt, cache);
    }

    private void onDiscoveryEvent(DiscoveryEvent evt, DiscoCache cache) {
        ClusterNode loc = this.cctx.localNode();
        assert (evt.type() == 10 || evt.type() == 11 || evt.type() == 12 || evt.type() == 18);
        ClusterNode n = evt.eventNode();
        GridDhtPartitionExchangeId exchId = null;
        GridDhtPartitionsExchangeFuture exchFut = null;
        if (evt.type() != 18) {
            LocalJoinCachesContext locJoinCtx;
            assert (evt.type() != 10 || n.isLocal() || n.order() > loc.order()) : "Node joined with smaller-than-local order [newOrder=" + n.order() + ", locOrder=" + loc.order() + ", evt=" + evt + ']';
            exchId = this.exchangeId(n.id(), this.affinityTopologyVersion(evt), evt);
            ExchangeActions exchActs = null;
            if (evt.type() == 10 && evt.eventNode().isLocal() && (locJoinCtx = this.cctx.cache().localJoinCachesContext()) != null) {
                exchActs = new ExchangeActions();
                exchActs.localJoinContext(locJoinCtx);
            }
            exchFut = this.exchangeFuture(exchId, evt, cache, exchActs, null);
        } else {
            DiscoveryCustomMessage customMsg = ((DiscoveryCustomEvent)evt).customMessage();
            if (customMsg instanceof ChangeGlobalStateMessage) {
                ChangeGlobalStateMessage stateChangeMsg = (ChangeGlobalStateMessage)customMsg;
                ExchangeActions exchActions = stateChangeMsg.exchangeActions();
                if (exchActions != null) {
                    exchId = this.exchangeId(n.id(), this.affinityTopologyVersion(evt), evt);
                    exchFut = this.exchangeFuture(exchId, evt, cache, exchActions, null);
                }
            } else if (customMsg instanceof DynamicCacheChangeBatch) {
                DynamicCacheChangeBatch batch = (DynamicCacheChangeBatch)customMsg;
                ExchangeActions exchActions = batch.exchangeActions();
                if (exchActions != null) {
                    exchId = this.exchangeId(n.id(), this.affinityTopologyVersion(evt), evt);
                    exchFut = this.exchangeFuture(exchId, evt, cache, exchActions, null);
                }
            } else if (customMsg instanceof CacheAffinityChangeMessage) {
                CacheAffinityChangeMessage msg = (CacheAffinityChangeMessage)customMsg;
                if (msg.exchangeId() == null) {
                    if (msg.exchangeNeeded()) {
                        exchId = this.exchangeId(n.id(), this.affinityTopologyVersion(evt), evt);
                        exchFut = this.exchangeFuture(exchId, evt, cache, null, msg);
                    }
                } else if (msg.exchangeId().topologyVersion().topologyVersion() >= this.cctx.discovery().localJoinEvent().topologyVersion()) {
                    this.exchangeFuture(msg.exchangeId(), null, null, null, null).onAffinityChangeMessage(evt.eventNode(), msg);
                }
            } else if (customMsg instanceof DynamicCacheChangeFailureMessage) {
                DynamicCacheChangeFailureMessage msg = (DynamicCacheChangeFailureMessage)customMsg;
                if (msg.exchangeId().topologyVersion().topologyVersion() >= this.affinityTopologyVersion(this.cctx.discovery().localJoinEvent()).topologyVersion()) {
                    this.exchangeFuture(msg.exchangeId(), null, null, null, null).onDynamicCacheChangeFail(evt.eventNode(), msg);
                }
            } else if (customMsg instanceof SnapshotDiscoveryMessage && ((SnapshotDiscoveryMessage)customMsg).needExchange()) {
                exchId = this.exchangeId(n.id(), this.affinityTopologyVersion(evt), evt);
                exchFut = this.exchangeFuture(exchId, evt, null, null, null);
            } else if (customMsg instanceof WalStateAbstractMessage && ((WalStateAbstractMessage)customMsg).needExchange()) {
                exchId = this.exchangeId(n.id(), this.affinityTopologyVersion(evt), evt);
                exchFut = this.exchangeFuture(exchId, evt, null, null, null);
            } else {
                CachePartitionExchangeWorkerTask task = this.cctx.cache().exchangeTaskForCustomDiscoveryMessage(customMsg);
                if (task != null) {
                    this.exchWorker.addCustomTask(task);
                }
            }
        }
        if (exchId != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Discovery event (will start exchange): " + exchId);
            }
            exchFut.onEvent(exchId, evt, cache);
            this.addFuture(exchFut);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Do not start exchange for discovery event: " + evt);
        }
        this.notifyNodeFail(evt);
        if (evt.type() == 11 || evt.type() == 12) {
            this.exchWorker.addCustomTask(new SchemaNodeLeaveExchangeWorkerTask(evt.eventNode()));
            this.exchWorker.addCustomTask(new WalStateNodeLeaveExchangeTask(evt.eventNode()));
        }
    }

    void addCustomTask(CachePartitionExchangeWorkerTask task) {
        assert (task != null);
        this.exchWorker.addCustomTask(task);
    }

    public IgniteInternalFuture<?> reconnectExchangeFuture() {
        return this.reconnectExchangeFut;
    }

    private GridDhtPartitionExchangeId initialExchangeId() {
        DiscoveryEvent discoEvt = this.cctx.discovery().localJoinEvent();
        assert (discoEvt != null);
        AffinityTopologyVersion startTopVer = this.affinityTopologyVersion(discoEvt);
        assert (discoEvt.topologyVersion() == startTopVer.topologyVersion());
        return this.exchangeId(this.cctx.localNode().id(), startTopVer, discoEvt);
    }

    public void onKernalStart(boolean active, boolean reconnect) throws IgniteCheckedException {
        for (ClusterNode n : this.cctx.discovery().remoteNodes()) {
            this.cctx.versions().onReceived(n.id(), n.metrics().getLastDataVersion());
        }
        DiscoveryLocalJoinData locJoin = this.cctx.discovery().localJoin();
        GridDhtPartitionsExchangeFuture fut = null;
        if (reconnect) {
            this.reconnectExchangeFut = new GridFutureAdapter();
        }
        if (active) {
            DiscoveryEvent discoEvt = locJoin.event();
            DiscoCache discoCache = locJoin.discoCache();
            GridDhtPartitionExchangeId exchId = this.initialExchangeId();
            fut = this.exchangeFuture(exchId, reconnect ? null : discoEvt, reconnect ? null : discoCache, null, null);
        } else if (reconnect) {
            this.reconnectExchangeFut.onDone();
        }
        new IgniteThread(this.cctx.igniteInstanceName(), "exchange-worker", this.exchWorker).start();
        if (reconnect) {
            if (fut != null) {
                fut.listen(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                    @Override
                    public void apply(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                        try {
                            fut.get();
                            for (CacheGroupContext grp : GridCachePartitionExchangeManager.this.cctx.cache().cacheGroups()) {
                                grp.preloader().onInitialExchangeComplete(null);
                            }
                            GridCachePartitionExchangeManager.this.reconnectExchangeFut.onDone();
                        }
                        catch (IgniteCheckedException e) {
                            for (CacheGroupContext grp : GridCachePartitionExchangeManager.this.cctx.cache().cacheGroups()) {
                                grp.preloader().onInitialExchangeComplete(e);
                            }
                            GridCachePartitionExchangeManager.this.reconnectExchangeFut.onDone(e);
                        }
                    }
                });
            }
        } else if (fut != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Beginning to wait on local exchange future: " + fut);
            }
            boolean first = true;
            while (true) {
                try {
                    fut.get(this.cctx.preloadExchangeTimeout());
                }
                catch (IgniteFutureTimeoutCheckedException ignored) {
                    if (first) {
                        U.warn(this.log, "Failed to wait for initial partition map exchange. Possible reasons are: " + U.nl() + "  ^-- Transactions in deadlock." + U.nl() + "  ^-- Long running transactions (ignore if this is the case)." + U.nl() + "  ^-- Unreleased explicit locks.");
                        first = false;
                        continue;
                    }
                    U.warn(this.log, "Still waiting for initial partition map exchange [fut=" + fut + ']');
                    continue;
                }
                catch (IgniteNeedReconnectException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (fut.reconnectOnError(e)) {
                        throw new IgniteNeedReconnectException(this.cctx.localNode(), (Throwable)e);
                    }
                    throw e;
                }
                break;
            }
            for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                if (!locJoin.joinTopologyVersion().equals(grp.localStartVersion())) continue;
                grp.preloader().onInitialExchangeComplete(null);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Finished waiting for initial exchange: " + fut.exchangeId());
            }
        }
    }

    public static int exchangeProtocolVersion(IgniteProductVersion ver) {
        if (ver.compareToIgnoreTimestamp(EXCHANGE_PROTOCOL_2_SINCE) >= 0) {
            return 2;
        }
        return 1;
    }

    public static Object rebalanceTopic(int idx) {
        return GridTopic.TOPIC_CACHE.topic("Rebalance", (long)idx);
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        ResendTimeoutObject resendTimeoutObj;
        this.exchWorker.onKernalStop();
        this.cctx.gridEvents().removeDiscoveryEventListener(this.discoLsnr, new int[0]);
        this.cctx.io().removeHandler(false, 0, GridDhtPartitionsSingleMessage.class);
        this.cctx.io().removeHandler(false, 0, GridDhtPartitionsFullMessage.class);
        this.cctx.io().removeHandler(false, 0, GridDhtPartitionsSingleRequest.class);
        this.stopErr = this.cctx.kernalContext().clientDisconnected() ? new IgniteClientDisconnectedCheckedException(this.cctx.kernalContext().cluster().clientReconnectFuture(), "Client node disconnected: " + this.cctx.igniteInstanceName()) : new IgniteInterruptedCheckedException("Node is stopping: " + this.cctx.igniteInstanceName());
        U.cancel(this.exchWorker);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Before joining on exchange worker: " + this.exchWorker);
        }
        U.join(this.exchWorker, this.log);
        ExchangeFutureSet exchFuts0 = this.exchFuts;
        for (CachePartitionExchangeWorkerTask cachePartitionExchangeWorkerTask : this.exchWorker.futQ) {
            if (!(cachePartitionExchangeWorkerTask instanceof GridDhtPartitionsExchangeFuture)) continue;
            ((GridDhtPartitionsExchangeFuture)cachePartitionExchangeWorkerTask).onDone(this.stopErr);
        }
        if (exchFuts0 != null) {
            for (GridDhtPartitionsExchangeFuture gridDhtPartitionsExchangeFuture : this.exchFuts.values()) {
                gridDhtPartitionsExchangeFuture.onDone(this.stopErr);
            }
        }
        for (AffinityReadyFuture affinityReadyFuture : this.readyFuts.values()) {
            affinityReadyFuture.onDone(this.stopErr);
        }
        if (!this.cctx.kernalContext().clientNode()) {
            for (int cnt = 0; cnt < this.cctx.gridConfig().getRebalanceThreadPoolSize(); ++cnt) {
                this.cctx.io().removeOrderedHandler(true, GridCachePartitionExchangeManager.rebalanceTopic(cnt));
            }
        }
        if ((resendTimeoutObj = (ResendTimeoutObject)this.pendingResend.getAndSet(null)) != null) {
            this.cctx.time().removeTimeoutObject(resendTimeoutObj);
        }
    }

    @Override
    protected void stop0(boolean cancel) {
        super.stop0(cancel);
        this.busyLock.writeLock().lock();
        this.exchFuts.clear();
    }

    public Object interruptLock() {
        return this.interruptLock;
    }

    @Nullable
    public GridDhtPartitionTopology clientTopologyIfExists(int grpId) {
        return (GridDhtPartitionTopology)this.clientTops.get(grpId);
    }

    public GridDhtPartitionTopology clientTopology(int grpId, DiscoCache discoCache) {
        GridClientPartitionTopology top = (GridClientPartitionTopology)this.clientTops.get(grpId);
        if (top != null) {
            return top;
        }
        CacheGroupDescriptor grpDesc = this.cctx.affinity().cacheGroups().get(grpId);
        assert (grpDesc != null) : grpId;
        CacheConfiguration<?, ?> ccfg = grpDesc.config();
        AffinityFunction aff = ccfg.getAffinity();
        Object affKey = this.cctx.kernalContext().affinity().similaryAffinityKey(aff, ccfg.getNodeFilter(), ccfg.getBackups(), aff.partitions());
        top = new GridClientPartitionTopology(this.cctx, discoCache, grpId, aff.partitions(), affKey);
        GridClientPartitionTopology old = this.clientTops.putIfAbsent(grpId, top);
        return old != null ? old : top;
    }

    public Collection<GridClientPartitionTopology> clientTopologies() {
        return this.clientTops.values();
    }

    public GridClientPartitionTopology clearClientTopology(int grpId) {
        return (GridClientPartitionTopology)this.clientTops.remove(grpId);
    }

    public AffinityTopologyVersion readyAffinityVersion() {
        return this.exchFuts.readyTopVer();
    }

    public AffinityTopologyVersion rebalanceTopologyVersion() {
        return this.rebTopVer;
    }

    public GridDhtPartitionsExchangeFuture lastTopologyFuture() {
        return this.lastInitializedFut;
    }

    @Nullable
    public GridDhtTopologyFuture lastFinishedFuture() {
        return this.lastFinishedFut.get();
    }

    public void lastFinishedFuture(GridDhtTopologyFuture fut) {
        GridDhtTopologyFuture cur;
        assert (fut != null && fut.isDone()) : fut;
        do {
            cur = this.lastFinishedFut.get();
        } while (fut.topologyVersion() != null && (cur == null || fut.topologyVersion().compareTo(cur.topologyVersion()) > 0) && !this.lastFinishedFut.compareAndSet(cur, fut));
    }

    @Nullable
    public IgniteInternalFuture<AffinityTopologyVersion> affinityReadyFuture(AffinityTopologyVersion ver) {
        AffinityTopologyVersion topVer = this.exchFuts.readyTopVer();
        if (topVer.compareTo(ver) >= 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Return finished future for topology ready future [ver=" + ver + ", topVer=" + topVer + ']');
            }
            return new GridFinishedFuture<AffinityTopologyVersion>(topVer);
        }
        GridFutureAdapter fut = F.addIfAbsent(this.readyFuts, ver, new AffinityReadyFuture(ver));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created topology ready future [ver=" + ver + ", fut=" + fut + ']');
        }
        if ((topVer = this.exchFuts.readyTopVer()).compareTo(ver) >= 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Completing created topology ready future [ver=" + topVer + ", topVer=" + topVer + ", fut=" + fut + ']');
            }
            fut.onDone(topVer);
        } else if (this.stopErr != null) {
            fut.onDone(this.stopErr);
        }
        return fut;
    }

    private boolean enterBusy() {
        if (this.busyLock.readLock().tryLock()) {
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Failed to enter to busy state (exchange manager is stopping): " + this.cctx.localNodeId());
        }
        return false;
    }

    private void leaveBusy() {
        this.busyLock.readLock().unlock();
    }

    public List<GridDhtPartitionsExchangeFuture> exchangeFutures() {
        return this.exchFuts.values();
    }

    public boolean hasPendingExchange() {
        return this.exchWorker.hasPendingExchange();
    }

    private AffinityTopologyVersion affinityTopologyVersion(DiscoveryEvent evt) {
        if (evt.type() == 18) {
            return ((DiscoveryCustomEvent)evt).affinityTopologyVersion();
        }
        return new AffinityTopologyVersion(evt.topologyVersion());
    }

    public void forceReassign(GridDhtPartitionExchangeId exchId) {
        this.exchWorker.forceReassign(exchId);
    }

    public IgniteInternalFuture<Boolean> forceRebalance(GridDhtPartitionExchangeId exchId) {
        return this.exchWorker.forceRebalance(exchId);
    }

    public IgniteInternalFuture<Void> deferStopCachesOnClientReconnect(Collection<GridCacheAdapter> caches) {
        assert (this.cctx.discovery().localNode().isClient());
        return this.exchWorker.deferStopCachesOnClientReconnect(caches);
    }

    public void scheduleResendPartitions() {
        ResendTimeoutObject update;
        ResendTimeoutObject timeout = this.pendingResend.get();
        if ((timeout == null || timeout.started()) && this.pendingResend.compareAndSet(timeout, update = new ResendTimeoutObject())) {
            this.cctx.time().addTimeoutObject(update);
        }
    }

    public void refreshPartitions() {
        if (this.cctx.snapshot().snapshotOperationInProgress()) {
            this.scheduleResendPartitions();
            return;
        }
        ClusterNode oldest = this.cctx.discovery().oldestAliveServerNode(AffinityTopologyVersion.NONE);
        if (oldest == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Skip partitions refresh, there are no server nodes [loc=" + this.cctx.localNodeId() + ']');
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Refreshing partitions [oldest=" + oldest.id() + ", loc=" + this.cctx.localNodeId() + ']');
        }
        if (oldest.id().equals(this.cctx.localNodeId())) {
            for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                GridDhtPartitionTopology top;
                if (grp.isLocal() || (top = grp.topology()) == null) continue;
                this.cctx.affinity().checkRebalanceState(top, grp.groupId());
            }
            GridDhtPartitionsExchangeFuture lastFut = this.lastInitializedFut;
            AffinityTopologyVersion rmtTopVer = lastFut != null ? (lastFut.isDone() ? lastFut.topologyVersion() : lastFut.initialVersion()) : AffinityTopologyVersion.NONE;
            Collection<ClusterNode> rmts = this.cctx.discovery().remoteAliveNodesWithCaches(rmtTopVer);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Refreshing partitions from oldest node: " + this.cctx.localNodeId());
            }
            this.sendAllPartitions(rmts, rmtTopVer);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Refreshing local partitions from non-oldest node: " + this.cctx.localNodeId());
            }
            this.sendLocalPartitions(oldest, null);
        }
    }

    private void sendAllPartitions(Collection<ClusterNode> nodes, AffinityTopologyVersion msgTopVer) {
        long latency;
        long time = System.currentTimeMillis();
        GridDhtPartitionsFullMessage m = this.createPartitionsFullMessage(true, false, null, null, null, null);
        m.topologyVersion(msgTopVer);
        if (this.log.isInfoEnabled() && ((latency = System.currentTimeMillis() - time) > 100L || this.log.isDebugEnabled())) {
            this.log.info("Full Message creating for " + msgTopVer + " performed in " + latency + " ms.");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Sending all partitions [nodeIds=" + U.nodeIds(nodes) + ", msg=" + m + ']');
        }
        time = System.currentTimeMillis();
        for (ClusterNode node : nodes) {
            try {
                assert (!node.equals(this.cctx.localNode()));
                this.cctx.io().sendNoRetry(node, m, (byte)2);
            }
            catch (ClusterTopologyCheckedException ignore) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Failed to send partition update to node because it left grid (will ignore) [node=" + node.id() + ", msg=" + m + ']');
            }
            catch (IgniteCheckedException e) {
                U.warn(this.log, "Failed to send partitions full message [node=" + node + ", err=" + e + ']');
            }
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Sending Full Message for " + msgTopVer + " performed in " + (System.currentTimeMillis() - time) + " ms.");
        }
    }

    public GridDhtPartitionsFullMessage createPartitionsFullMessage(boolean compress, boolean newCntrMap, @Nullable GridDhtPartitionExchangeId exchId, @Nullable GridCacheVersion lastVer, @Nullable IgniteDhtPartitionHistorySuppliersMap partHistSuppliers, @Nullable IgniteDhtPartitionsToReloadMap partsToReload) {
        GridDhtPartitionsFullMessage m = new GridDhtPartitionsFullMessage(exchId, lastVer, exchId != null ? exchId.topologyVersion() : AffinityTopologyVersion.NONE, partHistSuppliers, partsToReload);
        m.compress(compress);
        HashMap<Object, T2<Integer, GridDhtPartitionFullMap>> dupData = new HashMap<Object, T2<Integer, GridDhtPartitionFullMap>>();
        for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
            AffinityTopologyVersion startTopVer;
            if (grp.isLocal() || exchId != null && (startTopVer = grp.localStartVersion()).compareTo(exchId.topologyVersion()) > 0) continue;
            GridAffinityAssignmentCache affCache = grp.affinity();
            GridDhtPartitionFullMap locMap = grp.topology().partitionMap(true);
            if (locMap != null) {
                this.addFullPartitionsMap(m, dupData, compress, grp.groupId(), locMap, affCache.similarAffinityKey());
            }
            m.addPartitionSizes(grp.groupId(), grp.topology().globalPartSizes());
            if (exchId == null) continue;
            CachePartitionFullCountersMap cntrsMap = grp.topology().fullUpdateCounters();
            if (newCntrMap) {
                m.addPartitionUpdateCounters(grp.groupId(), cntrsMap);
                continue;
            }
            m.addPartitionUpdateCounters(grp.groupId(), CachePartitionFullCountersMap.toCountersMap(cntrsMap));
        }
        for (GridClientPartitionTopology top : this.cctx.exchange().clientTopologies()) {
            GridDhtPartitionFullMap map = top.partitionMap(true);
            if (map != null) {
                this.addFullPartitionsMap(m, dupData, compress, top.groupId(), map, top.similarAffinityKey());
            }
            if (exchId == null) continue;
            CachePartitionFullCountersMap cntrsMap = top.fullUpdateCounters();
            if (newCntrMap) {
                m.addPartitionUpdateCounters(top.groupId(), cntrsMap);
            } else {
                m.addPartitionUpdateCounters(top.groupId(), CachePartitionFullCountersMap.toCountersMap(cntrsMap));
            }
            m.addPartitionSizes(top.groupId(), top.globalPartSizes());
        }
        return m;
    }

    private void addFullPartitionsMap(GridDhtPartitionsFullMessage m, Map<Object, T2<Integer, GridDhtPartitionFullMap>> dupData, boolean compress, Integer grpId, GridDhtPartitionFullMap map, Object affKey) {
        assert (map != null);
        Integer dupDataCache = null;
        if (compress && affKey != null && !m.containsGroup(grpId)) {
            T2<Integer, GridDhtPartitionFullMap> state0 = dupData.get(affKey);
            if (state0 != null && ((GridDhtPartitionFullMap)state0.get2()).partitionStateEquals(map)) {
                GridDhtPartitionFullMap map0 = new GridDhtPartitionFullMap(map.nodeId(), map.nodeOrder(), map.updateSequence());
                for (Map.Entry e : map.entrySet()) {
                    map0.put(e.getKey(), ((GridDhtPartitionMap)e.getValue()).emptyCopy());
                }
                map = map0;
                dupDataCache = (Integer)state0.get1();
            } else {
                dupData.put(affKey, new T2<Integer, GridDhtPartitionFullMap>(grpId, map));
            }
        }
        m.addFullPartitionsMap(grpId, map, dupDataCache);
    }

    private void sendLocalPartitions(ClusterNode node, @Nullable GridDhtPartitionExchangeId id) {
        GridDhtPartitionsSingleMessage m = this.createPartitionsSingleMessage(id, this.cctx.kernalContext().clientNode(), false, false, null);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Sending local partitions [nodeId=" + node.id() + ", msg=" + m + ']');
        }
        try {
            this.cctx.io().sendNoRetry(node, m, (byte)2);
        }
        catch (ClusterTopologyCheckedException ignore) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send partition update to node because it left grid (will ignore) [node=" + node.id() + ", msg=" + m + ']');
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send local partition map to node [node=" + node + ", exchId=" + id + ']', e);
        }
    }

    public GridDhtPartitionsSingleMessage createPartitionsSingleMessage(@Nullable GridDhtPartitionExchangeId exchangeId, boolean clientOnlyExchange, boolean sndCounters, boolean newCntrMap, ExchangeActions exchActions) {
        CachePartitionPartialCountersMap cntrsMap;
        GridDhtPartitionMap locMap;
        GridDhtPartitionsSingleMessage m = new GridDhtPartitionsSingleMessage(exchangeId, clientOnlyExchange, this.cctx.versions().last(), true);
        HashMap<Object, T2<Integer, GridPartitionStateMap>> dupData = new HashMap<Object, T2<Integer, GridPartitionStateMap>>();
        for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
            if (grp.isLocal() || exchActions != null && exchActions.cacheGroupStopping(grp.groupId())) continue;
            locMap = grp.topology().localPartitionMap();
            this.addPartitionMap(m, dupData, true, grp.groupId(), locMap, grp.affinity().similarAffinityKey());
            if (sndCounters) {
                cntrsMap = grp.topology().localUpdateCounters(true, true);
                m.addPartitionUpdateCounters(grp.groupId(), newCntrMap ? cntrsMap : CachePartitionPartialCountersMap.toCountersMap(cntrsMap));
            }
            m.addPartitionSizes(grp.groupId(), grp.topology().partitionSizes());
        }
        for (GridClientPartitionTopology top : this.clientTops.values()) {
            if (m.partitions() != null && m.partitions().containsKey(top.groupId())) continue;
            locMap = top.localPartitionMap();
            this.addPartitionMap(m, dupData, true, top.groupId(), locMap, top.similarAffinityKey());
            if (sndCounters) {
                cntrsMap = top.localUpdateCounters(true, true);
                m.addPartitionUpdateCounters(top.groupId(), newCntrMap ? cntrsMap : CachePartitionPartialCountersMap.toCountersMap(cntrsMap));
            }
            m.addPartitionSizes(top.groupId(), top.partitionSizes());
        }
        return m;
    }

    private void addPartitionMap(GridDhtPartitionsSingleMessage m, Map<Object, T2<Integer, GridPartitionStateMap>> dupData, boolean compress, Integer cacheId, GridDhtPartitionMap map, Object affKey) {
        Integer dupDataCache = null;
        if (compress) {
            T2<Integer, GridPartitionStateMap> state0 = dupData.get(affKey);
            if (state0 != null && ((GridPartitionStateMap)state0.get2()).equals(map.map())) {
                dupDataCache = (Integer)state0.get1();
                map = map.emptyCopy();
            } else {
                dupData.put(affKey, new T2<Integer, GridPartitionStateMap>(cacheId, map.map()));
            }
        }
        m.addLocalPartitionMap(cacheId, map, dupDataCache);
    }

    private GridDhtPartitionExchangeId exchangeId(UUID nodeId, AffinityTopologyVersion topVer, DiscoveryEvent evt) {
        return new GridDhtPartitionExchangeId(nodeId, evt, topVer);
    }

    private GridDhtPartitionsExchangeFuture exchangeFuture(@NotNull GridDhtPartitionExchangeId exchId) {
        return this.exchangeFuture(exchId, null, null, null, null);
    }

    private GridDhtPartitionsExchangeFuture exchangeFuture(@NotNull GridDhtPartitionExchangeId exchId, @Nullable DiscoveryEvent discoEvt, @Nullable DiscoCache cache, @Nullable ExchangeActions exchActions, @Nullable CacheAffinityChangeMessage affChangeMsg) {
        GridDhtPartitionsExchangeFuture fut = new GridDhtPartitionsExchangeFuture(this.cctx, this.busyLock, exchId, exchActions, affChangeMsg);
        GridDhtPartitionsExchangeFuture old = this.exchFuts.addx(fut);
        if (old != null) {
            fut = old;
            if (exchActions != null) {
                fut.exchangeActions(exchActions);
            }
            if (affChangeMsg != null) {
                fut.affinityChangeMessage(affChangeMsg);
            }
        }
        if (discoEvt != null) {
            fut.onEvent(exchId, discoEvt, cache);
        }
        if (this.stopErr != null) {
            fut.onDone(this.stopErr);
        }
        return fut;
    }

    public void onExchangeDone(AffinityTopologyVersion topVer, AffinityTopologyVersion initTopVer, @Nullable Throwable err) {
        ExchangeFutureSet exchFuts0;
        assert (topVer != null || err != null);
        assert (initTopVer != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Exchange done [topVer=" + topVer + ", err=" + err + ']');
        }
        if (err == null) {
            this.exchFuts.readyTopVer(topVer);
            for (Map.Entry entry : this.readyFuts.entrySet()) {
                if (((AffinityTopologyVersion)entry.getKey()).compareTo(topVer) > 0) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Completing created topology ready future [ver=" + topVer + ", fut=" + entry.getValue() + ']');
                }
                ((AffinityReadyFuture)entry.getValue()).onDone(topVer);
            }
        } else {
            for (Map.Entry entry : this.readyFuts.entrySet()) {
                if (((AffinityTopologyVersion)entry.getKey()).compareTo(initTopVer) > 0) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Completing created topology ready future with error [ver=" + entry.getKey() + ", fut=" + entry.getValue() + ']');
                }
                ((AffinityReadyFuture)entry.getValue()).onDone(err);
            }
        }
        if ((exchFuts0 = this.exchFuts) != null) {
            int skipped = 0;
            for (GridDhtPartitionsExchangeFuture fut : exchFuts0.values()) {
                if (initTopVer.compareTo(fut.exchangeId().topologyVersion()) < 0 || ++skipped <= 10) continue;
                fut.cleanUp();
            }
        }
    }

    private boolean addFuture(GridDhtPartitionsExchangeFuture fut) {
        if (fut.onAdded()) {
            this.exchWorker.addExchangeFuture(fut);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFullPartitionUpdate(ClusterNode node, GridDhtPartitionsFullMessage msg) {
        if (!this.enterBusy()) {
            return;
        }
        try {
            if (msg.exchangeId() == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received full partition update [node=" + node.id() + ", msg=" + msg + ']');
                }
                boolean updated = false;
                for (Map.Entry<Integer, GridDhtPartitionFullMap> entry : msg.partitions().entrySet()) {
                    Integer grpId = entry.getKey();
                    CacheGroupContext grp = this.cctx.cache().cacheGroup(grpId);
                    GridDhtPartitionTopology top = null;
                    if (grp == null) {
                        top = (GridDhtPartitionTopology)this.clientTops.get(grpId);
                    } else if (!grp.isLocal()) {
                        top = grp.topology();
                    }
                    if (top == null) continue;
                    updated |= top.update(null, entry.getValue(), null, msg.partsToReload(this.cctx.localNodeId(), grpId), msg.partitionSizes(grpId), msg.topologyVersion());
                }
                if (!this.cctx.kernalContext().clientNode() && updated) {
                    this.refreshPartitions();
                }
                boolean hasMovingParts = false;
                for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                    if (grp.isLocal() || !grp.topology().hasMovingPartitions()) continue;
                    hasMovingParts = true;
                    break;
                }
                if (!hasMovingParts) {
                    this.cctx.database().releaseHistoryForPreloading();
                }
            } else {
                this.exchangeFuture(msg.exchangeId(), null, null, null, null).onReceiveFullMessage(node, msg);
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSinglePartitionUpdate(ClusterNode node, GridDhtPartitionsSingleMessage msg) {
        if (!this.enterBusy()) {
            return;
        }
        try {
            if (msg.exchangeId() == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Received local partition update [nodeId=" + node.id() + ", parts=" + msg + ']');
                }
                boolean updated = false;
                for (Map.Entry<Integer, GridDhtPartitionMap> entry : msg.partitions().entrySet()) {
                    Integer grpId = entry.getKey();
                    CacheGroupContext grp = this.cctx.cache().cacheGroup(grpId);
                    if (grp != null && grp.localStartVersion().compareTo(entry.getValue().topologyVersion()) > 0) continue;
                    GridDhtPartitionTopology top = null;
                    if (grp == null) {
                        top = (GridDhtPartitionTopology)this.clientTops.get(grpId);
                    } else if (!grp.isLocal()) {
                        top = grp.topology();
                    }
                    if (top == null) continue;
                    updated |= top.update(null, entry.getValue(), false);
                    this.cctx.affinity().checkRebalanceState(top, grpId);
                }
                if (updated) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Partitions have been scheduled to resend [reason=Single update from " + node.id() + "]");
                    }
                    this.scheduleResendPartitions();
                }
            } else {
                AffinityTopologyVersion readyVer;
                AffinityTopologyVersion initVer;
                GridDhtPartitionsExchangeFuture exchFut = this.exchangeFuture(msg.exchangeId());
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Notifying exchange future about single message: " + exchFut);
                }
                if (msg.client() && (initVer = exchFut.initialVersion()).compareTo(readyVer = this.readyAffinityVersion()) < 0 && !exchFut.isDone()) {
                    U.warn(this.log, "Client node tries to connect but its exchange info is cleaned up from exchange history. Consider increasing 'IGNITE_EXCHANGE_HISTORY_SIZE' property or start clients in  smaller batches. Current settings and versions: [IGNITE_EXCHANGE_HISTORY_SIZE=" + this.EXCHANGE_HISTORY_SIZE + ", initVer=" + initVer + ", readyVer=" + readyVer + "].");
                    exchFut.forceClientReconnect(node, msg);
                    return;
                }
                exchFut.onReceiveSingleMessage(node, msg);
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSinglePartitionRequest(ClusterNode node, GridDhtPartitionsSingleRequest msg) {
        if (!this.enterBusy()) {
            return;
        }
        try {
            GridDhtPartitionsExchangeFuture exchFut = this.exchangeFuture(msg.exchangeId(), null, null, null, null);
            exchFut.onReceivePartitionRequest(node, msg);
        }
        finally {
            this.leaveBusy();
        }
    }

    public ExchangeLatchManager latch() {
        return this.latchMgr;
    }

    public void dumpDebugInfo(@Nullable GridDhtPartitionsExchangeFuture exchFut) throws Exception {
        ExchangeFutureSet exchFuts;
        IgniteDiagnosticPrepareContext diagCtx;
        AffinityTopologyVersion exchTopVer = exchFut != null ? exchFut.initialVersion() : null;
        U.warn(this.diagnosticLog, "Ready affinity version: " + this.exchFuts.readyTopVer());
        U.warn(this.diagnosticLog, "Last exchange future: " + this.lastInitializedFut);
        this.exchWorker.dumpExchangeDebugInfo();
        if (!this.readyFuts.isEmpty()) {
            U.warn(this.diagnosticLog, "First 5 pending affinity ready futures [total=" + this.readyFuts.size() + ']');
            int cnt = 0;
            for (AffinityReadyFuture fut : this.readyFuts.values()) {
                U.warn(this.diagnosticLog, ">>> " + fut);
                if (++cnt != 5) continue;
                break;
            }
        }
        IgniteDiagnosticPrepareContext igniteDiagnosticPrepareContext = diagCtx = this.cctx.kernalContext().cluster().diagnosticEnabled() ? new IgniteDiagnosticPrepareContext(this.cctx.localNodeId()) : null;
        if (diagCtx != null && exchFut != null) {
            exchFut.addDiagnosticRequest(diagCtx);
        }
        if ((exchFuts = this.exchFuts) != null) {
            U.warn(this.diagnosticLog, "Last 10 exchange futures (total: " + exchFuts.size() + "):");
            int cnt = 0;
            for (GridDhtPartitionsExchangeFuture fut : exchFuts.values()) {
                U.warn(this.diagnosticLog, ">>> " + fut.shortInfo());
                if (++cnt != 10) continue;
                break;
            }
        }
        U.warn(this.diagnosticLog, "Latch manager state: " + this.latchMgr);
        this.dumpPendingObjects(exchTopVer, diagCtx);
        for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
            grp.preloader().dumpDebugInfo();
        }
        this.cctx.affinity().dumpDebugInfo();
        StringBuilder pendingMsgs = new StringBuilder();
        this.cctx.io().dumpPendingMessages(pendingMsgs);
        if (pendingMsgs.length() > 0 && this.diagnosticLog.isInfoEnabled()) {
            this.diagnosticLog.info(pendingMsgs.toString());
        }
        if (IgniteSystemProperties.getBoolean("IGNITE_IO_DUMP_ON_TIMEOUT", false)) {
            this.cctx.gridIO().dumpStats();
        }
        if (IgniteSystemProperties.getBoolean("IGNITE_THREAD_DUMP_ON_EXCHANGE_TIMEOUT", false)) {
            U.dumpThreads(this.diagnosticLog);
        }
        if (diagCtx != null) {
            diagCtx.send(this.cctx.kernalContext(), null);
        }
    }

    private boolean dumpLongRunningOperations0(long timeout) {
        IgniteDiagnosticPrepareContext diagCtx;
        long curTime = U.currentTimeMillis();
        boolean found = false;
        IgniteTxManager tm = this.cctx.tm();
        GridCacheMvccManager mvcc = this.cctx.mvcc();
        IgniteDiagnosticPrepareContext igniteDiagnosticPrepareContext = diagCtx = this.cctx.kernalContext().cluster().diagnosticEnabled() ? new IgniteDiagnosticPrepareContext(this.cctx.localNodeId()) : null;
        if (tm != null) {
            for (IgniteInternalTx igniteInternalTx : tm.activeTransactions()) {
                if (curTime - igniteInternalTx.startTime() <= timeout) continue;
                found = true;
                U.warn(this.diagnosticLog, "Found long running transaction [startTime=" + this.formatTime(igniteInternalTx.startTime()) + ", curTime=" + this.formatTime(curTime) + ", tx=" + igniteInternalTx + ']');
            }
        }
        if (mvcc != null) {
            for (GridCacheFuture gridCacheFuture : mvcc.activeFutures()) {
                if (curTime - gridCacheFuture.startTime() <= timeout) continue;
                found = true;
                U.warn(this.diagnosticLog, "Found long running cache future [startTime=" + this.formatTime(gridCacheFuture.startTime()) + ", curTime=" + this.formatTime(curTime) + ", fut=" + gridCacheFuture + ']');
                if (diagCtx == null || !(gridCacheFuture instanceof IgniteDiagnosticAware)) continue;
                ((IgniteDiagnosticAware)((Object)gridCacheFuture)).addDiagnosticRequest(diagCtx);
            }
            for (GridCacheFuture gridCacheFuture : mvcc.atomicFutures()) {
                if (curTime - gridCacheFuture.startTime() <= timeout) continue;
                found = true;
                U.warn(this.diagnosticLog, "Found long running cache future [startTime=" + this.formatTime(gridCacheFuture.startTime()) + ", curTime=" + this.formatTime(curTime) + ", fut=" + gridCacheFuture + ']');
                if (diagCtx == null || !(gridCacheFuture instanceof IgniteDiagnosticAware)) continue;
                ((IgniteDiagnosticAware)((Object)gridCacheFuture)).addDiagnosticRequest(diagCtx);
            }
        }
        if (diagCtx != null && !diagCtx.empty()) {
            try {
                this.cctx.kernalContext().closure().runLocal(new Runnable(){

                    @Override
                    public void run() {
                        diagCtx.send(GridCachePartitionExchangeManager.this.cctx.kernalContext(), null);
                    }
                }, (byte)2);
            }
            catch (IgniteCheckedException e) {
                U.error(this.diagnosticLog, "Failed to submit diagnostic closure: " + e, e);
            }
        }
        return found;
    }

    public void dumpLongRunningOperations(long timeout) {
        try {
            GridDhtPartitionsExchangeFuture lastFut = this.lastInitializedFut;
            if (lastFut != null && !lastFut.isDone()) {
                return;
            }
            if (U.currentTimeMillis() < this.nextLongRunningOpsDumpTime) {
                return;
            }
            if (this.dumpLongRunningOperations0(timeout)) {
                this.nextLongRunningOpsDumpTime = U.currentTimeMillis() + GridDhtPartitionsExchangeFuture.nextDumpTimeout(this.longRunningOpsDumpStep++, timeout);
                if (IgniteSystemProperties.getBoolean("IGNITE_THREAD_DUMP_ON_EXCHANGE_TIMEOUT", false)) {
                    U.warn(this.diagnosticLog, "Found long running cache operations, dump threads.");
                    U.dumpThreads(this.diagnosticLog);
                }
                if (IgniteSystemProperties.getBoolean("IGNITE_IO_DUMP_ON_TIMEOUT", false)) {
                    U.warn(this.diagnosticLog, "Found long running cache operations, dump IO statistics.");
                    if (IgniteSystemProperties.getBoolean("IGNITE_IO_DUMP_ON_TIMEOUT", false)) {
                        this.cctx.gridIO().dumpStats();
                    }
                }
            } else {
                this.nextLongRunningOpsDumpTime = 0L;
                this.longRunningOpsDumpStep = 0;
            }
        }
        catch (Exception e) {
            U.error(this.diagnosticLog, "Failed to dump debug information: " + e, e);
        }
    }

    private String formatTime(long time) {
        return this.dateFormat.format(new Date(time));
    }

    private static boolean isExchangeTask(CachePartitionExchangeWorkerTask task) {
        return task instanceof GridDhtPartitionsExchangeFuture || task instanceof RebalanceReassignExchangeTask || task instanceof ForceRebalanceExchangeTask;
    }

    private void dumpPendingObjects(@Nullable AffinityTopologyVersion exchTopVer, @Nullable IgniteDiagnosticPrepareContext diagCtx) {
        GridCacheMvccManager mvcc;
        IgniteTxManager tm = this.cctx.tm();
        if (tm != null) {
            boolean first = true;
            for (IgniteInternalTx tx : tm.activeTransactions()) {
                if (first) {
                    U.warn(this.diagnosticLog, "Pending transactions:");
                    first = false;
                }
                if (exchTopVer != null) {
                    U.warn(this.diagnosticLog, ">>> [txVer=" + tx.topologyVersionSnapshot() + ", exchWait=" + tm.needWaitTransaction(tx, exchTopVer) + ", tx=" + tx + ']');
                    continue;
                }
                U.warn(this.diagnosticLog, ">>> [txVer=" + tx.topologyVersionSnapshot() + ", tx=" + tx + ']');
            }
        }
        if ((mvcc = this.cctx.mvcc()) != null) {
            boolean first = true;
            for (GridCacheExplicitLockSpan gridCacheExplicitLockSpan : mvcc.activeExplicitLocks()) {
                if (first) {
                    U.warn(this.diagnosticLog, "Pending explicit locks:");
                    first = false;
                }
                U.warn(this.diagnosticLog, ">>> " + gridCacheExplicitLockSpan);
            }
            first = true;
            for (GridCacheFuture gridCacheFuture : mvcc.activeFutures()) {
                if (first) {
                    U.warn(this.diagnosticLog, "Pending cache futures:");
                    first = false;
                }
                this.dumpDiagnosticInfo(gridCacheFuture, diagCtx);
            }
            first = true;
            for (GridCacheFuture gridCacheFuture : mvcc.atomicFutures()) {
                if (first) {
                    U.warn(this.diagnosticLog, "Pending atomic cache futures:");
                    first = false;
                }
                this.dumpDiagnosticInfo(gridCacheFuture, diagCtx);
            }
            first = true;
            for (IgniteInternalFuture igniteInternalFuture : mvcc.dataStreamerFutures()) {
                if (first) {
                    U.warn(this.diagnosticLog, "Pending data streamer futures:");
                    first = false;
                }
                this.dumpDiagnosticInfo(igniteInternalFuture, diagCtx);
            }
            if (tm != null) {
                first = true;
                for (IgniteInternalFuture igniteInternalFuture : tm.deadlockDetectionFutures()) {
                    if (first) {
                        U.warn(this.diagnosticLog, "Pending transaction deadlock detection futures:");
                        first = false;
                    }
                    this.dumpDiagnosticInfo(igniteInternalFuture, diagCtx);
                }
            }
        }
        int affDumpCnt = 0;
        for (CacheGroupContext cacheGroupContext : this.cctx.cache().cacheGroups()) {
            GridAffinityAssignmentCache aff;
            if (cacheGroupContext.isLocal()) continue;
            GridCachePreloader preloader = cacheGroupContext.preloader();
            if (preloader != null) {
                preloader.dumpDebugInfo();
            }
            if ((aff = cacheGroupContext.affinity()) == null || affDumpCnt >= 5 || !aff.dumpDebugInfo()) continue;
            ++affDumpCnt;
        }
        this.cctx.kernalContext().coordinators().dumpDebugInfo(this.diagnosticLog, diagCtx);
    }

    private void dumpDiagnosticInfo(IgniteInternalFuture<?> fut, @Nullable IgniteDiagnosticPrepareContext ctx) {
        U.warn(this.diagnosticLog, ">>> " + fut);
        if (ctx != null && fut instanceof IgniteDiagnosticAware) {
            ((IgniteDiagnosticAware)((Object)fut)).addDiagnosticRequest(ctx);
        }
    }

    public void mergeExchangesTestWaitVersion(AffinityTopologyVersion exchMergeTestWaitVer, @Nullable List mergedEvtsForTest) {
        this.exchMergeTestWaitVer = exchMergeTestWaitVer;
        this.mergedEvtsForTest = mergedEvtsForTest;
    }

    public boolean mergeExchanges(GridDhtPartitionsExchangeFuture curFut, GridDhtPartitionsFullMessage msg) throws IgniteInterruptedCheckedException {
        AffinityTopologyVersion resVer = msg.resultTopologyVersion();
        if (this.exchWorker.waitForExchangeFuture(resVer)) {
            return true;
        }
        for (CachePartitionExchangeWorkerTask task : this.exchWorker.futQ) {
            GridDhtPartitionsSingleMessage pendingMsg;
            if (!(task instanceof GridDhtPartitionsExchangeFuture)) continue;
            GridDhtPartitionsExchangeFuture fut = (GridDhtPartitionsExchangeFuture)task;
            if (fut.initialVersion().compareTo(resVer) > 0) {
                if (!this.log.isInfoEnabled()) break;
                this.log.info("Merge exchange future on finish stop [curFut=" + curFut.initialVersion() + ", resVer=" + resVer + ", nextFutVer=" + fut.initialVersion() + ']');
                break;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Merge exchange future on finish [curFut=" + curFut.initialVersion() + ", mergedFut=" + fut.initialVersion() + ", evt=" + IgniteUtils.gridEventName(fut.firstEvent().type()) + ", evtNode=" + fut.firstEvent().eventNode().id() + ", evtNodeClient=" + fut.firstEvent().eventNode().isClient() + ']');
            }
            DiscoveryEvent evt = fut.firstEvent();
            curFut.context().events().addEvent(fut.initialVersion(), fut.firstEvent(), fut.firstEventCache());
            if (evt.type() != 10 || (pendingMsg = fut.mergeJoinExchangeOnDone(curFut)) == null) continue;
            if (this.log.isInfoEnabled()) {
                this.log.info("Merged join exchange future on finish, will reply to node [curFut=" + curFut.initialVersion() + ", mergedFut=" + fut.initialVersion() + ", evtNode=" + evt.eventNode().id() + ']');
            }
            curFut.waitAndReplyToNode(evt.eventNode().id(), pendingMsg);
        }
        ExchangeDiscoveryEvents evts = curFut.context().events();
        assert (evts.topologyVersion().equals(resVer)) : "Invalid exchange merge result [ver=" + evts.topologyVersion() + ", expVer=" + resVer + ']';
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mergeExchangesOnCoordinator(GridDhtPartitionsExchangeFuture curFut) {
        AffinityTopologyVersion exchMergeTestWaitVer;
        if (this.IGNITE_EXCHANGE_MERGE_DELAY > 0L) {
            try {
                U.sleep(this.IGNITE_EXCHANGE_MERGE_DELAY);
            }
            catch (IgniteInterruptedCheckedException e) {
                U.warn(this.log, "Failed to wait for exchange merge, thread interrupted: " + e);
                return true;
            }
        }
        if ((exchMergeTestWaitVer = this.exchMergeTestWaitVer) != null) {
            this.waitForTestVersion(exchMergeTestWaitVer, curFut);
        }
        Object object = curFut.mutex();
        synchronized (object) {
            int awaited = 0;
            for (CachePartitionExchangeWorkerTask task : this.exchWorker.futQ) {
                if (task instanceof GridDhtPartitionsExchangeFuture) {
                    GridDhtPartitionsExchangeFuture fut = (GridDhtPartitionsExchangeFuture)task;
                    DiscoveryEvent evt = fut.firstEvent();
                    if (evt.type() == 18) {
                        if (!this.log.isInfoEnabled()) break;
                        this.log.info("Stop merge, custom event found: " + evt);
                        break;
                    }
                    ClusterNode node = evt.eventNode();
                    if ((evt.type() == 12 || evt.type() == 11) && node.equals(this.cctx.coordinators().currentCoordinator())) {
                        if (!this.log.isInfoEnabled()) break;
                        this.log.info("Stop merge, need exchange for mvcc coordinator failure: " + node);
                        break;
                    }
                    if (!curFut.context().supportsMergeExchanges(node)) {
                        if (!this.log.isInfoEnabled()) break;
                        this.log.info("Stop merge, node does not support merge: " + node);
                        break;
                    }
                    if (evt.type() == 10 && this.cctx.cache().hasCachesReceivedFromJoin(node)) {
                        if (!this.log.isInfoEnabled()) break;
                        this.log.info("Stop merge, received caches from node: " + node);
                        break;
                    }
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Merge exchange future [curFut=" + curFut.initialVersion() + ", mergedFut=" + fut.initialVersion() + ", evt=" + IgniteUtils.gridEventName(fut.firstEvent().type()) + ", evtNode=" + fut.firstEvent().eventNode().id() + ", evtNodeClient=" + fut.firstEvent().eventNode().isClient() + ']');
                    }
                    this.addDiscoEvtForTest(fut.firstEvent());
                    curFut.context().events().addEvent(fut.initialVersion(), fut.firstEvent(), fut.firstEventCache());
                    if (evt.type() != 10 || !fut.mergeJoinExchange(curFut)) continue;
                    ++awaited;
                    continue;
                }
                if (task.skipForExchangeMerge()) continue;
                if (!this.log.isInfoEnabled()) break;
                this.log.info("Stop merge, custom task found: " + task);
                break;
            }
            return awaited == 0;
        }
    }

    private void addDiscoEvtForTest(DiscoveryEvent discoEvt) {
        List mergedEvtsForTest = this.mergedEvtsForTest;
        if (mergedEvtsForTest != null) {
            mergedEvtsForTest.add(discoEvt);
        }
    }

    private void waitForTestVersion(AffinityTopologyVersion exchMergeTestWaitVer, GridDhtPartitionsExchangeFuture curFut) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Exchange merge test, waiting for version [exch=" + curFut.initialVersion() + ", waitVer=" + exchMergeTestWaitVer + ']');
        }
        long end = U.currentTimeMillis() + 10000L;
        while (U.currentTimeMillis() < end) {
            boolean found = false;
            for (CachePartitionExchangeWorkerTask task : this.exchWorker.futQ) {
                GridDhtPartitionsExchangeFuture fut;
                if (!(task instanceof GridDhtPartitionsExchangeFuture) || !exchMergeTestWaitVer.equals((fut = (GridDhtPartitionsExchangeFuture)task).initialVersion())) continue;
                if (this.log.isInfoEnabled()) {
                    this.log.info("Exchange merge test, found awaited version: " + exchMergeTestWaitVer);
                }
                found = true;
                break;
            }
            if (found) break;
            try {
                U.sleep(100L);
            }
            catch (IgniteInterruptedCheckedException e) {
                break;
            }
        }
        this.exchMergeTestWaitVer = null;
    }

    public void exchangerUpdateHeartbeat() {
        this.exchWorker.updateHeartbeat();
    }

    public void exchangerBlockingSectionBegin() {
        if (this.currentThreadIsExchanger()) {
            this.exchWorker.blockingSectionBegin();
        }
    }

    public void exchangerBlockingSectionEnd() {
        if (this.currentThreadIsExchanger()) {
            this.exchWorker.blockingSectionEnd();
        }
    }

    private boolean currentThreadIsExchanger() {
        return this.exchWorker != null && Thread.currentThread() == this.exchWorker.runner();
    }

    private boolean exchangeInProgress() {
        if (this.exchWorker.hasPendingServerExchange()) {
            return true;
        }
        GridDhtPartitionsExchangeFuture current = this.lastTopologyFuture();
        if (current == null) {
            return false;
        }
        GridDhtTopologyFuture finished = this.lastFinishedFut.get();
        if (finished == null || ((AffinityTopologyVersion)finished.result()).compareTo(current.initialVersion()) < 0) {
            ClusterNode triggeredBy = current.firstEvent().eventNode();
            if (current.partitionChangesInProgress() && !triggeredBy.isClient()) {
                return true;
            }
        }
        return false;
    }

    private class AffinityReadyFuture
    extends GridFutureAdapter<AffinityTopologyVersion> {
        @GridToStringInclude
        private AffinityTopologyVersion topVer;

        private AffinityReadyFuture(AffinityTopologyVersion topVer) {
            this.topVer = topVer;
        }

        @Override
        public boolean onDone(AffinityTopologyVersion res, @Nullable Throwable err) {
            assert (res != null || err != null);
            boolean done = super.onDone(res, err);
            if (done) {
                GridCachePartitionExchangeManager.this.readyFuts.remove(this.topVer, this);
            }
            return done;
        }

        @Override
        public String toString() {
            return S.toString(AffinityReadyFuture.class, this, super.toString());
        }
    }

    private abstract class MessageHandler<M>
    implements IgniteBiInClosure<UUID, M> {
        private static final long serialVersionUID = 0L;

        private MessageHandler() {
        }

        @Override
        public void apply(UUID nodeId, M msg) {
            ClusterNode node = GridCachePartitionExchangeManager.this.cctx.node(nodeId);
            if (node == null) {
                if (GridCachePartitionExchangeManager.this.log.isTraceEnabled()) {
                    GridCachePartitionExchangeManager.this.log.trace("Received message from failed node [node=" + nodeId + ", msg=" + msg + ']');
                }
                return;
            }
            if (GridCachePartitionExchangeManager.this.log.isTraceEnabled()) {
                GridCachePartitionExchangeManager.this.log.trace("Received message from node [node=" + nodeId + ", msg=" + msg + ']');
            }
            this.onMessage(node, msg);
        }

        protected abstract void onMessage(ClusterNode var1, M var2);
    }

    private static class ExchangeFutureSet
    extends GridListSet<GridDhtPartitionsExchangeFuture> {
        private static final long serialVersionUID = 0L;
        private final int histSize;
        private final AtomicReference<AffinityTopologyVersion> readyTopVer = new AtomicReference<AffinityTopologyVersion>(AffinityTopologyVersion.NONE);

        private ExchangeFutureSet(int histSize) {
            super(new Comparator<GridDhtPartitionsExchangeFuture>(){

                @Override
                public int compare(GridDhtPartitionsExchangeFuture f1, GridDhtPartitionsExchangeFuture f2) {
                    AffinityTopologyVersion t1 = f1.exchangeId().topologyVersion();
                    AffinityTopologyVersion t2 = f2.exchangeId().topologyVersion();
                    assert (t1.topologyVersion() > 0L);
                    assert (t2.topologyVersion() > 0L);
                    return t2.compareTo(t1);
                }
            }, false);
            this.histSize = histSize;
        }

        @Override
        public synchronized GridDhtPartitionsExchangeFuture addx(GridDhtPartitionsExchangeFuture fut) {
            GridDhtPartitionsExchangeFuture last;
            GridDhtPartitionsExchangeFuture cur = super.addx(fut);
            while (this.size() > this.histSize && (last = (GridDhtPartitionsExchangeFuture)this.last()).isDone() && !Objects.equals(last.initialVersion(), this.readyTopVer())) {
                this.removeLast();
            }
            return cur == null ? fut : cur;
        }

        public AffinityTopologyVersion readyTopVer() {
            return this.readyTopVer.get();
        }

        public boolean readyTopVer(AffinityTopologyVersion readyTopVersion) {
            AffinityTopologyVersion readyVer;
            do {
                if ((readyVer = this.readyTopVer.get()).compareTo(readyTopVersion) < 0) continue;
                return false;
            } while (!this.readyTopVer.compareAndSet(readyVer, readyTopVersion));
            return true;
        }

        @Override
        @Nullable
        public synchronized GridDhtPartitionsExchangeFuture removex(GridDhtPartitionsExchangeFuture val) {
            return super.removex(val);
        }

        @Override
        public synchronized List<GridDhtPartitionsExchangeFuture> values() {
            return super.values();
        }

        @Override
        public synchronized String toString() {
            return S.toString(ExchangeFutureSet.class, this, super.toString());
        }
    }

    private class ResendTimeoutObject
    implements GridTimeoutObject {
        private final IgniteUuid timeoutId = IgniteUuid.randomUuid();
        private final long createTime = U.currentTimeMillis();
        private AtomicBoolean started = new AtomicBoolean();

        private ResendTimeoutObject() {
        }

        @Override
        public IgniteUuid timeoutId() {
            return this.timeoutId;
        }

        @Override
        public long endTime() {
            return this.createTime + GridCachePartitionExchangeManager.this.partResendTimeout;
        }

        @Override
        public void onTimeout() {
            GridCachePartitionExchangeManager.this.cctx.kernalContext().closure().runLocalSafe(new Runnable(){

                @Override
                public void run() {
                    if (!GridCachePartitionExchangeManager.this.busyLock.readLock().tryLock()) {
                        return;
                    }
                    try {
                        if (ResendTimeoutObject.this.started.compareAndSet(false, true)) {
                            GridCachePartitionExchangeManager.this.refreshPartitions();
                        }
                    }
                    finally {
                        GridCachePartitionExchangeManager.this.busyLock.readLock().unlock();
                        GridCachePartitionExchangeManager.this.cctx.time().removeTimeoutObject(ResendTimeoutObject.this);
                        GridCachePartitionExchangeManager.this.pendingResend.compareAndSet(ResendTimeoutObject.this, null);
                    }
                }
            });
        }

        public boolean started() {
            return this.started.get();
        }
    }

    private class ExchangeWorker
    extends GridWorker {
        private final LinkedBlockingDeque<CachePartitionExchangeWorkerTask> futQ;
        private AffinityTopologyVersion lastFutVer;
        private volatile boolean busy;
        private boolean crd;
        private boolean stop;
        private boolean reconnectNeeded;

        private ExchangeWorker() {
            super(GridCachePartitionExchangeManager.this.cctx.igniteInstanceName(), "partition-exchanger", GridCachePartitionExchangeManager.this.log, GridCachePartitionExchangeManager.this.cctx.kernalContext().workersRegistry());
            this.futQ = new LinkedBlockingDeque();
        }

        void forceReassign(GridDhtPartitionExchangeId exchId) {
            if (!this.hasPendingExchange() && !this.busy) {
                this.futQ.add(new RebalanceReassignExchangeTask(exchId));
            }
        }

        IgniteInternalFuture<Boolean> forceRebalance(GridDhtPartitionExchangeId exchId) {
            GridCompoundFuture<Boolean, Boolean> fut = new GridCompoundFuture<Boolean, Boolean>(CU.boolReducer());
            this.futQ.add(new ForceRebalanceExchangeTask(exchId, fut));
            return fut;
        }

        IgniteInternalFuture<Void> deferStopCachesOnClientReconnect(Collection<GridCacheAdapter> caches) {
            StopCachesOnClientReconnectExchangeTask task = new StopCachesOnClientReconnectExchangeTask(caches);
            this.futQ.add(task);
            return task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addExchangeFuture(GridDhtPartitionsExchangeFuture exchFut) {
            assert (exchFut != null);
            this.futQ.offer(exchFut);
            ExchangeWorker exchangeWorker = this;
            synchronized (exchangeWorker) {
                this.lastFutVer = exchFut.initialVersion();
                this.notifyAll();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Added exchange future to exchange worker: " + exchFut);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onKernalStop() {
            ExchangeWorker exchangeWorker = this;
            synchronized (exchangeWorker) {
                this.stop = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForExchangeFuture(AffinityTopologyVersion resVer) throws IgniteInterruptedCheckedException {
            ExchangeWorker exchangeWorker = this;
            synchronized (exchangeWorker) {
                while (!this.stop && this.lastFutVer.compareTo(resVer) < 0) {
                    U.wait(this);
                }
                return this.stop;
            }
        }

        private void removeMergedFutures(AffinityTopologyVersion resVer, GridDhtPartitionsExchangeFuture exchFut) throws IgniteInterruptedCheckedException {
            if (resVer.compareTo(exchFut.initialVersion()) != 0) {
                this.waitForExchangeFuture(resVer);
                for (CachePartitionExchangeWorkerTask task : this.futQ) {
                    if (!(task instanceof GridDhtPartitionsExchangeFuture)) continue;
                    GridDhtPartitionsExchangeFuture fut0 = (GridDhtPartitionsExchangeFuture)task;
                    if (resVer.compareTo(fut0.initialVersion()) < 0) break;
                    fut0.finishMerged();
                    this.futQ.remove(fut0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            Object object = GridCachePartitionExchangeManager.this.interruptLock;
            synchronized (object) {
                super.cancel();
            }
        }

        void addCustomTask(CachePartitionExchangeWorkerTask task) {
            assert (task != null);
            assert (!GridCachePartitionExchangeManager.isExchangeTask(task));
            this.futQ.offer(task);
        }

        void processCustomTask(CachePartitionExchangeWorkerTask task) {
            assert (!GridCachePartitionExchangeManager.isExchangeTask(task));
            try {
                GridCachePartitionExchangeManager.this.cctx.cache().processCustomExchangeTask(task);
            }
            catch (Exception e) {
                U.error(this.log, "Failed to process custom exchange task: " + task, e);
            }
        }

        boolean hasPendingExchange() {
            if (!this.futQ.isEmpty()) {
                for (CachePartitionExchangeWorkerTask task : this.futQ) {
                    if (!GridCachePartitionExchangeManager.isExchangeTask(task)) continue;
                    return true;
                }
            }
            return false;
        }

        boolean hasPendingServerExchange() {
            if (!this.futQ.isEmpty()) {
                for (CachePartitionExchangeWorkerTask task : this.futQ) {
                    ClusterNode triggeredBy;
                    if (!(task instanceof GridDhtPartitionsExchangeFuture) || (triggeredBy = ((GridDhtPartitionsExchangeFuture)task).firstEvent().eventNode()).isClient()) continue;
                    return true;
                }
            }
            return false;
        }

        void dumpExchangeDebugInfo() {
            U.warn(this.log, "First 10 pending exchange futures [total=" + this.futQ.size() + ']');
            int cnt = 0;
            for (CachePartitionExchangeWorkerTask task : this.futQ) {
                if (!(task instanceof GridDhtPartitionsExchangeFuture)) continue;
                U.warn(this.log, ">>> " + ((GridDhtPartitionsExchangeFuture)task).shortInfo());
                if (++cnt != 10) continue;
                break;
            }
        }

        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            Throwable err = null;
            try {
                this.body0();
            }
            catch (InterruptedException | IgniteInterruptedCheckedException e) {
                if (!this.stop) {
                    err = e;
                }
            }
            catch (Throwable e) {
                err = e;
            }
            finally {
                if (err == null && !this.stop && !this.reconnectNeeded) {
                    err = new IllegalStateException("Thread " + this.name() + " is terminated unexpectedly");
                }
                if (err instanceof OutOfMemoryError) {
                    GridCachePartitionExchangeManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                } else if (err != null) {
                    GridCachePartitionExchangeManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
                } else {
                    this.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Could not resolve type clashes
         */
        private void body0() throws InterruptedException, IgniteCheckedException {
            long timeout = GridCachePartitionExchangeManager.this.cctx.gridConfig().getNetworkTimeout();
            long cnt = 0L;
            while (!this.isCancelled()) {
                this.onIdle();
                ++cnt;
                CachePartitionExchangeWorkerTask task = null;
                try {
                    GridDhtPartitionExchangeId exchId;
                    boolean preloadFinished = true;
                    for (Object grp : GridCachePartitionExchangeManager.this.cctx.cache().cacheGroups()) {
                        if (!((CacheGroupContext)grp).isLocal() && !(preloadFinished &= ((CacheGroupContext)grp).preloader() != null && ((CacheGroupContext)grp).preloader().syncFuture().isDone())) break;
                    }
                    if (!GridCachePartitionExchangeManager.this.cctx.kernalContext().clientNode() && !this.hasPendingExchange() && preloadFinished) {
                        timeout = GridCachePartitionExchangeManager.this.cctx.gridConfig().getNetworkTimeout();
                    }
                    if (this.log.isTraceEnabled()) {
                        Object grp;
                        HashSet<GridDhtPartitionsExchangeFuture> unfinished = new HashSet<GridDhtPartitionsExchangeFuture>();
                        grp = GridCachePartitionExchangeManager.this.exchFuts.values().iterator();
                        while (grp.hasNext()) {
                            GridDhtPartitionsExchangeFuture fut = (GridDhtPartitionsExchangeFuture)grp.next();
                            if (fut.isDone()) continue;
                            unfinished.add(fut);
                        }
                        this.log.trace("Before waiting for exchange futures [futs" + unfinished + ", worker=" + this + ']');
                    }
                    if (this.isCancelled()) {
                        Thread.currentThread().interrupt();
                    }
                    this.updateHeartbeat();
                    task = this.futQ.poll(timeout, TimeUnit.MILLISECONDS);
                    this.updateHeartbeat();
                    if (task == null) continue;
                    if (!GridCachePartitionExchangeManager.isExchangeTask(task)) {
                        this.processCustomTask(task);
                        continue;
                    }
                    this.busy = true;
                    HashMap<Integer, GridDhtPreloaderAssignments> assignsMap = null;
                    boolean forcePreload = false;
                    GridDhtPartitionsExchangeFuture exchFut = null;
                    AffinityTopologyVersion resVer = null;
                    try {
                        if (this.isCancelled()) break;
                        if (task instanceof RebalanceReassignExchangeTask) {
                            exchId = ((RebalanceReassignExchangeTask)task).exchangeId();
                        } else if (task instanceof ForceRebalanceExchangeTask) {
                            forcePreload = true;
                            timeout = 0L;
                            exchId = ((ForceRebalanceExchangeTask)task).exchangeId();
                        } else {
                            assert (task instanceof GridDhtPartitionsExchangeFuture) : task;
                            exchFut = (GridDhtPartitionsExchangeFuture)task;
                            exchId = exchFut.exchangeId();
                            GridCachePartitionExchangeManager.this.lastInitializedFut = exchFut;
                            boolean newCrd = false;
                            if (!this.crd) {
                                List<ClusterNode> srvNodes = exchFut.firstEventCache().serverNodes();
                                newCrd = !srvNodes.isEmpty() && srvNodes.get(0).isLocal();
                                this.crd = newCrd;
                            }
                            exchFut.init(newCrd);
                            int dumpCnt = 0;
                            long waitStart = U.currentTimeMillis();
                            boolean txRolledBack = !GridCachePartitionExchangeManager.this.cctx.localNode().isClient();
                            IgniteConfiguration cfg = GridCachePartitionExchangeManager.this.cctx.gridConfig();
                            long dumpTimeout = 2L * cfg.getNetworkTimeout();
                            long nextDumpTime = 0L;
                            while (true) {
                                long curTimeout = cfg.getTransactionConfiguration().getTxTimeoutOnPartitionMapExchange();
                                try {
                                    long exchTimeout = curTimeout > 0L && !txRolledBack ? Math.min(curTimeout, dumpTimeout) : dumpTimeout;
                                    this.blockingSectionBegin();
                                    try {
                                        resVer = (AffinityTopologyVersion)exchFut.get(exchTimeout, TimeUnit.MILLISECONDS);
                                    }
                                    finally {
                                        this.blockingSectionEnd();
                                    }
                                    this.onIdle();
                                }
                                catch (IgniteFutureTimeoutCheckedException ignored) {
                                    this.updateHeartbeat();
                                    if (nextDumpTime <= U.currentTimeMillis()) {
                                        U.warn(GridCachePartitionExchangeManager.this.diagnosticLog, "Failed to wait for partition map exchange [topVer=" + exchFut.initialVersion() + ", node=" + GridCachePartitionExchangeManager.this.cctx.localNodeId() + "]. " + (curTimeout <= 0L && !txRolledBack ? "Consider changing TransactionConfiguration.txTimeoutOnPartitionMapSynchronization to non default value to avoid this message. " : "") + "Dumping pending objects that might be the cause: ");
                                        try {
                                            GridCachePartitionExchangeManager.this.dumpDebugInfo(exchFut);
                                        }
                                        catch (Exception e) {
                                            U.error(GridCachePartitionExchangeManager.this.diagnosticLog, "Failed to dump debug information: " + e, e);
                                        }
                                        nextDumpTime = U.currentTimeMillis() + GridDhtPartitionsExchangeFuture.nextDumpTimeout(dumpCnt++, dumpTimeout);
                                    }
                                    if (txRolledBack || curTimeout <= 0L || U.currentTimeMillis() - waitStart < curTimeout) continue;
                                    txRolledBack = true;
                                    GridCachePartitionExchangeManager.this.cctx.tm().rollbackOnTopologyChange(exchFut.initialVersion());
                                    continue;
                                }
                                catch (Exception e) {
                                    if (exchFut.reconnectOnError(e)) {
                                        throw new IgniteNeedReconnectException(GridCachePartitionExchangeManager.this.cctx.localNode(), (Throwable)e);
                                    }
                                    throw e;
                                }
                                break;
                            }
                            this.removeMergedFutures(resVer, exchFut);
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("After waiting for exchange future [exchFut=" + exchFut + ", worker=" + this + ']');
                            }
                            if (exchFut.exchangeId().nodeId().equals(GridCachePartitionExchangeManager.this.cctx.localNodeId())) {
                                GridCachePartitionExchangeManager.this.lastRefresh.compareAndSet(-1L, U.currentTimeMillis());
                            }
                            boolean changed = false;
                            for (CacheGroupContext grp : GridCachePartitionExchangeManager.this.cctx.cache().cacheGroups()) {
                                if (grp.isLocal()) continue;
                                if (grp.preloader().rebalanceRequired(GridCachePartitionExchangeManager.this.rebTopVer, exchFut)) {
                                    GridCachePartitionExchangeManager.this.rebTopVer = AffinityTopologyVersion.NONE;
                                }
                                changed |= grp.topology().afterExchange(exchFut);
                            }
                            if (!GridCachePartitionExchangeManager.this.cctx.kernalContext().clientNode() && changed && !this.hasPendingServerExchange()) {
                                GridCachePartitionExchangeManager.this.refreshPartitions();
                            }
                        }
                        if (exchFut == null) {
                            GridCachePartitionExchangeManager.this.rebTopVer = AffinityTopologyVersion.NONE;
                        }
                        if (!GridCachePartitionExchangeManager.this.cctx.kernalContext().clientNode() && GridCachePartitionExchangeManager.this.rebTopVer.equals(AffinityTopologyVersion.NONE)) {
                            assignsMap = new HashMap<Integer, GridDhtPreloaderAssignments>();
                            IgniteCacheSnapshotManager snp = GridCachePartitionExchangeManager.this.cctx.snapshot();
                            for (CacheGroupContext grp : GridCachePartitionExchangeManager.this.cctx.cache().cacheGroups()) {
                                long delay = grp.config().getRebalanceDelay();
                                boolean disableRebalance = snp.partitionsAreFrozen(grp);
                                GridDhtPreloaderAssignments assigns = null;
                                if ((delay == 0L || forcePreload) && !disableRebalance) {
                                    assigns = grp.preloader().generateAssignments(exchId, exchFut);
                                }
                                assignsMap.put(grp.groupId(), assigns);
                                if (resVer != null || grp.isLocal()) continue;
                                resVer = grp.topology().readyTopologyVersion();
                            }
                        }
                        if (resVer == null) {
                            resVer = exchId.topologyVersion();
                        }
                    }
                    finally {
                        this.busy = false;
                    }
                    if (assignsMap != null && GridCachePartitionExchangeManager.this.rebTopVer.equals(AffinityTopologyVersion.NONE)) {
                        int size = assignsMap.size();
                        TreeMap orderMap = new TreeMap();
                        for (Map.Entry e : assignsMap.entrySet()) {
                            int grpId = (Integer)e.getKey();
                            CacheGroupContext grp = GridCachePartitionExchangeManager.this.cctx.cache().cacheGroup(grpId);
                            int order = grp.config().getRebalanceOrder();
                            if (orderMap.get(order) == null) {
                                orderMap.put(order, new ArrayList(size));
                            }
                            ((List)orderMap.get(order)).add(grpId);
                        }
                        Runnable r = null;
                        LinkedList<String> rebList = new LinkedList<String>();
                        boolean assignsCancelled = false;
                        GridCompoundFuture<Boolean, Boolean> forcedRebFut = null;
                        if (task instanceof ForceRebalanceExchangeTask) {
                            forcedRebFut = ((ForceRebalanceExchangeTask)task).forcedRebalanceFuture();
                        }
                        for (Integer order : orderMap.descendingKeySet()) {
                            for (Integer grpId : (List)orderMap.get(order)) {
                                Runnable cur;
                                CacheGroupContext grp = GridCachePartitionExchangeManager.this.cctx.cache().cacheGroup(grpId);
                                GridDhtPreloaderAssignments assigns = (GridDhtPreloaderAssignments)assignsMap.get(grpId);
                                if (assigns != null) {
                                    assignsCancelled |= assigns.cancelled();
                                }
                                if ((cur = grp.preloader().addAssignments(assigns, forcePreload, cnt, r, forcedRebFut)) == null) continue;
                                rebList.add(grp.cacheOrGroupName());
                                r = cur;
                            }
                        }
                        if (forcedRebFut != null) {
                            forcedRebFut.markInitialized();
                        }
                        if (assignsCancelled || this.hasPendingExchange()) {
                            U.log(this.log, "Skipping rebalancing (obsolete exchange ID) [top=" + resVer + ", evt=" + exchId.discoveryEventName() + ", node=" + exchId.nodeId() + ']');
                            continue;
                        }
                        if (r != null) {
                            Collections.reverse(rebList);
                            U.log(this.log, "Rebalancing scheduled [order=" + rebList + ", top=" + resVer + ", force=" + (exchFut == null) + ", evt=" + exchId.discoveryEventName() + ", node=" + exchId.nodeId() + ']');
                            GridCachePartitionExchangeManager.this.rebTopVer = resVer;
                            r.run();
                            continue;
                        }
                        U.log(this.log, "Skipping rebalancing (nothing scheduled) [top=" + resVer + ", force=" + (exchFut == null) + ", evt=" + exchId.discoveryEventName() + ", node=" + exchId.nodeId() + ']');
                        continue;
                    }
                    U.log(this.log, "Skipping rebalancing (no affinity changes) [top=" + resVer + ", rebTopVer=" + GridCachePartitionExchangeManager.this.rebTopVer + ", evt=" + exchId.discoveryEventName() + ", evtNode=" + exchId.nodeId() + ", client=" + GridCachePartitionExchangeManager.this.cctx.kernalContext().clientNode() + ']');
                }
                catch (IgniteInterruptedCheckedException e) {
                    throw e;
                }
                catch (IgniteClientDisconnectedCheckedException | IgniteNeedReconnectException e) {
                    if (GridCachePartitionExchangeManager.this.cctx.discovery().reconnectSupported()) {
                        U.warn(this.log, "Local node failed to complete partition map exchange due to exception, will try to reconnect to cluster: " + e.getMessage(), e);
                        GridCachePartitionExchangeManager.this.cctx.discovery().reconnect();
                        this.reconnectNeeded = true;
                    } else {
                        U.warn(this.log, "Local node received IgniteClientDisconnectedCheckedException or  IgniteNeedReconnectException exception but doesn't support reconnect, stopping node: " + e.getMessage(), e);
                    }
                    return;
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to wait for completion of partition map exchange (preloading will not start): " + task, e);
                    throw e;
                }
            }
        }
    }
}

