/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.authentication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.discovery.CustomEventListener;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.managers.eventstorage.DiscoveryEventListener;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.authentication.AuthorizationContext;
import org.apache.ignite.internal.processors.authentication.IgniteAccessControlException;
import org.apache.ignite.internal.processors.authentication.User;
import org.apache.ignite.internal.processors.authentication.UserAcceptedMessage;
import org.apache.ignite.internal.processors.authentication.UserAuthenticateRequestMessage;
import org.apache.ignite.internal.processors.authentication.UserAuthenticateResponseMessage;
import org.apache.ignite.internal.processors.authentication.UserManagementException;
import org.apache.ignite.internal.processors.authentication.UserManagementOperation;
import org.apache.ignite.internal.processors.authentication.UserManagementOperationFinishedMessage;
import org.apache.ignite.internal.processors.authentication.UserProposedMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteFutureCancelledException;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.jetbrains.annotations.Nullable;

public class IgniteAuthenticationProcessor
extends GridProcessorAdapter
implements MetastorageLifecycleListener {
    private static final String STORE_USER_PREFIX = "user.";
    private static final int[] DISCO_EVT_TYPES = new int[]{11, 12, 10};
    private final ConcurrentHashMap<IgniteUuid, UserOperationFinishFuture> opFinishFuts = new ConcurrentHashMap();
    private final ConcurrentMap<IgniteUuid, AuthenticateFuture> authFuts = new ConcurrentHashMap<IgniteUuid, AuthenticateFuture>();
    private final GridFutureAdapter<Void> readyForAuthFut = new GridFutureAdapter();
    private final Object mux = new Object();
    private final Map<IgniteUuid, UserManagementOperation> activeOps = Collections.synchronizedMap(new LinkedHashMap());
    private ConcurrentMap<String, User> users;
    @GridToStringExclude
    private GridCacheSharedContext<?, ?> sharedCtx;
    private ReadWriteMetastorage metastorage;
    private IgniteThreadPoolExecutor exec;
    private ClusterNode crdNode;
    private boolean isEnabled;
    private volatile boolean disconnected;
    private UserManagementOperationFinishedMessage curOpFinishMsg;
    private InitialUsersData initUsrs;
    private GridMessageListener ioLsnr;
    private DiscoveryEventListener discoLsnr;
    private final GridFutureAdapter<Void> activateFut = new GridFutureAdapter();
    private String validateErr;

    public IgniteAuthenticationProcessor(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public void start() throws IgniteCheckedException {
        super.start();
        this.isEnabled = this.ctx.config().isAuthenticationEnabled();
        if (this.isEnabled && !GridCacheUtils.isPersistenceEnabled(this.ctx.config())) {
            this.isEnabled = false;
            throw new IgniteCheckedException("Authentication can be enabled only for cluster with enabled persistence. Check the DataRegionConfiguration");
        }
        this.ctx.internalSubscriptionProcessor().registerMetastorageListener(this);
        this.ctx.addNodeAttribute("org.apache.ignite.authentication.enabled", this.isEnabled);
        GridDiscoveryManager discoMgr = this.ctx.discovery();
        GridIoManager ioMgr = this.ctx.io();
        discoMgr.setCustomEventListener(UserProposedMessage.class, new UserProposedListener());
        discoMgr.setCustomEventListener(UserAcceptedMessage.class, new UserAcceptedListener());
        this.discoLsnr = (evt, discoCache) -> {
            if (!this.isEnabled || this.ctx.isStopping()) {
                return;
            }
            switch (evt.type()) {
                case 11: 
                case 12: {
                    this.onNodeLeft(evt.eventNode().id());
                    break;
                }
                case 10: {
                    this.onNodeJoin(evt.eventNode());
                }
            }
        };
        this.ctx.event().addDiscoveryEventListener(this.discoLsnr, DISCO_EVT_TYPES);
        this.ioLsnr = (nodeId, msg, plc) -> {
            if (!this.isEnabled || this.ctx.isStopping()) {
                return;
            }
            if (msg instanceof UserManagementOperationFinishedMessage) {
                this.onFinishMessage(nodeId, (UserManagementOperationFinishedMessage)msg);
            } else if (msg instanceof UserAuthenticateRequestMessage) {
                this.onAuthenticateRequestMessage(nodeId, (UserAuthenticateRequestMessage)msg);
            } else if (msg instanceof UserAuthenticateResponseMessage) {
                this.onAuthenticateResponseMessage((UserAuthenticateResponseMessage)msg);
            }
        };
        ioMgr.addMessageListener(GridTopic.TOPIC_AUTH, this.ioLsnr);
        this.exec = new IgniteThreadPoolExecutor("auth", this.ctx.config().getIgniteInstanceName(), 1, 1, 0L, new LinkedBlockingQueue<Runnable>());
    }

    public void cacheProcessorStarted() {
        this.sharedCtx = this.ctx.cache().context();
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        if (!this.isEnabled) {
            return;
        }
        this.ctx.io().removeMessageListener(GridTopic.TOPIC_AUTH, this.ioLsnr);
        this.ctx.event().removeDiscoveryEventListener(this.discoLsnr, DISCO_EVT_TYPES);
        this.cancelFutures("Node stopped");
        if (!cancel) {
            this.exec.shutdown();
        } else {
            this.exec.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onKernalStop(boolean cancel) {
        if (!this.isEnabled) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            this.cancelFutures("Kernal stopped.");
        }
    }

    @Override
    public void onKernalStart(boolean active) throws IgniteCheckedException {
        super.onKernalStart(active);
        if (this.validateErr != null) {
            throw new IgniteCheckedException(this.validateErr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisconnected(IgniteFuture reconnectFut) {
        if (!this.isEnabled) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            assert (!this.disconnected);
            this.disconnected = true;
            this.cancelFutures("Client node was disconnected from topology (operation result is unknown).");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<?> onReconnected(boolean active) {
        if (!this.isEnabled) {
            return null;
        }
        Object object = this.mux;
        synchronized (object) {
            assert (this.disconnected);
            this.disconnected = false;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationContext authenticate(String login, String passwd) throws IgniteCheckedException {
        this.checkEnabled();
        if (F.isEmpty(login)) {
            throw new IgniteAccessControlException("The user name or password is incorrect [userName=" + login + ']');
        }
        if (this.ctx.clientNode()) {
            AuthenticateFuture fut;
            do {
                Object object = this.mux;
                synchronized (object) {
                    ClusterNode rndNode = U.randomServerNode(this.ctx);
                    fut = new AuthenticateFuture(rndNode.id());
                    UserAuthenticateRequestMessage msg = new UserAuthenticateRequestMessage(login, passwd);
                    this.authFuts.put(msg.id(), fut);
                    this.ctx.io().sendToGridTopic(rndNode, GridTopic.TOPIC_AUTH, (Message)msg, (byte)2);
                }
                fut.get();
            } while (fut.retry());
            return new AuthorizationContext(User.create(login));
        }
        return new AuthorizationContext(this.authenticateOnServer(login, passwd));
    }

    public static void validate(String login, String passwd) throws UserManagementException {
        if (F.isEmpty(login)) {
            throw new UserManagementException("User name is empty");
        }
        if (F.isEmpty(passwd)) {
            throw new UserManagementException("Password is empty");
        }
        if ((STORE_USER_PREFIX + login).getBytes().length > 64) {
            throw new UserManagementException("User name is too long. The user name length must be less then 60 bytes in UTF8");
        }
    }

    public void addUser(String login, String passwd) throws IgniteCheckedException {
        IgniteAuthenticationProcessor.validate(login, passwd);
        UserManagementOperation op = new UserManagementOperation(User.create(login, passwd), UserManagementOperation.OperationType.ADD);
        this.execUserOperation(op).get();
    }

    public void removeUser(String login) throws IgniteCheckedException {
        UserManagementOperation op = new UserManagementOperation(User.create(login), UserManagementOperation.OperationType.REMOVE);
        this.execUserOperation(op).get();
    }

    public void updateUser(String login, String passwd) throws IgniteCheckedException {
        UserManagementOperation op = new UserManagementOperation(User.create(login, passwd), UserManagementOperation.OperationType.UPDATE);
        this.execUserOperation(op).get();
    }

    @Override
    public void onReadyForRead(ReadOnlyMetastorage metastorage) throws IgniteCheckedException {
        if (!this.ctx.clientNode()) {
            this.users = new ConcurrentHashMap<String, User>();
            Map<String, ? extends Serializable> readUsers = metastorage.readForPredicate(key -> key != null && key.startsWith(STORE_USER_PREFIX));
            for (User user : readUsers.values()) {
                this.users.put(user.name(), user);
            }
        } else {
            this.users = null;
        }
    }

    @Override
    public void onReadyForReadWrite(ReadWriteMetastorage metastorage) {
        this.metastorage = !this.ctx.clientNode() ? metastorage : null;
    }

    @Override
    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return GridComponent.DiscoveryDataExchangeType.AUTH_PROC;
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node) {
        Boolean rmtEnabled = (Boolean)node.attribute("org.apache.ignite.authentication.enabled");
        if (this.isEnabled && rmtEnabled == null) {
            String errMsg = "Failed to add node to topology because user authentication is enabled on cluster and the node doesn't support user authentication [nodeId=" + node.id() + ']';
            return new IgniteNodeValidationResult(node.id(), errMsg, errMsg);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectGridNodeData(DiscoveryDataBag dataBag) {
        if (!this.isEnabled || !this.isLocalNodeCoordinator() || dataBag.isJoiningNodeClient()) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            if (!dataBag.commonDataCollectedFor(GridComponent.DiscoveryDataExchangeType.AUTH_PROC.ordinal())) {
                InitialUsersData d = new InitialUsersData(this.users.values(), this.activeOps.values());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Collected initial users data: " + d);
                }
                dataBag.addGridCommonData(GridComponent.DiscoveryDataExchangeType.AUTH_PROC.ordinal(), d);
            }
        }
    }

    private boolean isLocalNodeCoordinator() {
        DiscoverySpi spi = this.ctx.discovery().getInjectedDiscoverySpi();
        if (spi instanceof TcpDiscoverySpi) {
            return ((TcpDiscoverySpi)spi).isLocalNodeCoordinator();
        }
        return F.eq(this.ctx.localNodeId(), this.coordinator().id());
    }

    @Override
    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
        this.initUsrs = (InitialUsersData)data.commonData();
    }

    public boolean enabled() {
        return this.isEnabled;
    }

    private void checkActivate() {
        if (!this.ctx.state().publicApiActiveState(true)) {
            throw new IgniteException("Can not perform the operation because the cluster is inactive. Note, that the cluster is considered inactive by default if Ignite Persistent Store is used to let all the nodes join the cluster. To activate the cluster call Ignite.active(true).");
        }
    }

    private void checkEnabled() {
        if (!this.isEnabled) {
            throw new IgniteException("Can not perform the operation because the authentication is not enabled for the cluster.");
        }
    }

    private void addDefaultUser() {
        assert (this.users != null && this.users.isEmpty());
        User dfltUser = User.defaultUser();
        this.users.put(dfltUser.name(), dfltUser);
        this.exec.execute(new RefreshUsersStorageWorker(new ArrayList<User>(Collections.singleton(dfltUser))));
    }

    private User authenticateOnServer(String login, String passwd) throws IgniteCheckedException {
        assert (!this.ctx.clientNode()) : "Must be used on server node";
        this.readyForAuthFut.get();
        User usr = (User)this.users.get(login);
        if (usr == null) {
            throw new IgniteAccessControlException("The user name or password is incorrect [userName=" + login + ']');
        }
        if (usr.authorize(passwd)) {
            return usr;
        }
        throw new IgniteAccessControlException("The user name or password is incorrect [userName=" + login + ']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserOperationFinishFuture execUserOperation(UserManagementOperation op) throws IgniteCheckedException {
        this.checkActivate();
        this.checkEnabled();
        Object object = this.mux;
        synchronized (object) {
            if (this.disconnected) {
                throw new UserManagementException("Failed to initiate user management operation because client node is disconnected.");
            }
            AuthorizationContext actx = AuthorizationContext.context();
            if (actx == null) {
                throw new IgniteAccessControlException("Operation not allowed: authorized context is empty.");
            }
            actx.checkUserOperation(op);
            UserOperationFinishFuture fut = new UserOperationFinishFuture(op.id());
            this.opFinishFuts.put(op.id(), fut);
            UserProposedMessage msg = new UserProposedMessage(op);
            this.ctx.discovery().sendCustomEvent(msg);
            return fut;
        }
    }

    private void processOperationLocal(UserManagementOperation op) throws IgniteCheckedException {
        assert (op != null && op.user() != null) : "Invalid operation: " + op;
        switch (op.type()) {
            case ADD: {
                this.addUserLocal(op);
                break;
            }
            case REMOVE: {
                this.removeUserLocal(op);
                break;
            }
            case UPDATE: {
                this.updateUserLocal(op);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUserLocal(UserManagementOperation op) throws IgniteCheckedException {
        User usr = op.user();
        String userName = usr.name();
        if (this.users.containsKey(userName)) {
            throw new UserManagementException("User already exists [login=" + userName + ']');
        }
        this.metastorage.write(STORE_USER_PREFIX + userName, usr);
        Object object = this.mux;
        synchronized (object) {
            this.activeOps.remove(op.id());
            this.users.put(userName, usr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUserLocal(UserManagementOperation op) throws IgniteCheckedException {
        User usr = op.user();
        if (!this.users.containsKey(usr.name())) {
            throw new UserManagementException("User doesn't exist [userName=" + usr.name() + ']');
        }
        this.metastorage.remove(STORE_USER_PREFIX + usr.name());
        Object object = this.mux;
        synchronized (object) {
            this.activeOps.remove(op.id());
            this.users.remove(usr.name());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUserLocal(UserManagementOperation op) throws IgniteCheckedException {
        User usr = op.user();
        if (!this.users.containsKey(usr.name())) {
            throw new UserManagementException("User doesn't exist [userName=" + usr.name() + ']');
        }
        this.metastorage.write(STORE_USER_PREFIX + usr.name(), usr);
        Object object = this.mux;
        synchronized (object) {
            this.activeOps.remove(op.id());
            this.users.put(usr.name(), usr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterNode coordinator() {
        Object object = this.mux;
        synchronized (object) {
            if (this.crdNode != null) {
                return this.crdNode;
            }
            ClusterNode res = null;
            for (ClusterNode node : this.ctx.discovery().aliveServerNodes()) {
                if (res != null && res.order() <= node.order()) continue;
                res = node;
            }
            if (res == null && !this.ctx.discovery().allNodes().isEmpty() && this.ctx.discovery().aliveServerNodes().isEmpty()) {
                U.warn(this.log, "Cannot find the server coordinator node. Possible a client is started with forceServerMode=true. Security warning: user authentication will be disabled on the client.");
                this.isEnabled = false;
            } else assert (res != null);
            this.crdNode = res;
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelFutures(String msg) {
        Iterator iterator = this.mux;
        synchronized (iterator) {
            for (UserOperationFinishFuture fut : this.opFinishFuts.values()) {
                fut.onDone(null, (Throwable)new IgniteFutureCancelledException(msg));
            }
        }
        for (GridFutureAdapter fut : this.authFuts.values()) {
            fut.onDone(null, new IgniteFutureCancelledException(msg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNodeJoin(ClusterNode node) {
        if (IgniteAuthenticationProcessor.isNodeHoldsUsers(this.ctx.discovery().localNode()) && IgniteAuthenticationProcessor.isNodeHoldsUsers(node)) {
            Object object = this.mux;
            synchronized (object) {
                for (UserOperationFinishFuture f : this.opFinishFuts.values()) {
                    f.onNodeJoin(node.id());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNodeLeft(UUID nodeId) {
        Object object = this.mux;
        synchronized (object) {
            if (!this.ctx.clientNode()) {
                for (UserOperationFinishFuture userOperationFinishFuture : this.opFinishFuts.values()) {
                    userOperationFinishFuture.onNodeLeft(nodeId);
                }
            }
            Iterator it = this.authFuts.entrySet().iterator();
            while (it.hasNext()) {
                AuthenticateFuture authenticateFuture = (AuthenticateFuture)it.next().getValue();
                if (!F.eq(nodeId, authenticateFuture.nodeId())) continue;
                authenticateFuture.retry(true);
                authenticateFuture.onDone();
                it.remove();
            }
            if (F.eq(this.coordinator().id(), nodeId)) {
                this.crdNode = null;
                if (this.curOpFinishMsg != null) {
                    this.sendFinish(this.curOpFinishMsg);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFinishMessage(UUID nodeId, UserManagementOperationFinishedMessage msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(msg.toString());
        }
        Object object = this.mux;
        synchronized (object) {
            UserOperationFinishFuture fut = this.opFinishFuts.get(msg.operationId());
            if (fut == null) {
                fut = new UserOperationFinishFuture(msg.operationId());
                this.opFinishFuts.put(msg.operationId(), fut);
            }
            if (msg.success()) {
                fut.onSuccessOnNode(nodeId);
            } else {
                fut.onOperationFailOnNode(nodeId, msg.errorMessage());
            }
        }
    }

    private void onFinishOperation(IgniteUuid opId, IgniteCheckedException err) {
        block2: {
            try {
                UserAcceptedMessage msg = new UserAcceptedMessage(opId, err);
                this.ctx.discovery().sendCustomEvent(msg);
            }
            catch (IgniteCheckedException e) {
                if (e.hasCause(IgniteFutureCancelledException.class)) break block2;
                U.error(this.log, "Unexpected exception on send UserAcceptedMessage.", e);
            }
        }
    }

    private void onAuthenticateRequestMessage(UUID nodeId, UserAuthenticateRequestMessage msg) {
        UserAuthenticateResponseMessage respMsg;
        try {
            User u = this.authenticateOnServer(msg.name(), msg.password());
            respMsg = new UserAuthenticateResponseMessage(msg.id(), null);
        }
        catch (IgniteCheckedException e) {
            respMsg = new UserAuthenticateResponseMessage(msg.id(), e.toString());
            e.printStackTrace();
        }
        try {
            this.ctx.io().sendToGridTopic(nodeId, GridTopic.TOPIC_AUTH, (Message)respMsg, (byte)2);
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Unexpected exception on send UserAuthenticateResponseMessage.", e);
        }
    }

    private void onAuthenticateResponseMessage(UserAuthenticateResponseMessage msg) {
        GridFutureAdapter fut = (GridFutureAdapter)this.authFuts.get(msg.id());
        fut.onDone(null, !msg.success() ? new IgniteAccessControlException(msg.errorMessage()) : null);
        this.authFuts.remove(msg.id());
    }

    public void onLocalJoin() {
        if (this.coordinator() == null) {
            return;
        }
        if (F.eq(this.coordinator().id(), this.ctx.localNodeId())) {
            if (!this.isEnabled) {
                return;
            }
            assert (this.initUsrs == null);
            if (this.users.isEmpty()) {
                this.addDefaultUser();
            }
        } else {
            Boolean rmtEnabled = (Boolean)this.coordinator().attribute("org.apache.ignite.authentication.enabled");
            if (rmtEnabled == null) {
                rmtEnabled = false;
            }
            if (this.isEnabled != rmtEnabled) {
                if (rmtEnabled.booleanValue()) {
                    U.warn(this.log, "User authentication is enabled on cluster. Enables on local node");
                } else {
                    this.validateErr = "User authentication is disabled on cluster";
                    return;
                }
            }
            this.isEnabled = rmtEnabled;
            if (!this.isEnabled) {
                try {
                    this.stop(false);
                }
                catch (IgniteCheckedException e) {
                    U.warn(this.log, "Unexpected exception on stopped authentication processor", e);
                }
                return;
            }
            if (this.ctx.clientNode()) {
                return;
            }
            assert (this.initUsrs != null);
            if (!F.isEmpty(this.initUsrs.usrs)) {
                if (this.users == null) {
                    this.users = new ConcurrentHashMap<String, User>();
                } else {
                    this.users.clear();
                }
                for (User u : this.initUsrs.usrs) {
                    this.users.put(u.name(), u);
                }
                this.exec.execute(new RefreshUsersStorageWorker(this.initUsrs.usrs));
            }
            for (UserManagementOperation op : this.initUsrs.activeOps) {
                this.submitOperation(op);
            }
        }
        this.readyForAuthFut.onDone();
    }

    public void onActivate() {
        this.activateFut.onDone();
    }

    private void waitActivate() {
        try {
            this.activateFut.get();
        }
        catch (IgniteCheckedException igniteCheckedException) {
            // empty catch block
        }
    }

    private void sendFinish(UserManagementOperationFinishedMessage msg) {
        try {
            this.ctx.io().sendToGridTopic(this.coordinator(), GridTopic.TOPIC_AUTH, (Message)msg, (byte)2);
        }
        catch (Exception e) {
            U.error(this.log, "Failed to send UserManagementOperationFinishedMessage [op=" + msg.operationId() + ", node=" + this.coordinator() + ", err=" + msg.errorMessage() + ']', e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitOperation(UserManagementOperation op) {
        Object object = this.mux;
        synchronized (object) {
            UserOperationFinishFuture fut = this.opFinishFuts.get(op.id());
            if (fut == null) {
                fut = new UserOperationFinishFuture(op.id());
                this.opFinishFuts.put(op.id(), fut);
            }
            if (!fut.workerSubmitted()) {
                fut.workerSubmitted(true);
                this.activeOps.put(op.id(), op);
                this.exec.execute(new UserOperationWorker(op, fut));
            }
        }
    }

    private static boolean isNodeHoldsUsers(ClusterNode n) {
        return !n.isClient() && !n.isDaemon();
    }

    private class RefreshUsersStorageWorker
    extends GridWorker {
        private final ArrayList<User> newUsrs;

        private RefreshUsersStorageWorker(ArrayList<User> usrs) {
            super(IgniteAuthenticationProcessor.this.ctx.igniteInstanceName(), "refresh-store", IgniteAuthenticationProcessor.this.log);
            assert (!F.isEmpty(usrs));
            this.newUsrs = usrs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            if (IgniteAuthenticationProcessor.this.ctx.clientNode()) {
                return;
            }
            IgniteAuthenticationProcessor.this.waitActivate();
            if (IgniteAuthenticationProcessor.this.sharedCtx != null) {
                IgniteAuthenticationProcessor.this.sharedCtx.database().checkpointReadLock();
            }
            try {
                Map<String, ? extends Serializable> existUsrs = IgniteAuthenticationProcessor.this.metastorage.readForPredicate(key -> key != null && key.startsWith(IgniteAuthenticationProcessor.STORE_USER_PREFIX));
                for (String key2 : existUsrs.keySet()) {
                    IgniteAuthenticationProcessor.this.metastorage.remove(key2);
                }
                for (User u : this.newUsrs) {
                    IgniteAuthenticationProcessor.this.metastorage.write(IgniteAuthenticationProcessor.STORE_USER_PREFIX + u.name(), u);
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Cannot cleanup old users information at metastorage", e);
            }
            finally {
                if (IgniteAuthenticationProcessor.this.sharedCtx != null) {
                    IgniteAuthenticationProcessor.this.sharedCtx.database().checkpointReadUnlock();
                }
            }
        }
    }

    private class UserOperationWorker
    extends GridWorker {
        private final UserManagementOperation op;
        private final UserOperationFinishFuture fut;

        private UserOperationWorker(UserManagementOperation op, UserOperationFinishFuture fut) {
            super(IgniteAuthenticationProcessor.this.ctx.igniteInstanceName(), "auth-op-" + (Object)((Object)op.type()), IgniteAuthenticationProcessor.this.log);
            this.op = op;
            this.fut = fut;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            UserManagementOperationFinishedMessage msg0;
            if (IgniteAuthenticationProcessor.this.ctx.isStopping()) {
                return;
            }
            IgniteAuthenticationProcessor.this.waitActivate();
            if (IgniteAuthenticationProcessor.this.sharedCtx != null) {
                IgniteAuthenticationProcessor.this.sharedCtx.database().checkpointReadLock();
            }
            try {
                IgniteAuthenticationProcessor.this.processOperationLocal(this.op);
                msg0 = new UserManagementOperationFinishedMessage(this.op.id(), null);
            }
            catch (UserManagementException e) {
                msg0 = new UserManagementOperationFinishedMessage(this.op.id(), e.toString());
                IgniteAuthenticationProcessor.this.activeOps.remove(this.op.id());
            }
            catch (Throwable e) {
                this.log.warning("Unexpected exception on perform user management operation", e);
                msg0 = new UserManagementOperationFinishedMessage(this.op.id(), e.toString());
                IgniteAuthenticationProcessor.this.activeOps.remove(this.op.id());
            }
            finally {
                if (IgniteAuthenticationProcessor.this.sharedCtx != null) {
                    IgniteAuthenticationProcessor.this.sharedCtx.database().checkpointReadUnlock();
                }
            }
            IgniteAuthenticationProcessor.this.curOpFinishMsg = msg0;
            IgniteAuthenticationProcessor.this.sendFinish(IgniteAuthenticationProcessor.this.curOpFinishMsg);
            try {
                this.fut.get();
            }
            catch (IgniteCheckedException e) {
                if (!e.hasCause(IgniteFutureCancelledException.class)) {
                    U.error(this.log, "Unexpected exception on wait for end of user operation.", e);
                }
            }
            finally {
                IgniteAuthenticationProcessor.this.curOpFinishMsg = null;
            }
        }
    }

    private static class AuthenticateFuture
    extends GridFutureAdapter<Void> {
        private final UUID nodeId;
        private boolean retry;

        AuthenticateFuture(UUID nodeId) {
            this.nodeId = nodeId;
        }

        UUID nodeId() {
            return this.nodeId;
        }

        boolean retry() {
            return this.retry;
        }

        void retry(boolean retry) {
            this.retry = retry;
        }
    }

    private class UserOperationFinishFuture
    extends GridFutureAdapter<Void> {
        private final Set<UUID> requiredFinish;
        private final Set<UUID> receivedFinish;
        private final IgniteUuid opId;
        private boolean workerSubmitted;
        private IgniteCheckedException err;

        UserOperationFinishFuture(IgniteUuid opId) {
            this.opId = opId;
            if (!IgniteAuthenticationProcessor.this.ctx.clientNode()) {
                this.requiredFinish = new HashSet<UUID>();
                this.receivedFinish = new HashSet<UUID>();
                for (ClusterNode node : IgniteAuthenticationProcessor.this.ctx.discovery().nodes(IgniteAuthenticationProcessor.this.ctx.discovery().topologyVersionEx())) {
                    if (!IgniteAuthenticationProcessor.isNodeHoldsUsers(node)) continue;
                    this.requiredFinish.add(node.id());
                }
            } else {
                this.requiredFinish = null;
                this.receivedFinish = null;
            }
        }

        boolean workerSubmitted() {
            return this.workerSubmitted;
        }

        void workerSubmitted(boolean val) {
            this.workerSubmitted = val;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onDone(@Nullable Void res, @Nullable Throwable err) {
            boolean done = super.onDone(res, err);
            Object object = IgniteAuthenticationProcessor.this.mux;
            synchronized (object) {
                if (done) {
                    IgniteAuthenticationProcessor.this.opFinishFuts.remove(this.opId, this);
                }
            }
            return done;
        }

        synchronized void onNodeLeft(UUID nodeId) {
            assert (this.requiredFinish != null) : "Process node left on client";
            this.requiredFinish.remove(nodeId);
            this.checkOperationFinished();
        }

        synchronized void onNodeJoin(UUID id) {
            assert (this.requiredFinish != null) : "Process node join on client";
            this.requiredFinish.add(id);
        }

        synchronized void onSuccessOnNode(UUID nodeId) {
            assert (this.receivedFinish != null) : "Process operation state on client";
            this.receivedFinish.add(nodeId);
            this.checkOperationFinished();
        }

        synchronized void onOperationFailOnNode(UUID nodeId, String errMsg) {
            assert (this.receivedFinish != null) : "Process operation state on client";
            if (IgniteAuthenticationProcessor.this.log.isDebugEnabled()) {
                IgniteAuthenticationProcessor.this.log.debug("User operation is failed [nodeId=" + nodeId + ", err=" + errMsg + ']');
            }
            this.receivedFinish.add(nodeId);
            UserManagementException e = new UserManagementException("Operation failed [nodeId=" + nodeId + ", opId=" + this.opId + ", err=" + errMsg + ']');
            if (this.err == null) {
                this.err = e;
            } else {
                this.err.addSuppressed(e);
            }
            this.checkOperationFinished();
        }

        private void checkOperationFinished() {
            if (this.receivedFinish.containsAll(this.requiredFinish)) {
                IgniteAuthenticationProcessor.this.onFinishOperation(this.opId, this.err);
            }
        }
    }

    private final class UserAcceptedListener
    implements CustomEventListener<UserAcceptedMessage> {
        private UserAcceptedListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, UserAcceptedMessage msg) {
            if (!IgniteAuthenticationProcessor.this.isEnabled || IgniteAuthenticationProcessor.this.ctx.isStopping()) {
                return;
            }
            if (IgniteAuthenticationProcessor.this.log.isDebugEnabled()) {
                IgniteAuthenticationProcessor.this.log.debug(msg.toString());
            }
            Object object = IgniteAuthenticationProcessor.this.mux;
            synchronized (object) {
                UserOperationFinishFuture f = (UserOperationFinishFuture)IgniteAuthenticationProcessor.this.opFinishFuts.get(msg.operationId());
                if (f != null) {
                    if (msg.error() != null) {
                        f.onDone(null, (Throwable)msg.error());
                    } else {
                        f.onDone();
                    }
                }
            }
        }
    }

    private final class UserProposedListener
    implements CustomEventListener<UserProposedMessage> {
        private UserProposedListener() {
        }

        @Override
        public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, UserProposedMessage msg) {
            if (!IgniteAuthenticationProcessor.this.isEnabled || IgniteAuthenticationProcessor.this.ctx.isStopping() || IgniteAuthenticationProcessor.this.ctx.clientNode()) {
                return;
            }
            if (IgniteAuthenticationProcessor.this.log.isDebugEnabled()) {
                IgniteAuthenticationProcessor.this.log.debug(msg.toString());
            }
            IgniteAuthenticationProcessor.this.submitOperation(msg.operation());
        }
    }

    private static final class InitialUsersData
    implements Serializable {
        private static final long serialVersionUID = 0L;
        @GridToStringInclude
        private final ArrayList<User> usrs;
        @GridToStringInclude
        private final ArrayList<UserManagementOperation> activeOps;

        InitialUsersData(Collection<User> usrs, Collection<UserManagementOperation> ops) {
            this.usrs = new ArrayList<User>(usrs);
            this.activeOps = new ArrayList<UserManagementOperation>(ops);
        }

        public String toString() {
            return S.toString(InitialUsersData.class, this);
        }
    }
}

