/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.sampling;

import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Random;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.sampling.DistributedRandomSampler;
import org.apache.flink.api.java.sampling.IntermediateSampleData;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.XORShiftRandom;

@Internal
public class ReservoirSamplerWithoutReplacement<T>
extends DistributedRandomSampler<T> {
    private final Random random;

    public ReservoirSamplerWithoutReplacement(int numSamples, Random random) {
        super(numSamples);
        Preconditions.checkArgument((numSamples >= 0 ? 1 : 0) != 0, (Object)"numSamples should be non-negative.");
        this.random = random;
    }

    public ReservoirSamplerWithoutReplacement(int numSamples) {
        this(numSamples, (Random)new XORShiftRandom());
    }

    public ReservoirSamplerWithoutReplacement(int numSamples, long seed) {
        this(numSamples, (Random)new XORShiftRandom(seed));
    }

    @Override
    public Iterator<IntermediateSampleData<T>> sampleInPartition(Iterator<T> input) {
        if (this.numSamples == 0) {
            return this.EMPTY_INTERMEDIATE_ITERABLE;
        }
        PriorityQueue<IntermediateSampleData<T>> queue = new PriorityQueue<IntermediateSampleData<T>>(this.numSamples);
        int index = 0;
        IntermediateSampleData smallest = null;
        while (input.hasNext()) {
            T element = input.next();
            if (index < this.numSamples) {
                queue.add(new IntermediateSampleData<T>(this.random.nextDouble(), element));
                smallest = (IntermediateSampleData)queue.peek();
            } else {
                double rand = this.random.nextDouble();
                if (rand > smallest.getWeight()) {
                    queue.remove();
                    queue.add(new IntermediateSampleData<T>(rand, element));
                    smallest = (IntermediateSampleData)queue.peek();
                }
            }
            ++index;
        }
        return queue.iterator();
    }
}

