/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.svm;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.ignite.ml.Exportable;
import org.apache.ignite.ml.Exporter;
import org.apache.ignite.ml.Model;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.svm.SVMLinearBinaryClassificationModel;

public class SVMLinearMultiClassClassificationModel
implements Model<Vector, Double>,
Exportable<SVMLinearMultiClassClassificationModel>,
Serializable {
    private static final long serialVersionUID = -667986511191350227L;
    private Map<Double, SVMLinearBinaryClassificationModel> models = new HashMap<Double, SVMLinearBinaryClassificationModel>();

    @Override
    public Double apply(Vector input) {
        TreeMap maxMargins = new TreeMap();
        this.models.forEach((k, v) -> maxMargins.put(input.dot(v.weights()) + v.intercept(), k));
        return (Double)maxMargins.lastEntry().getValue();
    }

    @Override
    public <P> void saveModel(Exporter<SVMLinearMultiClassClassificationModel, P> exporter, P path) {
        exporter.save(this, path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SVMLinearMultiClassClassificationModel mdl = (SVMLinearMultiClassClassificationModel)o;
        return Objects.equals(this.models, mdl.models);
    }

    public int hashCode() {
        return Objects.hash(this.models);
    }

    public String toString() {
        StringBuilder wholeStr = new StringBuilder();
        this.models.forEach((clsLb, mdl) -> wholeStr.append("The class with label ").append(clsLb).append(" has classifier: ").append(mdl.toString()).append(System.lineSeparator()));
        return wholeStr.toString();
    }

    public void add(double clsLb, SVMLinearBinaryClassificationModel mdl) {
        this.models.put(clsLb, mdl);
    }
}

