/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.structures.partition;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.structures.LabeledDataset;
import org.apache.ignite.ml.structures.LabeledVector;

public class LabeledDatasetPartitionDataBuilderOnHeap<K, V, C extends Serializable>
implements PartitionDataBuilder<K, V, C, LabeledDataset<Double, LabeledVector>> {
    private static final long serialVersionUID = -7820760153954269227L;
    private final IgniteBiFunction<K, V, double[]> xExtractor;
    private final IgniteBiFunction<K, V, Double> yExtractor;

    public LabeledDatasetPartitionDataBuilderOnHeap(IgniteBiFunction<K, V, double[]> xExtractor, IgniteBiFunction<K, V, Double> yExtractor) {
        this.xExtractor = xExtractor;
        this.yExtractor = yExtractor;
    }

    @Override
    public LabeledDataset<Double, LabeledVector> build(Iterator<UpstreamEntry<K, V>> upstreamData, long upstreamDataSize, C ctx) {
        int xCols = -1;
        double[][] x = null;
        double[] y = new double[Math.toIntExact(upstreamDataSize)];
        int ptr = 0;
        while (upstreamData.hasNext()) {
            UpstreamEntry<K, V> entry = upstreamData.next();
            double[] row = (double[])this.xExtractor.apply(entry.getKey(), entry.getValue());
            if (xCols < 0) {
                xCols = row.length;
                x = new double[Math.toIntExact(upstreamDataSize)][xCols];
            } else assert (row.length == xCols) : "X extractor must return exactly " + xCols + " columns";
            x[ptr] = row;
            y[ptr] = (Double)this.yExtractor.apply(entry.getKey(), entry.getValue());
            ++ptr;
        }
        return new LabeledDataset<Double, LabeledVector>(x, y);
    }
}

