/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.vector;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.StorageConstants;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.impls.matrix.SparseLocalOnHeapMatrix;
import org.apache.ignite.ml.math.impls.storage.vector.SparseLocalOnHeapVectorStorage;
import org.apache.ignite.ml.math.impls.vector.AbstractVector;

public class SparseLocalVector
extends AbstractVector
implements StorageConstants {
    public SparseLocalVector() {
    }

    public SparseLocalVector(Map<Integer, Double> map, boolean cp) {
        this.setStorage(new SparseLocalOnHeapVectorStorage(map, cp));
    }

    public SparseLocalVector(int size, int acsMode) {
        this.assertAccessMode(acsMode);
        this.setStorage(new SparseLocalOnHeapVectorStorage(size, acsMode));
    }

    private SparseLocalOnHeapVectorStorage storage() {
        return (SparseLocalOnHeapVectorStorage)this.getStorage();
    }

    @Override
    public Vector like(int crd) {
        SparseLocalOnHeapVectorStorage sto = this.storage();
        return new SparseLocalVector(crd, sto.getAccessMode());
    }

    @Override
    public Matrix likeMatrix(int rows, int cols) {
        return new SparseLocalOnHeapMatrix(rows, cols);
    }

    @Override
    public Vector times(double x) {
        if (x == 0.0) {
            return this.assign(0.0);
        }
        return super.times(x);
    }

    public IntSet indexes() {
        return this.storage().indexes();
    }

    @Override
    public Spliterator<Double> nonZeroSpliterator() {
        return new Spliterator<Double>(){

            @Override
            public boolean tryAdvance(Consumer<? super Double> act) {
                IntSet indexes = SparseLocalVector.this.storage().indexes();
                for (Integer index : indexes) {
                    act.accept((Double)SparseLocalVector.this.storageGet(index));
                }
                return true;
            }

            @Override
            public Spliterator<Double> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return SparseLocalVector.this.storage().indexes().size();
            }

            @Override
            public int characteristics() {
                return 80;
            }
        };
    }
}

