/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.vector;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.VectorStorage;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;
import org.apache.ignite.ml.math.impls.matrix.RandomMatrix;
import org.apache.ignite.ml.math.impls.storage.vector.RandomVectorStorage;
import org.apache.ignite.ml.math.impls.vector.AbstractReadOnlyVector;

public class RandomVector
extends AbstractReadOnlyVector {
    private boolean fastHash;

    private VectorStorage mkStorage(int size, boolean fastHash) {
        this.fastHash = fastHash;
        return new RandomVectorStorage(size, fastHash);
    }

    public RandomVector(int size, boolean fastHash) {
        this.setStorage(this.mkStorage(size, fastHash));
    }

    public RandomVector(int size) {
        this(size, true);
    }

    public RandomVector(Map<String, Object> args) {
        assert (args != null);
        if (args.containsKey("size") && args.containsKey("fastHash")) {
            this.setStorage(this.mkStorage((Integer)args.get("size"), (Boolean)args.get("fastHash")));
        } else if (args.containsKey("size")) {
            this.setStorage(this.mkStorage((Integer)args.get("size"), true));
        } else {
            throw new UnsupportedOperationException("Invalid constructor argument(s).");
        }
    }

    public RandomVector() {
    }

    @Override
    public Vector like(int crd) {
        return new RandomVector(crd, this.fastHash);
    }

    @Override
    public Matrix likeMatrix(int rows, int cols) {
        return new RandomMatrix(rows, cols);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.fastHash);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.fastHash = in.readBoolean();
    }

    @Override
    public int hashCode() {
        int res = 1;
        res = res * 37 + Boolean.hashCode(this.fastHash);
        res = res * 37 + this.getStorage().hashCode();
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RandomVector that = (RandomVector)o;
        VectorStorage sto = this.getStorage();
        return this.fastHash == that.fastHash && (sto != null ? sto.equals(that.getStorage()) : that.getStorage() == null);
    }
}

