/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.vector;

import java.util.Map;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.functions.IntDoubleToVoidFunction;
import org.apache.ignite.ml.math.impls.storage.vector.FunctionVectorStorage;
import org.apache.ignite.ml.math.impls.vector.AbstractVector;

public class FunctionVector
extends AbstractVector {
    public FunctionVector() {
    }

    public FunctionVector(int size, IgniteFunction<Integer, Double> getFunc, IntDoubleToVoidFunction setFunc) {
        this.setStorage(new FunctionVectorStorage(size, getFunc, setFunc));
    }

    public FunctionVector(int size, IgniteFunction<Integer, Double> getFunc) {
        this.setStorage(new FunctionVectorStorage(size, getFunc));
    }

    public FunctionVector(Map<String, Object> args) {
        assert (args != null);
        if (args.containsKey("size") && args.containsKey("getFunc") && args.containsKey("setFunc")) {
            IgniteFunction getFunc = (IgniteFunction)args.get("getFunc");
            IntDoubleToVoidFunction setFunc = (IntDoubleToVoidFunction)args.get("setFunc");
            int size = (Integer)args.get("size");
            this.setStorage(new FunctionVectorStorage(size, getFunc, setFunc));
        } else if (args.containsKey("size") && args.containsKey("getFunc")) {
            IgniteFunction getFunc = (IgniteFunction)args.get("getFunc");
            int size = (Integer)args.get("size");
            this.setStorage(new FunctionVectorStorage(size, getFunc));
        } else {
            throw new UnsupportedOperationException("Invalid constructor argument(s).");
        }
    }

    private FunctionVectorStorage storage() {
        return (FunctionVectorStorage)this.getStorage();
    }

    @Override
    public Vector like(int crd) {
        FunctionVectorStorage sto = this.storage();
        return new FunctionVector(crd, sto.getFunction(), sto.setFunction());
    }

    @Override
    public Matrix likeMatrix(int rows, int cols) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Vector times(double x) {
        if (x == 0.0) {
            return this.like(this.size()).assign(0.0);
        }
        return super.times(x);
    }
}

