/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.vector;

import java.util.Map;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.VectorStorage;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;
import org.apache.ignite.ml.math.impls.matrix.DenseLocalOnHeapMatrix;
import org.apache.ignite.ml.math.impls.storage.vector.ArrayVectorStorage;
import org.apache.ignite.ml.math.impls.vector.AbstractVector;

public class DenseLocalOnHeapVector
extends AbstractVector {
    private VectorStorage mkStorage(int size) {
        return new ArrayVectorStorage(size);
    }

    private VectorStorage mkStorage(double[] arr, boolean cp) {
        assert (arr != null);
        return new ArrayVectorStorage(cp ? (double[])arr.clone() : arr);
    }

    public DenseLocalOnHeapVector(Map<String, Object> args) {
        assert (args != null);
        if (args.containsKey("size")) {
            this.setStorage(this.mkStorage((Integer)args.get("size")));
        } else if (args.containsKey("arr") && args.containsKey("copy")) {
            this.setStorage(this.mkStorage((double[])args.get("arr"), (Boolean)args.get("copy")));
        } else {
            throw new UnsupportedOperationException("Invalid constructor argument(s).");
        }
    }

    public DenseLocalOnHeapVector() {
    }

    public DenseLocalOnHeapVector(int size) {
        this.setStorage(this.mkStorage(size));
    }

    public DenseLocalOnHeapVector(double[] arr, boolean shallowCp) {
        this.setStorage(this.mkStorage(arr, shallowCp));
    }

    public DenseLocalOnHeapVector(double[] arr) {
        this(arr, false);
    }

    @Override
    public Matrix likeMatrix(int rows, int cols) {
        return new DenseLocalOnHeapMatrix(rows, cols);
    }

    @Override
    public Vector like(int crd) {
        return new DenseLocalOnHeapVector(crd);
    }
}

