/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.vector;

import java.util.stream.IntStream;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.impls.matrix.DenseLocalOffHeapMatrix;
import org.apache.ignite.ml.math.impls.storage.vector.DenseLocalOffHeapVectorStorage;
import org.apache.ignite.ml.math.impls.vector.AbstractVector;

public class DenseLocalOffHeapVector
extends AbstractVector {
    public DenseLocalOffHeapVector() {
    }

    private void makeOffheapStorage(int size) {
        this.setStorage(new DenseLocalOffHeapVectorStorage(size));
    }

    public DenseLocalOffHeapVector(double[] arr) {
        this.makeOffheapStorage(arr.length);
        this.assign(arr);
    }

    public DenseLocalOffHeapVector(int size) {
        this.makeOffheapStorage(size);
    }

    @Override
    public Vector assign(Vector vec) {
        this.checkCardinality(vec);
        IntStream.range(0, this.size()).parallel().forEach(idx -> this.set(idx, vec.get(idx)));
        return this;
    }

    @Override
    public Vector times(double x) {
        if (x == 0.0) {
            return this.like(this.size()).assign(0.0);
        }
        return super.times(x);
    }

    @Override
    public Vector like(int crd) {
        return new DenseLocalOffHeapVector(crd);
    }

    @Override
    public Matrix likeMatrix(int rows, int cols) {
        return new DenseLocalOffHeapMatrix(rows, cols);
    }

    @Override
    public boolean equals(Object o) {
        return o != null && this.getClass().equals(o.getClass()) && this.getStorage().equals(((Vector)o).getStorage());
    }
}

