/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.storage.vector;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.ml.math.StorageConstants;
import org.apache.ignite.ml.math.VectorStorage;
import org.apache.ignite.ml.math.distributed.CacheUtils;
import org.apache.ignite.ml.math.distributed.DistributedStorage;
import org.apache.ignite.ml.math.distributed.keys.RowColMatrixKey;
import org.apache.ignite.ml.math.distributed.keys.impl.SparseMatrixKey;

public class SparseDistributedVectorStorage
extends CacheUtils
implements VectorStorage,
StorageConstants,
DistributedStorage<RowColMatrixKey> {
    private static final String CACHE_NAME = "ML_SPARSE_VECTORS_CONTAINER";
    private int size;
    private int acsMode;
    private UUID uuid;
    private IgniteCache<RowColMatrixKey, Double> cache = null;

    public SparseDistributedVectorStorage() {
    }

    public SparseDistributedVectorStorage(int size, int acsMode) {
        assert (size > 0);
        this.assertAccessMode(acsMode);
        this.size = size;
        this.acsMode = acsMode;
        this.cache = this.newCache();
        this.uuid = UUID.randomUUID();
    }

    private IgniteCache<RowColMatrixKey, Double> newCache() {
        CacheConfiguration cfg = new CacheConfiguration();
        cfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.PRIMARY_SYNC);
        cfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        cfg.setEvictionPolicy(null);
        cfg.setCopyOnRead(false);
        cfg.setCacheMode(CacheMode.PARTITIONED);
        cfg.setName(CACHE_NAME);
        return Ignition.localIgnite().getOrCreateCache(cfg);
    }

    public IgniteCache<RowColMatrixKey, Double> cache() {
        return this.cache;
    }

    public int accessMode() {
        return this.acsMode;
    }

    @Override
    public double get(int i) {
        return (Double)SparseDistributedVectorStorage.ignite().compute(SparseDistributedVectorStorage.getClusterGroupForGivenKey(CACHE_NAME, this.getCacheKey(i))).call((IgniteCallable & Serializable)() -> {
            IgniteCache cache = Ignition.localIgnite().getOrCreateCache(CACHE_NAME);
            Double res = (Double)cache.get((Object)this.getCacheKey(i));
            if (res == null) {
                return 0.0;
            }
            return res;
        });
    }

    @Override
    public void set(int i, double v) {
        SparseDistributedVectorStorage.ignite().compute(SparseDistributedVectorStorage.getClusterGroupForGivenKey(CACHE_NAME, this.getCacheKey(i))).run((IgniteRunnable & Serializable)() -> {
            IgniteCache cache = Ignition.localIgnite().getOrCreateCache(CACHE_NAME);
            RowColMatrixKey cacheKey = this.getCacheKey(i);
            if (v != 0.0) {
                cache.put((Object)cacheKey, (Object)v);
            } else if (cache.containsKey((Object)cacheKey)) {
                cache.remove((Object)cacheKey);
            }
        });
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.acsMode);
        out.writeObject(this.uuid);
        out.writeUTF(this.cache.getName());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.acsMode = in.readInt();
        this.uuid = (UUID)in.readObject();
        this.cache = SparseDistributedVectorStorage.ignite().getOrCreateCache(in.readUTF());
    }

    @Override
    public boolean isSequentialAccess() {
        return this.acsMode == 1001;
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean isRandomAccess() {
        return this.acsMode == 1002;
    }

    @Override
    public boolean isDistributed() {
        return true;
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    @Override
    public void destroy() {
        Set keyset = IntStream.range(0, this.size).mapToObj(this::getCacheKey).collect(Collectors.toSet());
        this.cache.clearAll(keyset);
    }

    public RowColMatrixKey getCacheKey(int idx) {
        return new SparseMatrixKey(idx, this.uuid, null);
    }

    @Override
    public Set<RowColMatrixKey> getAllKeys() {
        int range = this.size;
        return IntStream.range(0, range).mapToObj(i -> new SparseMatrixKey(i, this.getUUID(), null)).collect(Collectors.toSet());
    }

    @Override
    public String cacheName() {
        return CACHE_NAME;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public double[] data() {
        double[] res = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            res[i] = this.get(i);
        }
        return res;
    }

    public int hashCode() {
        int res = 1;
        res = res * 37 + this.size;
        res = res * 37 + this.acsMode;
        res = res * 37 + this.uuid.hashCode();
        res = res * 37 + this.cache.hashCode();
        return res;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SparseDistributedVectorStorage that = (SparseDistributedVectorStorage)obj;
        return this.size == that.size && this.acsMode == that.acsMode && this.uuid.equals(that.uuid) && (this.cache != null ? this.cache.equals(that.cache) : that.cache == null);
    }
}

