/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.storage.vector;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.ignite.ml.math.MurmurHash;
import org.apache.ignite.ml.math.VectorStorage;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;

public class RandomVectorStorage
implements VectorStorage {
    private static final long SCALE = 0x100000000L;
    private static final int PRIME = 104047;
    private int seed;
    private int size;
    private boolean fastHash;

    public RandomVectorStorage() {
    }

    public RandomVectorStorage(int size, boolean fastHash) {
        assert (size > 0);
        this.size = size;
        this.fastHash = fastHash;
        this.seed = new Random().nextInt();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public double get(int i) {
        if (!this.fastHash) {
            ByteBuffer buf = ByteBuffer.allocate(4);
            buf.putInt(i);
            buf.flip();
            return (double)(MurmurHash.hash64A(buf, this.seed) & 0xFFFFFFFFL) / 4.294967296E9;
        }
        return (double)(i * 104047 & 8) * 0.25 - 1.0;
    }

    @Override
    public void set(int i, double v) {
        throw new UnsupportedOperationException("Random vector storage is a read-only storage.");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.seed);
        out.writeBoolean(this.fastHash);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.seed = in.readInt();
        this.fastHash = in.readBoolean();
    }

    @Override
    public boolean isSequentialAccess() {
        return true;
    }

    @Override
    public boolean isDense() {
        return true;
    }

    @Override
    public boolean isRandomAccess() {
        return true;
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    public int hashCode() {
        int res = 1;
        res = res * 37 + Boolean.hashCode(this.fastHash);
        res = res * 37 + this.seed;
        res = res * 37 + this.size;
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RandomVectorStorage that = (RandomVectorStorage)o;
        return this.size == that.size && this.seed == that.seed && this.fastHash == that.fastHash;
    }
}

