/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.storage.matrix;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.ignite.ml.math.MatrixStorage;
import org.apache.ignite.ml.math.MurmurHash;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;

public class RandomMatrixStorage
implements MatrixStorage {
    private static final int PRIME1 = 104047;
    private static final int PRIME2 = 101377;
    private static final int PRIME3 = 64661;
    private static final long SCALE = 0x100000000L;
    private int seed;
    private int rows;
    private int cols;
    private boolean fastHash;

    public RandomMatrixStorage() {
    }

    public RandomMatrixStorage(int rows, int cols, boolean fastHash) {
        assert (rows > 0);
        assert (cols > 0);
        this.rows = rows;
        this.cols = cols;
        this.fastHash = fastHash;
    }

    @Override
    public double get(int x, int y) {
        if (!this.fastHash) {
            ByteBuffer buf = ByteBuffer.allocate(8);
            buf.putInt(x);
            buf.putInt(y);
            buf.flip();
            return (double)(MurmurHash.hash64A(buf, this.seed) & 0xFFFFFFFFL) / 4.294967296E9;
        }
        return (double)(x * 104047 + y * 101377 + x * y * 64661 & 8) * 0.25 - 1.0;
    }

    public boolean isFastHash() {
        return this.fastHash;
    }

    @Override
    public void set(int x, int y, double v) {
        throw new UnsupportedOperationException("Random matrix storage is a read-only storage.");
    }

    @Override
    public int columnSize() {
        return this.cols;
    }

    @Override
    public int rowSize() {
        return this.rows;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.rows);
        out.writeInt(this.cols);
        out.writeInt(this.seed);
        out.writeBoolean(this.fastHash);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rows = in.readInt();
        this.cols = in.readInt();
        this.seed = in.readInt();
        this.fastHash = in.readBoolean();
    }

    @Override
    public boolean isSequentialAccess() {
        return false;
    }

    @Override
    public boolean isDense() {
        return true;
    }

    @Override
    public boolean isRandomAccess() {
        return true;
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    @Override
    public int storageMode() {
        return 3001;
    }

    @Override
    public int accessMode() {
        return 1002;
    }

    public int hashCode() {
        int res = 1;
        res = res * 37 + Boolean.hashCode(this.fastHash);
        res = res * 37 + this.seed;
        res = res * 37 + this.cols;
        res = res * 37 + this.rows;
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RandomMatrixStorage that = (RandomMatrixStorage)o;
        return this.rows == that.rows && this.cols == that.cols && this.seed == that.seed && this.fastHash == that.fastHash;
    }
}

