/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.storage.matrix;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.util.GridArgumentCheck;
import org.apache.ignite.ml.math.VectorStorage;

public class MapWrapperStorage
implements VectorStorage {
    private Map<Integer, Double> data;
    private int size;

    public MapWrapperStorage(Map<Integer, Double> map) {
        this.data = map;
        Set<Integer> keys = map.keySet();
        GridArgumentCheck.notEmpty(keys, (String)"map");
        Integer min = keys.stream().mapToInt(Integer::valueOf).min().getAsInt();
        Integer max = keys.stream().mapToInt(Integer::valueOf).max().getAsInt();
        assert (min >= 0);
        this.size = max - min + 1;
    }

    public MapWrapperStorage() {
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public double get(int i) {
        return this.data.getOrDefault(i, 0.0);
    }

    @Override
    public void set(int i, double v) {
        if (v != 0.0) {
            this.data.put(i, v);
        } else if (this.data.containsKey(i)) {
            this.data.remove(i);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.data);
        out.writeInt(this.size);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.data = (Map)in.readObject();
        this.size = in.readInt();
    }

    @Override
    public boolean isSequentialAccess() {
        return false;
    }

    @Override
    public boolean isRandomAccess() {
        return true;
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    @Override
    public boolean isDistributed() {
        return false;
    }
}

