/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.storage.matrix;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.ml.math.MatrixStorage;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;
import org.apache.ignite.ml.math.functions.IntIntDoubleToVoidFunction;
import org.apache.ignite.ml.math.functions.IntIntToDoubleFunction;

public class FunctionMatrixStorage
implements MatrixStorage {
    private int rows;
    private int cols;
    private IntIntToDoubleFunction getFunc;
    private IntIntDoubleToVoidFunction setFunc;

    public FunctionMatrixStorage() {
    }

    public FunctionMatrixStorage(int rows, int cols, IntIntToDoubleFunction getFunc, IntIntDoubleToVoidFunction setFunc) {
        assert (rows > 0);
        assert (cols > 0);
        assert (getFunc != null);
        this.rows = rows;
        this.cols = cols;
        this.getFunc = getFunc;
        this.setFunc = setFunc;
    }

    public FunctionMatrixStorage(int rows, int cols, IntIntToDoubleFunction getFunc) {
        this(rows, cols, getFunc, null);
    }

    @Override
    public double get(int x, int y) {
        return (Double)this.getFunc.apply(x, y);
    }

    @Override
    public void set(int x, int y, double v) {
        if (this.setFunc == null) {
            throw new UnsupportedOperationException("Cannot set into read-only matrix.");
        }
        this.setFunc.apply(x, y, v);
    }

    public IntIntToDoubleFunction getFunction() {
        return this.getFunc;
    }

    public IntIntDoubleToVoidFunction setFunction() {
        return this.setFunc;
    }

    @Override
    public int columnSize() {
        return this.cols;
    }

    @Override
    public int rowSize() {
        return this.rows;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.setFunc);
        out.writeObject(this.getFunc);
        out.writeInt(this.rows);
        out.writeInt(this.cols);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setFunc = (IntIntDoubleToVoidFunction)in.readObject();
        this.getFunc = (IntIntToDoubleFunction)in.readObject();
        this.rows = in.readInt();
        this.cols = in.readInt();
    }

    @Override
    public boolean isSequentialAccess() {
        return false;
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean isRandomAccess() {
        return false;
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    @Override
    public int storageMode() {
        return 3001;
    }

    @Override
    public int accessMode() {
        return 1002;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionMatrixStorage that = (FunctionMatrixStorage)o;
        return this.rows == that.rows && this.cols == that.cols && (this.getFunc != null ? this.getFunc.equals(that.getFunc) : that.getFunc == null) && (this.setFunc != null ? this.setFunc.equals(that.setFunc) : that.setFunc == null);
    }

    public int hashCode() {
        int res = this.rows;
        res = 31 * res + this.cols;
        res = 31 * res + (this.getFunc != null ? this.getFunc.hashCode() : 0);
        res = 31 * res + (this.setFunc != null ? this.setFunc.hashCode() : 0);
        return res;
    }
}

