/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.storage.matrix;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.ml.math.MatrixStorage;
import org.apache.ignite.ml.math.distributed.MatrixKeyMapper;
import org.apache.ignite.ml.math.distributed.ValueMapper;

public class CacheMatrixStorage<K, V>
implements MatrixStorage {
    private int rows;
    private int cols;
    private IgniteCache<K, V> cache;
    private MatrixKeyMapper<K> keyMapper;
    private ValueMapper<V> valMapper;

    public CacheMatrixStorage() {
    }

    public CacheMatrixStorage(int rows, int cols, IgniteCache<K, V> cache, MatrixKeyMapper<K> keyMapper, ValueMapper<V> valMapper) {
        assert (rows > 0);
        assert (cols > 0);
        assert (cache != null);
        assert (keyMapper != null);
        assert (valMapper != null);
        this.rows = rows;
        this.cols = cols;
        this.cache = cache;
        this.keyMapper = keyMapper;
        this.valMapper = valMapper;
    }

    public IgniteCache<K, V> cache() {
        return this.cache;
    }

    public MatrixKeyMapper<K> keyMapper() {
        return this.keyMapper;
    }

    public ValueMapper<V> valueMapper() {
        return this.valMapper;
    }

    @Override
    public double get(int x, int y) {
        return this.valMapper.toDouble(this.cache.get(this.keyMapper.apply(x, y)));
    }

    @Override
    public void set(int x, int y, double v) {
        this.cache.put(this.keyMapper.apply(x, y), this.valMapper.fromDouble(v));
    }

    @Override
    public int columnSize() {
        return this.cols;
    }

    @Override
    public int rowSize() {
        return this.rows;
    }

    @Override
    public int storageMode() {
        return 2001;
    }

    @Override
    public int accessMode() {
        return 1002;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.rows);
        out.writeInt(this.cols);
        out.writeUTF(this.cache.getName());
        out.writeObject(this.keyMapper);
        out.writeObject(this.valMapper);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rows = in.readInt();
        this.cols = in.readInt();
        this.cache = Ignition.localIgnite().getOrCreateCache(in.readUTF());
        this.keyMapper = (MatrixKeyMapper)in.readObject();
        this.valMapper = (ValueMapper)in.readObject();
    }

    @Override
    public boolean isSequentialAccess() {
        return false;
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean isRandomAccess() {
        return true;
    }

    @Override
    public boolean isDistributed() {
        return true;
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    public int hashCode() {
        int res = 1;
        res = res * 37 + this.rows;
        res = res * 37 + this.cols;
        res = res * 37 + this.cache.hashCode();
        res = res * 37 + this.keyMapper.hashCode();
        res = res * 37 + this.valMapper.hashCode();
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheMatrixStorage that = (CacheMatrixStorage)o;
        return (this.cache != null ? this.cache.equals(that.cache) : that.cache == null) && (this.keyMapper != null ? this.keyMapper.equals(that.keyMapper) : that.keyMapper == null) && (this.valMapper != null ? this.valMapper.equals(that.valMapper) : that.valMapper == null);
    }
}

