/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.matrix;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.MatrixStorage;
import org.apache.ignite.ml.math.StorageConstants;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.functions.IgniteTriFunction;
import org.apache.ignite.ml.math.impls.matrix.AbstractMatrix;
import org.apache.ignite.ml.math.impls.storage.matrix.SparseLocalOnHeapMatrixStorage;
import org.apache.ignite.ml.math.impls.vector.SparseLocalVector;

public class SparseLocalOnHeapMatrix
extends AbstractMatrix
implements StorageConstants {
    public SparseLocalOnHeapMatrix() {
    }

    public SparseLocalOnHeapMatrix(int rows, int cols) {
        this.setStorage(this.mkStorage(rows, cols));
    }

    private MatrixStorage mkStorage(int rows, int cols) {
        return new SparseLocalOnHeapMatrixStorage(rows, cols, 1002, 2001);
    }

    @Override
    public Matrix like(int rows, int cols) {
        return new SparseLocalOnHeapMatrix(rows, cols);
    }

    @Override
    public Vector likeVector(int crd) {
        return new SparseLocalVector(crd, 1002);
    }

    @Override
    public int nonZeroElements() {
        int res = 0;
        IntIterator rowIter = this.indexesMap().keySet().iterator();
        while (rowIter.hasNext()) {
            int row = rowIter.nextInt();
            res += ((IntSet)this.indexesMap().get(row)).size();
        }
        return res;
    }

    public Int2ObjectArrayMap<IntSet> indexesMap() {
        return ((SparseLocalOnHeapMatrixStorage)this.getStorage()).indexesMap();
    }

    @Override
    public Matrix copy() {
        Matrix cp = this.like(this.rowSize(), this.columnSize());
        cp.assign(this);
        return cp;
    }

    @Override
    public void compute(int row, int col, IgniteTriFunction<Integer, Integer, Double, Double> f) {
        ((SparseLocalOnHeapMatrixStorage)this.getStorage()).compute(row, col, f);
    }
}

