/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.matrix;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.StorageConstants;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.distributed.CacheUtils;
import org.apache.ignite.ml.math.exceptions.CardinalityException;
import org.apache.ignite.ml.math.functions.IgniteDoubleFunction;
import org.apache.ignite.ml.math.impls.matrix.AbstractMatrix;
import org.apache.ignite.ml.math.impls.storage.matrix.SparseDistributedMatrixStorage;
import org.apache.ignite.ml.math.impls.storage.vector.SparseDistributedVectorStorage;
import org.apache.ignite.ml.math.impls.vector.SparseDistributedVector;

public class SparseDistributedMatrix
extends AbstractMatrix
implements StorageConstants {
    public SparseDistributedMatrix() {
    }

    public SparseDistributedMatrix(int rows, int cols, int stoMode, int acsMode) {
        assert (rows > 0);
        assert (cols > 0);
        this.assertAccessMode(acsMode);
        this.assertStorageMode(stoMode);
        this.setStorage(new SparseDistributedMatrixStorage(rows, cols, stoMode, acsMode));
    }

    public SparseDistributedMatrix(double[][] data) {
        assert (data.length > 0);
        this.setStorage(new SparseDistributedMatrixStorage(data.length, this.getMaxAmountOfColumns(data), 2001, 1002));
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                this.storage().set(i, j, data[i][j]);
            }
        }
    }

    public SparseDistributedMatrix(int rows, int cols) {
        this(rows, cols, 2001, 1002);
    }

    private SparseDistributedMatrixStorage storage() {
        return (SparseDistributedMatrixStorage)this.getStorage();
    }

    @Override
    public Matrix divide(double d) {
        return this.mapOverValues(v -> v / d);
    }

    @Override
    public Matrix plus(double x) {
        return this.mapOverValues(v -> v + x);
    }

    @Override
    public Matrix times(double x) {
        return this.mapOverValues(v -> v * x);
    }

    @Override
    public Matrix times(Matrix mtx) {
        if (mtx == null) {
            throw new IllegalArgumentException("The matrix should be not null.");
        }
        if (this.columnSize() != mtx.rowSize()) {
            throw new CardinalityException(this.columnSize(), mtx.rowSize());
        }
        SparseDistributedMatrix matrixA = this;
        SparseDistributedMatrix matrixB = (SparseDistributedMatrix)mtx;
        String cacheName = this.storage().cacheName();
        SparseDistributedMatrix matrixC = new SparseDistributedMatrix(matrixA.rowSize(), matrixB.columnSize(), this.getStorage().storageMode(), this.getStorage().isRandomAccess() ? 1002 : 1001);
        CacheUtils.bcast(cacheName, (IgniteRunnable & Serializable)() -> {
            boolean isRowMode;
            Ignite ignite = Ignition.localIgnite();
            Affinity affinity = ignite.affinity(cacheName);
            ClusterNode locNode = ignite.cluster().localNode();
            SparseDistributedMatrixStorage storageC = matrixC.storage();
            Map keysCToNodes = affinity.mapKeysToNodes(storageC.getAllKeys());
            Collection locKeys = (Collection)keysCToNodes.get(locNode);
            boolean bl = isRowMode = storageC.storageMode() == 2001;
            if (locKeys == null) {
                return;
            }
            locKeys.forEach(key -> {
                int idx = key.index();
                if (isRowMode) {
                    Vector Aik = matrixA.getRow(idx);
                    for (int i = 0; i < matrixB.columnSize(); ++i) {
                        Vector Bkj = matrixB.getCol(i);
                        matrixC.set(idx, i, Aik.times(Bkj).sum());
                    }
                } else {
                    Vector Bkj = matrixB.getCol(idx);
                    for (int i = 0; i < matrixA.rowSize(); ++i) {
                        Vector Aik = matrixA.getRow(i);
                        matrixC.set(idx, i, Aik.times(Bkj).sum());
                    }
                }
            });
        });
        return matrixC;
    }

    @Override
    public Vector times(Vector vec) {
        if (vec == null) {
            throw new IllegalArgumentException("The vector should be not null.");
        }
        if (this.columnSize() != vec.size()) {
            throw new CardinalityException(this.columnSize(), vec.size());
        }
        SparseDistributedMatrix matrixA = this;
        SparseDistributedVector vectorB = (SparseDistributedVector)vec;
        String cacheName = this.storage().cacheName();
        int rows = this.rowSize();
        SparseDistributedVector vectorC = (SparseDistributedVector)this.likeVector(rows);
        CacheUtils.bcast(cacheName, (IgniteRunnable & Serializable)() -> {
            Ignite ignite = Ignition.localIgnite();
            Affinity affinity = ignite.affinity(cacheName);
            ClusterNode locNode = ignite.cluster().localNode();
            SparseDistributedVectorStorage storageC = vectorC.storage();
            Map keysCToNodes = affinity.mapKeysToNodes(storageC.getAllKeys());
            Collection locKeys = (Collection)keysCToNodes.get(locNode);
            if (locKeys == null) {
                return;
            }
            locKeys.forEach(key -> {
                int idx = key.index();
                Vector Aik = matrixA.getRow(idx);
                vectorC.set(idx, Aik.times(vectorB).sum());
            });
        });
        return vectorC;
    }

    @Override
    public Matrix assign(double val) {
        return this.mapOverValues(v -> val);
    }

    @Override
    public Matrix map(IgniteDoubleFunction<Double> fun) {
        return this.mapOverValues(fun);
    }

    private Matrix mapOverValues(IgniteDoubleFunction<Double> mapper) {
        CacheUtils.sparseMap(this.getUUID(), mapper, this.storage().cacheName());
        return this;
    }

    @Override
    public double sum() {
        return CacheUtils.sparseSum(this.getUUID(), this.storage().cacheName());
    }

    @Override
    public double maxValue() {
        return CacheUtils.sparseMax(this.getUUID(), this.storage().cacheName());
    }

    @Override
    public double minValue() {
        return CacheUtils.sparseMin(this.getUUID(), this.storage().cacheName());
    }

    @Override
    public Matrix copy() {
        Matrix cp = this.like(this.rowSize(), this.columnSize());
        cp.assign(this);
        return cp;
    }

    @Override
    public Matrix like(int rows, int cols) {
        if (this.storage() == null) {
            return new SparseDistributedMatrix(rows, cols);
        }
        return new SparseDistributedMatrix(rows, cols, this.storage().storageMode(), this.storage().accessMode());
    }

    @Override
    public Vector likeVector(int crd) {
        return new SparseDistributedVector(crd, 1002);
    }

    public UUID getUUID() {
        return ((SparseDistributedMatrixStorage)this.getStorage()).getUUID();
    }
}

