/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.matrix;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.exceptions.IndexException;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;
import org.apache.ignite.ml.math.impls.matrix.AbstractMatrix;
import org.apache.ignite.ml.math.impls.storage.matrix.PivotedMatrixStorage;
import org.apache.ignite.ml.math.impls.vector.PivotedVectorView;

public class PivotedMatrixView
extends AbstractMatrix {
    private Matrix mtx;

    public PivotedMatrixView() {
    }

    public PivotedMatrixView(Matrix mtx, int[] rowPivot, int[] colPivot) {
        super(new PivotedMatrixStorage(mtx == null ? null : mtx.getStorage(), rowPivot, colPivot));
        this.mtx = mtx;
    }

    public PivotedMatrixView(Matrix mtx) {
        super(new PivotedMatrixStorage(mtx == null ? null : mtx.getStorage()));
        this.mtx = mtx;
    }

    public PivotedMatrixView(Matrix mtx, int[] pivot) {
        super(new PivotedMatrixStorage(mtx == null ? null : mtx.getStorage(), pivot));
        this.mtx = mtx;
    }

    public Matrix swap(int i, int j) {
        this.swapRows(i, j);
        this.swapColumns(i, j);
        return this;
    }

    @Override
    public Matrix swapRows(int i, int j) {
        if (i < 0 || i >= this.storage().rowPivot().length) {
            throw new IndexException(i);
        }
        if (j < 0 || j >= this.storage().rowPivot().length) {
            throw new IndexException(j);
        }
        this.storage().swapRows(i, j);
        return this;
    }

    @Override
    public Matrix swapColumns(int i, int j) {
        if (i < 0 || i >= this.storage().columnPivot().length) {
            throw new IndexException(i);
        }
        if (j < 0 || j >= this.storage().columnPivot().length) {
            throw new IndexException(j);
        }
        this.storage().swapColumns(i, j);
        return this;
    }

    @Override
    public Vector viewRow(int row) {
        return new PivotedVectorView(this.mtx.viewRow(this.storage().rowPivot()[row]), this.storage().columnPivot(), this.storage().columnUnpivot());
    }

    @Override
    public Vector viewColumn(int col) {
        return new PivotedVectorView(this.mtx.viewColumn(this.storage().columnPivot()[col]), this.storage().rowPivot(), this.storage().rowUnpivot());
    }

    public Matrix getBaseMatrix() {
        return this.mtx;
    }

    public int[] rowPivot() {
        return this.storage().rowPivot();
    }

    public int[] columnPivot() {
        return this.storage().columnPivot();
    }

    public int rowPivot(int i) {
        return this.storage().rowPivot()[i];
    }

    public int columnPivot(int i) {
        return this.storage().columnPivot()[i];
    }

    public int rowUnpivot(int i) {
        return this.storage().rowUnpivot()[i];
    }

    public int columnUnpivot(int i) {
        return this.storage().columnUnpivot()[i];
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.mtx);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.mtx = (Matrix)in.readObject();
    }

    private PivotedMatrixStorage storage() {
        return (PivotedMatrixStorage)this.getStorage();
    }

    @Override
    public Matrix copy() {
        return new PivotedMatrixView(this.mtx, this.storage().rowPivot(), this.storage().columnPivot());
    }

    @Override
    public Matrix like(int rows, int cols) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Vector likeVector(int crd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        int res = 1;
        res = res * 37 + this.mtx.hashCode();
        res = res * 37 + this.getStorage().hashCode();
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PivotedMatrixView that = (PivotedMatrixView)o;
        PivotedMatrixStorage sto = this.storage();
        return this.mtx.equals(that.mtx) && ((Object)sto).equals(that.storage());
    }
}

