/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.matrix;

import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.exceptions.CardinalityException;
import org.apache.ignite.ml.math.impls.matrix.AbstractMatrix;
import org.apache.ignite.ml.math.impls.storage.matrix.DenseOffHeapMatrixStorage;
import org.apache.ignite.ml.math.impls.vector.DenseLocalOffHeapVector;

public class DenseLocalOffHeapMatrix
extends AbstractMatrix {
    public DenseLocalOffHeapMatrix() {
    }

    public DenseLocalOffHeapMatrix(double[][] data) {
        assert (data != null);
        this.setStorage(new DenseOffHeapMatrixStorage(data));
    }

    public DenseLocalOffHeapMatrix(int rows, int cols) {
        assert (rows > 0);
        assert (cols > 0);
        this.setStorage(new DenseOffHeapMatrixStorage(rows, cols));
    }

    @Override
    public Matrix copy() {
        DenseLocalOffHeapMatrix cp = new DenseLocalOffHeapMatrix(this.getStorage().rowSize(), this.getStorage().columnSize());
        cp.assign(this);
        return cp;
    }

    @Override
    public Matrix like(int rows, int cols) {
        return new DenseLocalOffHeapMatrix(rows, cols);
    }

    @Override
    public Vector likeVector(int crd) {
        return new DenseLocalOffHeapVector(crd);
    }

    @Override
    protected Matrix likeIdentity() {
        int n = this.rowSize();
        Matrix res = this.like(n, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                res.setX(i, j, i == j ? 1.0 : 0.0);
            }
        }
        return res;
    }

    @Override
    public Matrix times(Matrix mtx) {
        int cols = this.columnSize();
        if (cols != mtx.rowSize()) {
            throw new CardinalityException(cols, mtx.rowSize());
        }
        int rows = this.rowSize();
        int mtxCols = mtx.columnSize();
        Matrix res = this.like(rows, mtxCols);
        for (int x = 0; x < rows; ++x) {
            for (int y = 0; y < mtxCols; ++y) {
                double sum = 0.0;
                for (int k = 0; k < cols; ++k) {
                    sum += this.getX(x, k) * mtx.getX(k, y);
                }
                res.setX(x, y, sum);
            }
        }
        return res;
    }
}

